/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.gx.BBrush;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDynamicEnumFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BDynamicEnumFE.class);
    private BTextDropDown combo = new BTextDropDown("", 15, true);
    private BEnum val;
    private BEnumRange range;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDynamicEnumFE() {
        this.combo.getEditor().setRenderer((TextRenderer)new Renderer());
        this.setContent((BWidget)this.combo);
        this.linkTo("lk0", (BComponent)this.combo, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.combo, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.combo.getEditor().setEditable(!readonly);
        this.combo.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BEnumRange r;
        this.val = (BEnum)v;
        this.range = this.val.getRange();
        if (cx != null && (r = (BEnumRange)cx.getFacet("range")) != null) {
            this.range = r;
        }
        int maxLen = 5;
        this.combo.getList().removeAllItems();
        int[] ordinals = this.range.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            this.combo.getList().addItem((Object)displayTag);
            maxLen = Math.max(maxLen, displayTag.length());
        }
        this.combo.getEditor().setVisibleColumns(maxLen);
        this.combo.setText(this.range.getDisplayTag(this.val.getOrdinal(), null));
        this.doSetReadonly(this.isReadonly());
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) {
        int ordinal = this.saveToOrdinal();
        return BDynamicEnum.make((int)ordinal, (BEnumRange)this.range);
    }

    int saveToOrdinal() {
        String tag = this.combo.getText();
        int[] ordinals = this.range.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            if (!tag.equals(displayTag)) continue;
            return ordinal;
        }
        if (tag.startsWith("0x")) {
            return Integer.parseInt(tag.substring(2), 16);
        }
        return Integer.parseInt(tag);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BDynamicEnumFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BDynamicEnumFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BDynamicEnumFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BDynamicEnumFE.this.fg;
        }
    }
}

