/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="modified")
public class BChangePasswordFE
extends BWbFieldEditor {
    public static final Action modified = BChangePasswordFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BChangePasswordFE.class);
    private static BIcon ICON_WARNING = BIcon.std((String)"warning.png");
    private static final BPassword BLANK_PASSWORD = BPassword.make((String)"");
    private static final Logger LOG = Logger.getLogger("workbench");
    private Lexicon lex = Lexicon.make((String)"workbench");
    private BPassword actualCurrentPassword = null;
    private BPasswordFE currentPasswordFE = new BPasswordFE();
    private BPasswordFE newPasswordFE = new BPasswordFE();
    private BPasswordFE confirmNewPasswordFE = new BPasswordFE();
    private BLabel newPasswordIndicator;
    private BLabel confirmNewPasswordIndicator;
    private final Object[] passwordTermArgument;
    private final BPasswordStrength passwordStrength;

    public void modified() {
        this.invoke(modified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BChangePasswordFE(BPasswordStrength passwordStrength) {
        this(passwordStrength, null);
    }

    public BChangePasswordFE(BPasswordStrength passwordStrength, String passwordTerm) {
        this.passwordStrength = passwordStrength;
        this.passwordTermArgument = new Object[]{passwordTerm != null ? passwordTerm : this.lex.getText("changePassword.passwordTextValue.default")};
        this.newPasswordIndicator = new BLabel(BImage.make((BIcon)ICON_WARNING), this.lex.getText("changePasswordFE.new.requirementsNotMet", this.passwordTermArgument));
        this.confirmNewPasswordIndicator = new BLabel(BImage.make((BIcon)ICON_WARNING), this.lex.getText("changePasswordFE.confirm.notConfirmed", this.passwordTermArgument));
        BGridPane passwordPane = new BGridPane(3);
        LabelUtil.addLabelWidgetPair((BPane)passwordPane, (String)this.lex.getText("changePasswordFE.current.label", this.passwordTermArgument), (BWidget)this.currentPasswordFE);
        passwordPane.add(null, (BValue)new BNullWidget());
        LabelUtil.addLabelWidgetPair((BPane)passwordPane, (String)this.lex.getText("changePasswordFE.new.label", this.passwordTermArgument), (BWidget)this.newPasswordFE);
        passwordPane.add(null, (BValue)this.newPasswordIndicator);
        LabelUtil.addLabelWidgetPair((BPane)passwordPane, (String)this.lex.getText("changePasswordFE.confirm.label", this.passwordTermArgument), (BWidget)this.confirmNewPasswordFE);
        this.confirmNewPasswordIndicator.setVisible(false);
        passwordPane.add(null, (BValue)this.confirmNewPasswordIndicator);
        this.linkTo((BComponent)this.currentPasswordFE, (Slot)BPasswordFE.modified, (Slot)modified);
        this.linkTo((BComponent)this.newPasswordFE, (Slot)BPasswordFE.modified, (Slot)modified);
        this.linkTo((BComponent)this.confirmNewPasswordFE, (Slot)BPasswordFE.modified, (Slot)modified);
        this.setContent((BWidget)passwordPane);
    }

    public void doModified() {
        this.setModified();
        try {
            BPassword confirmNewPassword;
            BPassword newPassword = (BPassword)this.newPasswordFE.saveValue();
            if (newPassword == null) {
                newPassword = BLANK_PASSWORD;
            }
            if ((confirmNewPassword = (BPassword)this.confirmNewPasswordFE.saveValue()) == null) {
                confirmNewPassword = BLANK_PASSWORD;
            }
            if (this.passwordStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)newPassword).getValue()).toCharArray(), null)) {
                this.newPasswordIndicator.setVisible(false);
            } else {
                this.newPasswordIndicator.setVisible(true);
            }
            if (AccessController.doPrivileged(() -> ((BPassword)newPassword).getValue()).equals(AccessController.doPrivileged(() -> ((BPassword)confirmNewPassword).getValue()))) {
                this.confirmNewPasswordIndicator.setVisible(false);
            } else {
                this.confirmNewPasswordIndicator.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isNewPasswordValid(Consumer<Localizable> messageConsumer) {
        boolean valid = true;
        ArrayList<Object> errors = new ArrayList<Object>();
        errors.add(LexiconText.toLocalizable((String)"workbench", (String)"changePasswordFE.invalid", (Object[])this.passwordTermArgument));
        try {
            BPassword currentPassword = (BPassword)this.currentPasswordFE.saveValue();
            BPassword newPassword = (BPassword)this.newPasswordFE.saveValue();
            BPassword confirmNewPassword = (BPassword)this.confirmNewPasswordFE.saveValue();
            if (currentPassword == null) {
                currentPassword = BLANK_PASSWORD;
            }
            if (newPassword == null) {
                newPassword = BLANK_PASSWORD;
            }
            if (confirmNewPassword == null) {
                confirmNewPassword = BLANK_PASSWORD;
            }
            AtomicReference passwordStrengthError = new AtomicReference();
            if (!this.passwordStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)newPassword).getValue()).toCharArray(), passwordStrengthError::set)) {
                valid = false;
                errors.add(passwordStrengthError.get());
            }
            if (!AccessController.doPrivileged(() -> ((BPassword)newPassword).getValue()).equals(AccessController.doPrivileged(() -> ((BPassword)confirmNewPassword).getValue()))) {
                valid = false;
                errors.add(LexiconText.toLocalizable((String)"workbench", (String)"changePasswordFE.invalid.match", (Object[])this.passwordTermArgument));
            }
            if (this.actualCurrentPassword != null && !this.actualCurrentPassword.validate(currentPassword)) {
                valid = false;
                errors.add(LexiconText.toLocalizable((String)"workbench", (String)"changePasswordFE.invalid.current", (Object[])this.passwordTermArgument));
            }
        }
        catch (Exception e) {
            valid = false;
            LOG.warning("Could not verify that password meets requirements. Cause is: " + e.getMessage());
        }
        if (messageConsumer != null) {
            messageConsumer.accept(Localizable.concatenate((String)"\n", errors));
        }
        return valid;
    }

    public BPassword getCurrentPassword() {
        try {
            return (BPassword)this.currentPasswordFE.saveValue();
        }
        catch (Exception e) {
            LOG.severe("Could not get current password from field editor. Cause is: " + e.getMessage());
            return null;
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException {
        AtomicReference errors = new AtomicReference();
        if (!this.isNewPasswordValid(errors::set)) {
            throw new CannotSaveException(((Localizable)errors.get()).toString(cx));
        }
        try {
            BPassword newPassword = (BPassword)this.newPasswordFE.saveValue(cx);
            if (newPassword == null) {
                newPassword = BLANK_PASSWORD;
            }
            return newPassword;
        }
        catch (Exception e) {
            throw new CannotSaveException(this.lex.getText("changePasswordFE.save.failed", new Object[]{this.passwordTermArgument[0], e.getMessage()}));
        }
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (value instanceof BPassword) {
            this.actualCurrentPassword = (BPassword)value;
        }
    }
}

