/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxSession;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BCertificateAliasFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BCertificateAliasFE.class);
    private final BTextDropDown field = new BTextDropDown();
    private static final Version version = new Version("3.7");
    private final CryptoStoreId id;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCertificateAliasFE() {
        this(CryptoStoreId.USER_KEY_STORE);
    }

    public BCertificateAliasFE(CryptoStoreId id) {
        this.setContent((BWidget)this.field);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.id = id;
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(!readonly);
        this.field.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BString alias = (BString)v;
        this.field.setText(alias.getString());
        this.field.getList().removeAllItems();
        KeyPurpose keyPurpose = null;
        BString purposeId = (BString)cx.getFacet("purposeId");
        if (purposeId != null && !purposeId.getString().isEmpty()) {
            keyPurpose = KeyPurpose.valueOf((String)purposeId.getString());
        }
        try {
            BWbShell shell = this.getWbShell();
            BOrd ord = shell.getActiveOrd();
            BComponent service = (BComponent)ord.get();
            Version version = (Version)service.fw(404, (Object)"web", null, null, null);
            if (version.compareTo(BCertificateAliasFE.version) < 0) {
                return;
            }
            BFoxSession session = (BFoxSession)service.getSession();
            BFoxChannel channel = session.getConnection().getChannels().get("crypto", Sys.getType((String)"platCrypto:CryptoChannel"));
            Type type = Sys.getType((String)"platCrypto:CryptoChannel");
            Class cls = type.getTypeClass();
            Method mthd = cls.getMethod("keyStoreGetCertificates", CryptoStoreId.class);
            Enumeration certs = (Enumeration)mthd.invoke((Object)channel, this.id);
            while (certs.hasMoreElements()) {
                NX509CertificateEntry entry = (NX509CertificateEntry)certs.nextElement();
                if (!BCertificateAliasFE.filterCert(entry, this.id, keyPurpose)) continue;
                this.field.getList().addItem((Object)entry.getAlias());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean filterCert(NX509CertificateEntry entry, CryptoStoreId id, KeyPurpose keyPurpose) {
        if (id == CryptoStoreId.USER_TRUST_STORE && keyPurpose == null) {
            return true;
        }
        keyPurpose = keyPurpose != null ? keyPurpose : KeyPurpose.SERVER_CERT;
        switch (keyPurpose) {
            case CLIENT_CERT: {
                return CertUtils.isClientCert((X509Certificate)entry.getCertificate(0).getCertificate());
            }
            case CA_CERT: {
                return CertUtils.isCACertificate((X509Certificate)entry.getCertificate(0).getCertificate());
            }
            case CODE_SIGNING_CERT: {
                return CertUtils.isCodeSigningCertificate((X509Certificate)entry.getCertificate(0).getCertificate());
            }
        }
        return CertUtils.isServerCertificate((X509Certificate)entry.getCertificate(0).getCertificate());
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) {
        return BString.make((String)this.field.getText());
    }
}

