/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BStringFilter;
import com.tridium.workbench.bql.filter.BFilterFE;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

public class BStringFilterFE
extends BFilterFE {
    public static final Type TYPE = Sys.loadType(BStringFilterFE.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BTextField patternField = new BTextField("", 20);
    private BListDropDown matchDrop = new BListDropDown();
    private BCheckBox caseCheck;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BStringFilterFE() {
        BList list = this.matchDrop.getList();
        list.addItem((Object)lex.getText("filter.mustEqual"));
        list.addItem((Object)lex.getText("filter.mustLike"));
        list.addItem((Object)lex.getText("filter.mustNotEqual"));
        list.addItem((Object)lex.getText("filter.mustNotLike"));
        this.caseCheck = new BCheckBox(lex.getText("filter.matchCase"));
        BGridPane grid = new BGridPane(3);
        grid.add(null, (BValue)this.patternField);
        grid.add(null, (BValue)this.matchDrop);
        grid.add(null, (BValue)this.caseCheck);
        this.setContent((BWidget)grid);
        this.add(null, (BValue)new BLink((BComponent)this.patternField, (Slot)BTextField.textModified, (Slot)setModified));
        this.add(null, (BValue)new BLink((BComponent)this.matchDrop, (Slot)BDropDown.valueModified, (Slot)setModified));
        this.add(null, (BValue)new BLink((BComponent)this.caseCheck, (Slot)BCheckBox.actionPerformed, (Slot)setModified));
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BStringFilter filter = (BStringFilter)value;
        this.patternField.setText(filter.getPattern());
        this.loadMatchDropDown(filter);
        this.caseCheck.setSelected(filter.getMatchCase());
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BStringFilter filter = (BStringFilter)value;
        filter.setPattern(this.patternField.getText());
        filter.setExact(this.isExact());
        filter.setInclude(this.isInclude());
        filter.setMatchCase(this.caseCheck.isSelected());
        return filter;
    }

    private void loadMatchDropDown(BStringFilter filter) {
        if (filter.getExact()) {
            if (filter.getInclude()) {
                this.matchDrop.setSelectedItem((Object)lex.getText("filter.mustEqual"));
            } else {
                this.matchDrop.setSelectedItem((Object)lex.getText("filter.mustNotEqual"));
            }
        } else if (filter.getInclude()) {
            this.matchDrop.setSelectedItem((Object)lex.getText("filter.mustLike"));
        } else {
            this.matchDrop.setSelectedItem((Object)lex.getText("filter.mustNotLike"));
        }
    }

    private boolean isExact() {
        Object selected = this.matchDrop.getSelectedItem();
        return selected.equals(lex.getText("filter.mustEqual")) || selected.equals(lex.getText("filter.mustNotEqual"));
    }

    private boolean isInclude() {
        Object selected = this.matchDrop.getSelectedItem();
        return selected.equals(lex.getText("filter.mustEqual")) || selected.equals(lex.getText("filter.mustLike"));
    }

    @Override
    public void doSetReadonly(boolean ro) {
        this.patternField.setEditable(!ro);
        this.matchDrop.setEnabled(!ro);
        this.caseCheck.setEnabled(!ro);
    }
}

