/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BFloatFilter;
import com.tridium.workbench.bql.filter.BFilterFE;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFloat;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFloatFilterFE
extends BFilterFE {
    public static final Action minToggled = BFloatFilterFE.newAction((int)0, null);
    public static final Action maxToggled = BFloatFilterFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BFloatFilterFE.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BCheckBox minCheck = new BCheckBox(lex.getText("filter.min"));
    private BWbEditor minEd = BWbFieldEditor.makeFor((BObject)BFloat.DEFAULT);
    private BCheckBox maxCheck = new BCheckBox(lex.getText("filter.max"));
    private BWbEditor maxEd = BWbFieldEditor.makeFor((BObject)BFloat.DEFAULT);

    public void minToggled() {
        this.invoke(minToggled, null, null);
    }

    public void maxToggled() {
        this.invoke(maxToggled, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFloatFilterFE() {
        BGridPane grid = new BGridPane(4);
        grid.add(null, (BValue)this.minCheck);
        grid.add(null, (BValue)this.minEd);
        grid.add(null, (BValue)new BBorderPane((BWidget)this.maxCheck, 0.0, 0.0, 0.0, 5.0));
        grid.add(null, (BValue)this.maxEd);
        this.add("minOnLink", (BValue)new BLink((BComponent)this.minCheck, (Slot)BCheckBox.actionPerformed, (Slot)minToggled));
        this.add("minEdLink", (BValue)new BLink((BComponent)this.minEd, (Slot)BWbEditor.pluginModified, (Slot)setModified));
        this.add("maxOnLink", (BValue)new BLink((BComponent)this.maxCheck, (Slot)BCheckBox.actionPerformed, (Slot)maxToggled));
        this.add("maxEdLink", (BValue)new BLink((BComponent)this.maxEd, (Slot)BWbEditor.pluginModified, (Slot)setModified));
        this.setContent((BWidget)grid);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BFloatFilter filter = (BFloatFilter)value;
        this.minCheck.setSelected(filter.getMinEnabled());
        this.minEd.loadValue((BObject)BFloat.make((float)filter.getMinValue()), cx);
        this.minEd.setReadonly(!filter.getMinEnabled());
        this.maxCheck.setSelected(filter.getMaxEnabled());
        this.maxEd.loadValue((BObject)BFloat.make((float)filter.getMaxValue()), cx);
        this.maxEd.setReadonly(!filter.getMaxEnabled());
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BFloatFilter filter = (BFloatFilter)value;
        filter.setMinEnabled(this.minCheck.isSelected());
        filter.setMinValue(((BFloat)this.minEd.saveValue(cx)).getFloat());
        filter.setMaxEnabled(this.maxCheck.isSelected());
        filter.setMaxValue(((BFloat)this.maxEd.saveValue(cx)).getFloat());
        return filter;
    }

    @Override
    public void doSetReadonly(boolean ro) {
        this.minCheck.setEnabled(!ro);
        this.minEd.setReadonly(ro || !this.minCheck.isSelected());
        this.maxCheck.setEnabled(!ro);
        this.maxEd.setReadonly(ro || !this.maxCheck.isSelected());
    }

    public void doMinToggled() {
        this.minEd.setReadonly(!this.minCheck.isSelected());
        this.setModified();
    }

    public void doMaxToggled() {
        this.maxEd.setReadonly(!this.maxCheck.isSelected());
        this.setModified();
    }
}

