/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.builder;

import com.tridium.workbench.bql.builder.BExtentChooser;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BExtentTypeChooser
extends BExtentChooser {
    public static final Action specChanged = BExtentTypeChooser.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BExtentTypeChooser.class);
    private boolean wasNull = false;
    static Lexicon lex = Lexicon.make((String)"workbench");
    private BGridPane grid;
    private BListDropDown common;
    private BTypeSpecFE editor;
    private BNullWidget nullWidget = new BNullWidget();
    static BFacets facets;

    public void specChanged() {
        this.invoke(specChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BExtentTypeChooser() {
        this.common = new BListDropDown();
        BList list = this.common.getList();
        this.addItem(list, "common.component", BComponent.TYPE);
        this.addItem(list, "common.folder", BFolder.TYPE);
        this.addItem(list, "common.control", Sys.getType((String)"control:ControlPoint"));
        this.addItem(list, "common.boolean", Sys.getType((String)"control:BooleanPoint"));
        this.addItem(list, "common.enum", Sys.getType((String)"control:EnumPoint"));
        this.addItem(list, "common.numeric", Sys.getType((String)"control:NumericPoint"));
        this.addItem(list, "common.string", Sys.getType((String)"control:StringPoint"));
        this.addItem(list, "common.alarmClass", Sys.getType((String)"alarm:AlarmClass"));
        this.addItem(list, "common.program", Sys.getType((String)"program:Program"));
        this.addItem(list, "common.schedule", Sys.getType((String)"schedule:AbstractSchedule"));
        this.addItem(list, "common.custom", null);
        list.setSelectedIndex(0);
        this.linkTo((BComponent)this.common, (Slot)BListDropDown.listActionPerformed, (Slot)specChanged);
        this.editor = new BTypeSpecFE();
        this.editor.setAutoSaveHistory(false);
        this.editor.loadValue((BObject)BComponent.TYPE.getTypeSpec(), (Context)facets);
        this.linkTo((BComponent)this.editor, (Slot)BTypeSpecFE.pluginModified, (Slot)specChanged);
        this.grid = new BGridPane(3);
        this.grid.add(null, (BValue)new BLabel(BExtentTypeChooser.text("ofType")));
        this.grid.add(null, (BValue)this.common);
        this.grid.add("editor", (BValue)this.nullWidget);
        this.setCenter((BWidget)this.grid);
    }

    private void addItem(BList list, String lex, Type type) {
        String name = BExtentTypeChooser.text(lex + ".label");
        BImage icon = BImage.make((String)BExtentTypeChooser.text(lex + ".icon"));
        list.addItem(icon, (Object)new CommonType(name, type));
    }

    @Override
    public void cleanup() {
        this.editor.saveHistory();
    }

    @Override
    public void setExtent(String extent) {
        BList list = this.common.getList();
        for (int i = 0; i < list.getItemCount() - 1; ++i) {
            CommonType c = (CommonType)list.getItem(i);
            if (!c.type.toString().equals(extent)) continue;
            list.setSelectedIndex(i);
            this.grid.set("editor", (BValue)this.nullWidget);
            this.getParentWidget().relayout();
            return;
        }
        list.setSelectedIndex(list.getItemCount() - 1);
        this.editor.loadValue((BObject)BTypeSpec.make((String)extent), (Context)facets);
        this.grid.set("editor", (BValue)this.editor);
        this.getParentWidget().relayout();
    }

    @Override
    public Type getBaseType() {
        CommonType c = (CommonType)this.common.getList().getSelectedItem();
        if (c.type != null) {
            return c.type;
        }
        try {
            BTypeSpec spec = (BTypeSpec)this.editor.saveValue();
            return spec.getResolvedType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return BComponent.TYPE;
        }
    }

    @Override
    public String toBql() {
        CommonType c = (CommonType)this.common.getList().getSelectedItem();
        if (c.type != null) {
            return "from " + c.type.toString();
        }
        try {
            BTypeSpec spec = (BTypeSpec)this.editor.saveValue();
            String bql = "from " + spec.toString();
            if (spec.toString().equals("schedule:AbstractSchedule")) {
                bql = bql + " stop";
            }
            return bql;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void doSpecChanged() {
        CommonType c = (CommonType)this.common.getList().getSelectedItem();
        if (c.type == null) {
            if (!this.wasNull) {
                this.wasNull = true;
                this.grid.set("editor", (BValue)this.editor);
            }
            try {
                this.editor.saveValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.wasNull) {
            this.wasNull = false;
            this.grid.set("editor", (BValue)this.nullWidget);
        }
        this.fireChanged();
        this.getParentWidget().relayout();
    }

    static String text(String s) {
        return lex.getText("bqlQueryBuilder." + s);
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetType", BString.make((String)"baja:Value"));
        map.put("allowNull", BBoolean.FALSE);
        map.put("showAbstract", BBoolean.TRUE);
        facets = BFacets.make(map);
    }

    class CommonType {
        public String displayName;
        public Type type;

        public CommonType(String displayName, Type type) {
            this.displayName = displayName;
            this.type = type;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

