/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BBookmarkTable;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.util.Lexicon;

public class BBookmarkManager
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BBookmarkManager.class);
    private static BModule module = Sys.getModuleForClass(BBookmarkManager.class);
    final Lexicon lex = Lexicon.make((String)"workbench");
    private BBookmarkOptions options;
    private BBookmarkTable table;
    private NewFolder newFolder;
    private Add add;
    private CopyTo copyTo;
    private MoveTo moveTo;
    private Edit edit;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;
    private boolean modifyOptions;

    public Type getType() {
        return TYPE;
    }

    public static void open(BWidget owner) {
        BBookmarkOptions options = BBookmarkOptions.make();
        BBookmarkOptions temp = (BBookmarkOptions)options.newCopy();
        BBookmarkManager manager = new BBookmarkManager(temp, false);
        BBorderPane pane = new BBorderPane((BWidget)manager);
        if (1 == BDialog.open((BWidget)owner, (String)Lexicon.make((String)"workbench").getText("bookmark.manage.label"), (Object)pane, (int)3)) {
            options.getRootFolder().removeAll();
            BBookmarkManager.copy((BBookmarkItem)options.getRootFolder(), temp.getRootFolder().getChildComponents());
            options.save();
            BookmarkEvents.fireBookmarkChanged();
        }
    }

    private static void copy(BBookmarkItem target, BComponent[] kids) {
        for (int i = 0; i < kids.length; ++i) {
            BBookmarkItem child = (BBookmarkItem)kids[i];
            BBookmark item = null;
            if (kids[i] instanceof BBookmark) {
                item = new BBookmark();
                item.setBookmarkOrd(((BBookmark)child).getBookmarkOrd());
            } else if (kids[i] instanceof BBookmarkFolder) {
                item = new BBookmarkFolder();
                BBookmarkManager.copy((BBookmarkItem)item, child.getChildComponents());
            }
            if (item == null) continue;
            item.setText(child.getText());
            item.setIconOrd(child.getIconOrd());
            target.add(child.getName(), (BValue)item);
        }
    }

    public BBookmarkManager() {
        throw new IllegalStateException();
    }

    public BBookmarkManager(BBookmarkOptions options) {
        this(options, true);
    }

    private BBookmarkManager(BBookmarkOptions options, boolean modifyOptions) {
        this.options = options;
        this.modifyOptions = modifyOptions;
        this.table = new BBookmarkTable(options.getRootFolder());
        this.table.setMultipleSelection(true);
        this.table.setSelection((TableSelection)new Selection());
        this.table.setController((TableController)new Controller());
        BGridPane buttons = new BGridPane(1);
        buttons.setValign(BValign.top);
        buttons.setColumnAlign(BHalign.fill);
        this.newFolder = new NewFolder((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.newFolder));
        this.add = new Add((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.add));
        buttons.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 10.0, 0.0, 0.0, 0.0));
        this.copyTo = new CopyTo((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.copyTo));
        this.moveTo = new MoveTo((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.moveTo));
        this.remove = new Remove((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.remove));
        buttons.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 10.0, 0.0, 0.0, 0.0));
        this.edit = new Edit((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.edit));
        this.moveUp = new MoveUp((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.moveUp));
        this.moveDown = new MoveDown((BWidget)this);
        buttons.add(null, (BValue)BBookmarkManager.newButton(this.moveDown));
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setMinWidth(500.0);
        pane.setMaxWidth(500.0);
        pane.setMinHeight(350.0);
        pane.setMaxHeight(350.0);
        this.setCenter((BWidget)pane);
        this.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 10.0));
        this.table.getTreeTableModel().getRoot(0).setExpanded(true);
    }

    static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    Property[] getDynamicProperties(BComponent parent) {
        ArrayList<Property> v = new ArrayList<Property>();
        SlotCursor c = parent.loadSlots().getProperties();
        while (c.next()) {
            Property p = c.property();
            if (Flags.isHidden((BComplex)parent, (Slot)p) || p.isFrozen()) continue;
            v.add(p);
        }
        return v.toArray(new Property[v.size()]);
    }

    TreeTableNode findNode(BComponent c) {
        TreeTableModel model = this.table.getTreeTableModel();
        for (int i = 0; i < model.getRootCount(); ++i) {
            TreeTableNode node = this.findNode(model.getRoot(i), c);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    TreeTableNode findNode(TreeTableNode node, BComponent c) {
        if (c == ((BBookmarkTable.Node)node).item) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeTableNode child = this.findNode(node.getChild(i), c);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    BBookmarkFolder getRootFolder(BComponent c) {
        BComponent parent = c;
        while (!(parent.getParent() instanceof BBookmarkOptions)) {
            parent = parent.getParent().asComponent();
        }
        return (BBookmarkFolder)parent;
    }

    private class MoveDown
    extends Command {
        public MoveDown(BWidget owner) {
            super(owner, module, "bookmark.moveDown");
        }

        public CommandArtifact doInvoke() {
            int i;
            TreeTableModel model = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection selection = BBookmarkManager.this.table.getSelection();
            int[] rows = selection.getRows();
            BBookmarkTable.Node node = (BBookmarkTable.Node)model.rowToNode(rows[0]);
            BComponent parent = node.item.getParent().asComponent();
            ArrayList<TreeTableNode> list = new ArrayList<TreeTableNode>();
            selection.deselectAll();
            Property[] props = BBookmarkManager.this.getDynamicProperties(parent);
            int limit = props.length - 1;
            for (i = rows.length - 1; i >= 0; --i) {
                TreeTableNode child = model.rowToNode(rows[i]);
                int index = node.getParent().getChildIndex(child);
                list.add(child);
                if (index == limit) {
                    --limit;
                    continue;
                }
                Property temp = props[index + 1];
                props[index + 1] = props[index];
                props[index] = temp;
            }
            parent.reorder(props);
            if (BBookmarkManager.this.modifyOptions) {
                BBookmarkManager.this.options.save();
            }
            model.updateTreeTable(false);
            for (i = 0; i < list.size(); ++i) {
                int row = model.nodeToRow((TreeTableNode)list.get(i));
                selection.select(row);
            }
            return null;
        }
    }

    private class MoveUp
    extends Command {
        public MoveUp(BWidget owner) {
            super(owner, module, "bookmark.moveUp");
        }

        public CommandArtifact doInvoke() {
            int i;
            TreeTableModel model = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection selection = BBookmarkManager.this.table.getSelection();
            int[] rows = selection.getRows();
            BBookmarkTable.Node node = (BBookmarkTable.Node)model.rowToNode(rows[0]);
            BComponent parent = node.item.getParent().asComponent();
            ArrayList<TreeTableNode> list = new ArrayList<TreeTableNode>();
            int limit = 0;
            selection.deselectAll();
            Property[] props = BBookmarkManager.this.getDynamicProperties(parent);
            for (i = 0; i < rows.length; ++i) {
                TreeTableNode child = model.rowToNode(rows[i]);
                int index = node.getParent().getChildIndex(child);
                list.add(child);
                if (index == limit) {
                    ++limit;
                    continue;
                }
                Property temp = props[index - 1];
                props[index - 1] = props[index];
                props[index] = temp;
            }
            parent.reorder(props);
            if (BBookmarkManager.this.modifyOptions) {
                BBookmarkManager.this.options.save();
            }
            model.updateTreeTable(false);
            for (i = 0; i < list.size(); ++i) {
                int row = model.nodeToRow((TreeTableNode)list.get(i));
                selection.select(row);
            }
            return null;
        }
    }

    private class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "bookmark.remove");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BBookmarkManager.this.table.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                BBookmarkTable.Node node = (BBookmarkTable.Node)BBookmarkManager.this.table.getTreeTableModel().rowToNode(rows[i]);
                node.item.getParent().asComponent().remove((BComplex)node.item);
            }
            BBookmarkManager.this.table.getSelection().deselectAll();
            if (BBookmarkManager.this.modifyOptions) {
                BBookmarkManager.this.options.save();
            }
            BBookmarkManager.this.table.getTreeTableModel().updateTreeTable(true);
            return null;
        }
    }

    private class Edit
    extends Command {
        public Edit(BWidget owner) {
            super(owner, module, "bookmark.edit");
        }

        public CommandArtifact doInvoke() {
            BBookmarkFolder f;
            String str;
            int row = BBookmarkManager.this.table.getSelection().getRow();
            BBookmarkTable.Node node = (BBookmarkTable.Node)BBookmarkManager.this.table.getTreeTableModel().rowToNode(row);
            if (node.item instanceof BBookmark) {
                BBookmark b = (BBookmark)node.item;
                Object[] str2 = this.doEditBookmark(b);
                if (str2 != null) {
                    b.setText((String)str2[0]);
                    b.setBookmarkOrd((BOrd)str2[1]);
                    node.load();
                    if (BBookmarkManager.this.modifyOptions) {
                        BBookmarkManager.this.options.save();
                    }
                    BBookmarkManager.this.table.getTreeTableModel().updateTreeTable(true);
                }
            } else if (node.item instanceof BBookmarkFolder && (str = this.doEditFolder(f = (BBookmarkFolder)node.item)) != null) {
                f.setText(str);
                node.load();
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                BBookmarkManager.this.table.getTreeTableModel().updateTreeTable(true);
            }
            return null;
        }

        public Object[] doEditBookmark(BBookmark mark) {
            try {
                BTextField name = new BTextField(mark.getText(), 60);
                BOrdFE editor = new BOrdFE();
                editor.loadValue((BObject)mark.getBookmarkOrd(), (Context)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE));
                BGridPane grid = new BGridPane(2);
                grid.add(null, (BValue)new BLabel(BBookmarkManager.this.lex.getText("bookmark.name")));
                grid.add(null, (BValue)name);
                grid.add(null, (BValue)new BLabel(BBookmarkManager.this.lex.getText("bookmark.ord")));
                grid.add(null, (BValue)editor);
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)BBookmarkManager.this.lex.getText("bookmark.edit.label"), (Object)grid, (int)3)) {
                    return new Object[]{name.getText(), editor.saveValue()};
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public String doEditFolder(BBookmarkFolder folder) {
            BTextField name = new BTextField(folder.getText(), 30);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(BBookmarkManager.this.lex.getText("bookmark.name")));
            grid.add(null, (BValue)name);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BBookmarkManager.this.lex.getText("bookmark.edit.label"), (Object)grid, (int)3)) {
                return name.getText();
            }
            return null;
        }
    }

    private class MoveTo
    extends Command {
        public MoveTo(BWidget owner) {
            super(owner, module, "bookmark.moveTo");
        }

        public CommandArtifact doInvoke() {
            BBookmarkTable.Node node;
            TreeTableModel model = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection selection = BBookmarkManager.this.table.getSelection();
            int[] rows = selection.getRows();
            BComponent[] c = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                node = (BBookmarkTable.Node)model.rowToNode(rows[i]);
                c[i] = node.item;
            }
            BBookmarkFolder dest = BookmarkUtil.move(this.getOwner(), BBookmarkManager.this.getRootFolder(c[0]), c);
            if (dest != null) {
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                model.updateTreeTable(true);
                for (BBookmarkTable.Node parent = node = BBookmarkManager.this.findNode((BComponent)dest); parent != null; parent = parent.getParent()) {
                    parent.setExpanded(true);
                }
                selection.deselectAll();
                dest.loadSlots();
                int x = dest.getChildComponents().length - c.length;
                for (int i = 0; i < c.length; ++i) {
                    TreeTableNode child = node.getChild(x + i);
                    selection.select(model.nodeToRow(child));
                }
            }
            return null;
        }
    }

    private class CopyTo
    extends Command {
        public CopyTo(BWidget owner) {
            super(owner, module, "bookmark.copyTo");
        }

        public CommandArtifact doInvoke() {
            BBookmarkTable.Node node;
            TreeTableModel model = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection selection = BBookmarkManager.this.table.getSelection();
            int[] rows = selection.getRows();
            BComponent[] c = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                node = (BBookmarkTable.Node)model.rowToNode(rows[i]);
                c[i] = node.item;
            }
            BBookmarkFolder dest = BookmarkUtil.copy(this.getOwner(), BBookmarkManager.this.getRootFolder(c[0]), c);
            if (dest != null) {
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                model.updateTreeTable(true);
                for (BBookmarkTable.Node parent = node = BBookmarkManager.this.findNode((BComponent)dest); parent != null; parent = parent.getParent()) {
                    parent.setExpanded(true);
                }
                selection.deselectAll();
                dest.loadSlots();
                int x = dest.getChildComponents().length - c.length;
                for (int i = 0; i < c.length; ++i) {
                    TreeTableNode child = node.getChild(x + i);
                    selection.select(model.nodeToRow(child));
                }
            }
            return null;
        }
    }

    private class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "bookmark.manage.add");
        }

        public CommandArtifact doInvoke() {
            TreeTableModel model = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection selection = BBookmarkManager.this.table.getSelection();
            int row = selection.getRow();
            BBookmarkTable.Node node = (BBookmarkTable.Node)model.rowToNode(row);
            BBookmark b = new BBookmark();
            Object[] str = new Edit(this.getOwner()).doEditBookmark(b);
            if (str != null) {
                b.setText((String)str[0]);
                b.setBookmarkOrd((BOrd)str[1]);
                node.item.add(null, (BValue)b);
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                node.setExpanded(true);
                model.updateTreeTable(true);
            }
            return null;
        }
    }

    private class NewFolder
    extends Command {
        public NewFolder(BWidget owner) {
            super(owner, module, "bookmark.manage.newFolder");
        }

        public CommandArtifact doInvoke() {
            TreeTableModel model = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection selection = BBookmarkManager.this.table.getSelection();
            int row = selection.getRow();
            BBookmarkTable.Node node = (BBookmarkTable.Node)model.rowToNode(row);
            BBookmarkFolder nf = new BBookmarkFolder();
            String str = new Edit(this.getOwner()).doEditFolder(nf);
            if (str != null) {
                nf.setText(str);
                node.item.add(null, (BValue)nf);
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                node.setExpanded(true);
                model.updateTreeTable(true);
                selection.deselectAll();
                selection.select(model.nodeToRow(BBookmarkManager.this.findNode(node, (BComponent)nf)));
            }
            return null;
        }
    }

    private class Controller
    extends TreeTableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BBookmarkManager.this.edit.invoke();
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 127) {
                event.consume();
                if (BBookmarkManager.this.remove.isEnabled()) {
                    BBookmarkManager.this.remove.invoke();
                }
            }
        }

        protected BMenu makePopup(TreeTableSubject subject) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)BBookmarkManager.this.newFolder);
            menu.add(null, (Command)BBookmarkManager.this.add);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)BBookmarkManager.this.copyTo);
            menu.add(null, (Command)BBookmarkManager.this.moveTo);
            menu.add(null, (Command)BBookmarkManager.this.remove);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)BBookmarkManager.this.edit);
            menu.add(null, (Command)BBookmarkManager.this.moveUp);
            menu.add(null, (Command)BBookmarkManager.this.moveDown);
            return menu;
        }
    }

    private class Selection
    extends TreeTableSelection {
        private Selection() {
        }

        public void updateTable() {
            boolean b;
            super.updateTable();
            int[] rows = this.getRows();
            boolean a = rows.length == 1;
            boolean c = b = rows.length > 0;
            boolean d = false;
            boolean e = false;
            if (rows.length > 0) {
                TreeTableNode node = BBookmarkManager.this.table.getTreeTableModel().rowToNode(rows[0]);
                TreeTableNode parent = node.getParent();
                boolean bl = e = !(((BBookmarkTable.Node)node).item instanceof BBookmark);
                if (parent == null) {
                    d = true;
                } else {
                    for (int i = 1; i < rows.length; ++i) {
                        node = BBookmarkManager.this.table.getTreeTableModel().rowToNode(rows[i]);
                        if (parent == node.getParent()) continue;
                        c = false;
                        break;
                    }
                }
            }
            BBookmarkManager.this.newFolder.setEnabled(a && e);
            BBookmarkManager.this.add.setEnabled(a && e);
            BBookmarkManager.this.copyTo.setEnabled(!d && c);
            BBookmarkManager.this.moveTo.setEnabled(!d && c);
            BBookmarkManager.this.edit.setEnabled(!d && a);
            BBookmarkManager.this.remove.setEnabled(!d && b);
            BBookmarkManager.this.moveUp.setEnabled(!d && c);
            BBookmarkManager.this.moveDown.setEnabled(!d && c);
        }
    }
}

