/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth.kerb;

import com.tridium.workbench.auth.kerb.KerberosInfo;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.authn.BCredInputPane;

public class BKerbSelectCredPane
extends BCredInputPane {
    public static final Type TYPE = Sys.loadType(BKerbSelectCredPane.class);
    private ToggleCommand newUserCommand;
    private ToggleCommand curUserCommand;
    private BKerberosCredentials kCredentials;
    private boolean preserveKerberosTicket = false;
    protected BTextField editor = new BTextField();
    protected BCheckBox saveCredBox;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BKerbSelectCredPane(BUsernameCredential credentials, KerberosInfo kInfo) {
        if (credentials == null) {
            credentials = new BUsernameCredential();
        }
        if (kInfo.getCreds() == null) {
            throw new IllegalArgumentException();
        }
        this.kCredentials = kInfo.getCreds();
        this.editor.setText(credentials.getUsername());
        this.saveCredBox = new BCheckBox("Remember this user", true);
        BGridPane credInputPane = new BGridPane(1);
        credInputPane.setHalign(BHalign.left);
        credInputPane.add(null, (BValue)this.editor);
        credInputPane.add(null, (BValue)this.saveCredBox);
        BGridPane credPane = new BGridPane(1);
        credPane.setHalign(BHalign.left);
        credPane.add(null, (BValue)new BBorderPane((BWidget)credInputPane, 0.0, 0.0, 0.0, 10.0));
        String username = this.kCredentials.getUsername();
        this.curUserCommand = new CredToggleCommand((BWidget)this, "Log in as current user (" + username + ")");
        BRadioButton curUserButton = new BRadioButton(this.curUserCommand);
        BGridPane curUserPane = new BGridPane(1);
        curUserPane.setHalign(BHalign.left);
        curUserPane.add(null, (BValue)new BBorderPane((BWidget)curUserButton, 0.0, 0.0, 0.0, 10.0));
        this.newUserCommand = new CredToggleCommand((BWidget)this, "Log in as different user");
        BRadioButton newUserButton = new BRadioButton(this.newUserCommand);
        BGridPane newUserButtonPane = new BGridPane(1);
        newUserButtonPane.setHalign(BHalign.left);
        newUserButtonPane.add(null, (BValue)newUserButton);
        newUserButtonPane.add(null, (BValue)credPane);
        BGridPane newUserPane = new BGridPane(1);
        newUserPane.setHalign(BHalign.left);
        newUserPane.add(null, (BValue)new BBorderPane((BWidget)newUserButtonPane, 0.0, 0.0, 0.0, 10.0));
        this.add(null, (BValue)curUserPane);
        this.add(null, (BValue)newUserPane);
        ToggleCommandGroup toggleGroup = new ToggleCommandGroup();
        toggleGroup.add(this.newUserCommand);
        toggleGroup.add(this.curUserCommand);
        this.curUserCommand.setSelected(true);
        this.editor.setEnabled(false);
        this.saveCredBox.setEnabled(false);
    }

    @Override
    protected BICredentials doGetCredentials() throws Exception {
        BKerberosCredentials extractedCreds = null;
        if (this.curUserCommand.isSelected()) {
            extractedCreds = this.kCredentials;
            this.preserveKerberosTicket = true;
        } else if (this.newUserCommand.isSelected()) {
            extractedCreds = new BUsernameCredential(this.editor.getText());
        }
        return extractedCreds;
    }

    @Override
    protected void doCleanCredentials() {
        if (!this.preserveKerberosTicket) {
            this.kCredentials.destroyTicket();
        }
        this.kCredentials = null;
        this.editor = null;
    }

    @Override
    public boolean shouldSaveCredentials() {
        return this.newUserCommand.isSelected() && this.saveCredBox.isSelected();
    }

    @Override
    public boolean shouldDeleteCredentials() {
        return this.newUserCommand.isSelected() && !this.saveCredBox.isSelected();
    }

    class CredToggleCommand
    extends ToggleCommand {
        CredToggleCommand(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() throws Exception {
            BKerbSelectCredPane.this.editor.setEnabled(BKerbSelectCredPane.this.newUserCommand.isSelected());
            BKerbSelectCredPane.this.saveCredBox.setEnabled(BKerbSelectCredPane.this.newUserCommand.isSelected());
            return null;
        }
    }
}

