/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.BLegacyDigestAuthenticationScheme;
import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platform.daemon.Authenticator;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BUsernameInputPane;
import com.tridium.workbench.auth.BWbLoginPane;
import com.tridium.workbench.auth.kerb.BKerbSelectCredPane;
import com.tridium.workbench.auth.kerb.KerberosInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BIPreconnectCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.ChangeUserAuthenticationException;
import javax.baja.security.ReportCauseAuthenticationException;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BIObject;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.authn.BCredInputPane;
import javax.baja.workbench.authn.BWbDialogHandler;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class WbAuthenticationClient
implements AuthenticationClient {
    public static final int OPTION_CLOSE_CHANGE_USER = 1000;
    BWidget owner;
    protected AuthenticationException exception = null;
    protected static Logger ldapLogger = Logger.getLogger("ldap");
    private BIPreconnectCredentials preconnectCredentials = null;
    private boolean newSession;

    public WbAuthenticationClient(BWidget owner) {
        this.owner = owner;
    }

    public BIUserCredentials requestUsername(AuthenticationRealm realm) {
        BUsernameCredential storedCredential = AuthUtil.getSavedUser(this.getRealmPrefix() + realm.getAuthenticationRealmName());
        BCredInputPane pane = null;
        String schemeName = realm.getAuthenticationScheme();
        BKerberosCredentials creds = null;
        if (schemeName.equals("Fox (n4Kerberos)")) {
            creds = WbAuthenticationClient.getCurrentKerberosCredentials();
        }
        if (storedCredential != null) {
            return storedCredential;
        }
        if (creds != null) {
            KerberosInfo kinfo = new KerberosInfo();
            kinfo.setRealm(creds.getRealm());
            kinfo.setCreds(creds);
            if (realm instanceof BFoxSession) {
                kinfo.setStationName(((BFoxSession)realm).getStationName());
            }
            pane = new BKerbSelectCredPane(storedCredential, kinfo);
        } else {
            pane = new BUsernameInputPane(realm);
        }
        BIUserCredentials usernameCredential = (BIUserCredentials)this.acquireUserCredentials(realm, pane);
        if (usernameCredential == null) {
            return null;
        }
        if (((BCredInputPane)pane).shouldSaveCredentials() && usernameCredential instanceof BUsernameCredential) {
            AuthUtil.saveUser(this.getRealmPrefix() + realm.getAuthenticationRealmName(), (BUsernameCredential)usernameCredential);
        } else if (((BCredInputPane)pane).shouldDeleteCredentials()) {
            AuthUtil.removeSavedUser(this.getRealmPrefix() + realm.getAuthenticationRealmName());
        }
        return usernameCredential;
    }

    public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
        BAuthenticationScheme scheme = BAuthenticationScheme.getSchemeFromName((String)schemeName);
        BWbDialogHandler dialogHandler = (BWbDialogHandler)scheme.getAgentOn(BWbDialogHandler.class);
        if (dialogHandler == null) {
            throw new AuthenticationException(realm, LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED);
        }
        if (scheme instanceof BLegacyDigestAuthenticationScheme && !(realm instanceof Authenticator)) {
            throw new AuthenticationException(realm, LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED);
        }
        BCredInputPane pane = null;
        pane = dialogHandler.getPaneForStep(realm, this.getRealmPrefix(), step, seedInfo);
        BICredentials credentials = this.acquireUserCredentials(realm, pane);
        if (credentials == null) {
            return null;
        }
        if (pane.shouldSaveCredentials()) {
            AuthUtil.saveCredentials(this.getRealmPrefix() + realm.getAuthenticationRealmName(), credentials);
        } else if (pane.shouldDeleteCredentials()) {
            AuthUtil.removeCredentials(this.getRealmPrefix() + realm.getAuthenticationRealmName());
        }
        return credentials;
    }

    protected BICredentials acquireUserCredentials(AuthenticationRealm realm, BCredInputPane pane) {
        boolean showCause;
        String message;
        boolean showError;
        BWbLoginPane loginPane;
        this.newSession = true;
        UiLexicon lex = UiLexicon.bajaui();
        String lexTitle = lex.getText("auth.title");
        int result = BDialog.open((BWidget)this.owner, (String)lexTitle, (Object)((Object)(loginPane = new BWbLoginPane(realm, pane, showError = this.exception != null, message = (showCause = showError && this.exception.getCause() != null && this.exception.getCause() instanceof ReportCauseAuthenticationException) ? ((ReportCauseAuthenticationException)this.exception.getCause()).getCauseMessage() : null))), (int)3);
        if (result == 2) {
            loginPane.getCredInputPane().cleanCredentials();
            return null;
        }
        if (result == 1000) {
            loginPane.getCredInputPane().cleanCredentials();
            throw new ChangeUserAuthenticationException(realm);
        }
        try {
            BICredentials credentials = pane.extractCredentials();
            this.exception = null;
            return credentials;
        }
        catch (Exception e) {
            Throwable cause = ThrowableUtil.getCause((Throwable)e);
            if (cause != null) {
                cause.printStackTrace();
            }
            BDialog.error((BWidget)this.owner, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setException(AuthenticationException e) {
        this.exception = e;
    }

    public static BKerberosCredentials getCurrentKerberosCredentials() {
        KerberosConfig kerberosConfig = new KerberosConfig(true, true);
        GSSCredential gssCred = AccessController.doPrivileged(() -> WbAuthenticationClient.lambda$getCurrentKerberosCredentials$0((Configuration)kerberosConfig));
        if (gssCred != null) {
            try {
                if (ldapLogger.isLoggable(Level.FINE)) {
                    ldapLogger.fine("Found kerberos credentials for " + gssCred.getName());
                }
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            return new BKerberosCredentials(gssCred);
        }
        return null;
    }

    public String getRealmPrefix() {
        return "";
    }

    public Optional<BIPreconnectCredentials> getPreconnectCredentials() {
        if (this.preconnectCredentials == null) {
            return Optional.empty();
        }
        return Optional.of(this.preconnectCredentials);
    }

    public void setPreconnectCredentials(BIPreconnectCredentials preconnectCredentials) {
        this.preconnectCredentials = preconnectCredentials;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ GSSCredential lambda$getCurrentKerberosCredentials$0(Configuration kerberosConfig) {
        LoginContext lc = null;
        try {
            lc = new LoginContext("com.tridium.workbench.auth.WbAuthenticationClient", null, null, kerberosConfig);
            lc.login();
            GSSCredential gSSCredential = Subject.doAs(lc.getSubject(), new ExtractGSSCredentialAction());
            return gSSCredential;
        }
        catch (Exception e) {
            if (ldapLogger.isLoggable(Level.FINE)) {
                ldapLogger.fine("Unable to acquire Kerberos credentials: " + e);
            }
            GSSCredential gSSCredential = null;
            return gSSCredential;
        }
        finally {
            try {
                lc.logout();
            }
            catch (LoginException loginException) {}
        }
    }

    static class ExtractGSSCredentialAction
    implements PrivilegedAction<GSSCredential> {
        ExtractGSSCredentialAction() {
        }

        @Override
        public GSSCredential run() {
            try {
                GSSManager manager = GSSManager.getInstance();
                GSSCredential credential = manager.createCredential(1);
                return credential;
            }
            catch (GSSException e) {
                if (ldapLogger.isLoggable(Level.FINE)) {
                    ldapLogger.fine("Unable to acquire Kerberos credentials: " + e);
                }
                return null;
            }
        }
    }
}

