/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.BCredentialsEditor;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraSlots(actions={@NiagaraAction(name="changeCredentialType")})
public class BCredentialStoreFE
extends BWbFieldEditor {
    public static final Action changeCredentialType = BCredentialStoreFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCredentialStoreFE.class);
    private final BGridPane pane;
    private final BListDropDown credDropDown = new BListDropDown();
    private List<BIUserCredentials> credentialList;
    private final BWbFieldEditor credentialsEditor = new BCredentialsEditor();
    private static final String CRED_EDIT = "cred";
    private static final String CRED_EDIT_LINK = "credModifiedLink";

    public void changeCredentialType() {
        this.invoke(changeCredentialType, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCredentialStoreFE() {
        this.pane = new BGridPane(1);
        this.pane.add(null, (BValue)this.credDropDown);
        this.pane.add(CRED_EDIT, (BValue)this.credentialsEditor);
        this.setContent((BWidget)this.pane);
        this.linkTo(null, (BComponent)this.credDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.credDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)changeCredentialType);
    }

    private void changeCredEditor(BCredentialsEditor editor) {
        this.pane.set(CRED_EDIT, (BValue)editor);
        if (this.get(CRED_EDIT_LINK) != null) {
            this.remove(CRED_EDIT_LINK);
        }
        this.linkTo(CRED_EDIT_LINK, (BComponent)editor, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.pane.doLayout(this.pane.getChildWidgets());
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.credDropDown.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BClientCredentials credential = (BClientCredentials)v;
        BList list = this.credDropDown.getList();
        list.removeAllItems();
        AgentList agentList = credential.getAgents();
        agentList = agentList.filter(AgentFilter.is((Type)BIUserCredentials.TYPE));
        this.credentialList = new ArrayList<BIUserCredentials>();
        for (AgentInfo info : agentList.list()) {
            AgentList credAgentList = info.getAgentType().getAgents().filter(AgentFilter.is((Type)BCredentialsEditor.TYPE));
            if (credAgentList.size() == 0) continue;
            BIUserCredentials cred = (BIUserCredentials)info.getInstance();
            this.credentialList.add(cred);
            list.addItem((Object)cred.getType().getTypeSpec().getTypeName());
        }
        BTypeSpec typeSpec = credential.getClientCredentials().getType().getTypeSpec();
        String curCredentialName = typeSpec.getTypeName();
        AgentList credAgentList = Sys.getRegistry().getAgents(typeSpec.getTypeInfo()).filter(AgentFilter.is((Type)BCredentialsEditor.TYPE));
        BCredentialsEditor credEdit = (BCredentialsEditor)credAgentList.get(0).getInstance();
        this.changeCredEditor(credEdit);
        credEdit.loadValue((BObject)((BClientCredentials)v).getCredentials());
        this.credDropDown.getList().setSelectedItem((Object)curCredentialName);
        if (list.getSelectedItem() == null) {
            list.setSelectedIndex(0);
        }
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) throws Exception {
        BCredentialsEditor editor = (BCredentialsEditor)this.pane.get(CRED_EDIT);
        BObject currentVal = editor.getCurrentValue();
        if (currentVal != null && currentVal.isComplex() && currentVal.asComplex().getParent() != null) {
            editor.saveValue(cx);
        } else {
            BValue val = editor.saveValue(null).asValue();
            ((BClientCredentials)v).set(BClientCredentials.clientCredentials, val, cx);
        }
        return v;
    }

    public void doChangeCredentialType() {
        String selectedCred = (String)this.credDropDown.getSelectedItem();
        this.credentialList.stream().filter(cred -> cred.getType().getTypeSpec().getTypeName().equals(selectedCred)).findFirst().ifPresent(cred -> {
            AgentList credAgentList = ((BObject)cred).getAgents().filter(AgentFilter.is((Type)BCredentialsEditor.TYPE));
            BCredentialsEditor credEdit = (BCredentialsEditor)credAgentList.get(0).getInstance();
            this.changeCredEditor(credEdit);
            credEdit.loadValue((BObject)cred);
        });
    }
}

