/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemIndex.BSystemIndexDescriptor;
import com.tridium.systemIndex.BSystemIndexSource;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.util.ComponentTreeCursor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BServiceContainer;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxConcurrentIndexExecutions", type="int", defaultValue="50", facets={@Facet(name="BFacets.MIN", value="5")}), @NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeHours(1)))")})
@NiagaraAction(name="retryFailedIndexes")
public final class BSystemIndexService
extends BAbstractService
implements BIRestrictedComponent {
    public static final Property maxConcurrentIndexExecutions = BSystemIndexService.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (int)5));
    public static final Property retryTrigger = BSystemIndexService.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeHours((int)1))), null);
    public static final Action retryFailedIndexes = BSystemIndexService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSystemIndexService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"indexService.png");
    static final BOrdList DEFAULT_INDEX_QUERY_ORDS = BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"station:|slot:/|bql:{asComponent}"), BOrd.make((String)"station:|slot:/|bql:select * from driver:DeviceNetwork where type != niagaraDriver:NiagaraNetwork"), BOrd.make((String)"station:|slot:/|bql:select * from driver:DeviceFolder where type != niagaraDriver:NiagaraStationFolder"), BOrd.make((String)"station:|slot:/|bql:select * from driver:Device where type != niagaraDriver:NiagaraStation and type != niagaraDriver:NiagaraEdgeLiteStation"), BOrd.make((String)"station:|slot:/|bql:select * from driver:PointFolder where type != niagaraDriver:NiagaraPointFolder"), BOrd.make((String)"station:|slot:/|bql:select * from control:ControlPoint where proxyExt.type != niagaraDriver:NiagaraProxyExt"), BOrd.make((String)"station:|slot:/|bql:select * from schedule:AbstractSchedule stop"), BOrd.make((String)"station:|slot:/|neql:n:hasPxView")});
    static final Logger log = Logger.getLogger("systemIndex");
    private static volatile long numIndexerExecutes;
    private static volatile long totalIndexerExecuteTime;
    private static volatile long minIndexerExecuteTime;
    private static volatile long maxIndexerExecuteTime;
    private static volatile String maxExecuteIndexer;
    private static volatile long numIndexerRetries;
    private static volatile long totalIndexerRetryTime;
    private static volatile long minIndexerRetryTime;
    private static volatile long maxIndexerRetryTime;
    private static volatile String maxRetryIndexer;
    private static volatile long numIndexDescriptorExecutes;
    private static volatile long totalIndexDescriptorExecuteTime;
    private static volatile long minIndexDescriptorExecuteTime;
    private static volatile long maxIndexDescriptorExecuteTime;
    private static volatile String maxExecuteIndexDescriptor;
    private static final int MIN_POOL_SIZE = 5;
    private static final int DEFAULT_QUEUE_SIZE = 5000;
    private static final int queueSize;
    private static final Map<String, Optional<String>> licensedStations;
    private Queue queue;
    private ThreadPoolWorker worker;
    private SystemIndexExecutor executor;

    public int getMaxConcurrentIndexExecutions() {
        return this.getInt(maxConcurrentIndexExecutions);
    }

    public void setMaxConcurrentIndexExecutions(int v) {
        this.setInt(maxConcurrentIndexExecutions, v, null);
    }

    public BTimeTrigger getRetryTrigger() {
        return (BTimeTrigger)this.get(retryTrigger);
    }

    public void setRetryTrigger(BTimeTrigger v) {
        this.set(retryTrigger, (BValue)v, null);
    }

    public void retryFailedIndexes() {
        this.invoke(retryFailedIndexes, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doRetryFailedIndexes(Context cx) {
        if (this.isOperational()) {
            ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this, cx);
            while (cur.next(BSystemIndexer.class)) {
                BSystemIndexer indexer = (BSystemIndexer)cur.get();
                try {
                    if (indexer.isUnoperational() || !indexer.shouldRetryFailedIndexes(cx)) continue;
                    log.fine(() -> "retryFailedIndexes() called on " + indexer.toPathString());
                    indexer.invoke(BSystemIndexer.retryFailedIndexes, null, cx);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e, () -> "Retry check failed for " + indexer.toPathString());
                }
            }
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        if (this.isOperational()) {
            this.enabled();
        }
    }

    public void serviceStopped() throws Exception {
        this.disabled();
    }

    public void started() throws Exception {
        this.serviceStarted();
    }

    protected void enabled() {
        if (this.getProperty("retryLink") == null) {
            BTimeTrigger t = this.getRetryTrigger();
            this.linkTo("retryLink", (BComponent)t, (Slot)BTimeTrigger.fireTrigger, (Slot)retryFailedIndexes);
        }
        if (this.isOperational() && this.executor == null) {
            int maxPoolSize = this.getMaxConcurrentIndexExecutions();
            if (maxPoolSize < 5) {
                maxPoolSize = 5;
            }
            if (this.queue == null) {
                this.queue = new CoalesceQueue(queueSize < 1 ? 5000 : queueSize);
            }
            if (this.worker == null) {
                this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
            }
            if (!this.worker.isRunning()) {
                this.worker.setMaxThreads(maxPoolSize);
                this.worker.start("SystemIndexWorker");
            }
            this.executor = new SystemIndexExecutor(this.queue);
        }
    }

    protected void disabled() {
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
        if (this.executor != null || this.worker != null && this.worker.isRunning()) {
            try {
                this.worker.stop();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e, () -> "Unable to stop the SystemIndexService's ThreadPoolWorker");
            }
            this.executor = null;
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning() && maxConcurrentIndexExecutions.equals(property) && this.worker != null) {
            int maxPoolSize = this.getMaxConcurrentIndexExecutions();
            if (maxPoolSize < 5) {
                maxPoolSize = 5;
            }
            this.worker.setMaxThreads(maxPoolSize);
        }
        super.changed(property, cx);
    }

    public void updateStatus() {
        super.updateStatus();
        SlotCursor cursor = this.getProperties();
        while (cursor.nextComponent()) {
            BValue value = cursor.get();
            if (value.getType().is(BSystemIndexer.TYPE)) {
                ((BSystemIndexer)cursor.get()).updateStatus();
                continue;
            }
            if (!value.getType().is(BSystemIndexSource.TYPE)) continue;
            ((BSystemIndexSource)cursor.get()).updateStatus();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BSystemDbService.TYPE) || parent.getType().is(BServiceContainer.TYPE);
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public Feature getLicenseFeature() {
        Sys.getLicenseManager().getFeature("tridium", "systemDb").check();
        return Sys.getLicenseManager().getFeature("tridium", "systemIndex");
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 501 && b instanceof String) {
            return this.checkStationLicensedForIndexing((String)a, (String)b);
        }
        return super.fw(x, a, b, c, d);
    }

    private String checkStationLicensedForIndexing(String licenseAttribute, String stationName) {
        return licensedStations.computeIfAbsent(stationName, k -> Optional.ofNullable((String)this.fw(501, licenseAttribute, null, null, null))).orElse(null);
    }

    Executor getExecutor() {
        return this.executor;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"System Index Statistics", 2);
            out.prop((Object)"Total SystemIndexer ExecuteFull attempts", (Object)String.valueOf(numIndexerExecutes));
            out.prop((Object)"Total SystemIndexer ExecuteFull time", (Object)BRelTime.make((long)totalIndexerExecuteTime));
            long avgIndexerExecute = numIndexerExecutes > 0L ? totalIndexerExecuteTime / numIndexerExecutes : 0L;
            out.prop((Object)"Avg SystemIndexer ExecuteFull time", (Object)BRelTime.make((long)avgIndexerExecute));
            long min = minIndexerExecuteTime != Long.MAX_VALUE ? minIndexerExecuteTime : 0L;
            out.prop((Object)"Min SystemIndexer ExecuteFull time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max SystemIndexer ExecuteFull time", (Object)BRelTime.make((long)maxIndexerExecuteTime));
            out.prop((Object)"Max SystemIndexer ExecuteFull instance", (Object)maxExecuteIndexer);
            out.prop((Object)"Total SystemIndexer Retry attempts", (Object)String.valueOf(numIndexerRetries));
            out.prop((Object)"Total SystemIndexer Retry time", (Object)BRelTime.make((long)totalIndexerRetryTime));
            long avgIndexerRetry = numIndexerRetries > 0L ? totalIndexerRetryTime / numIndexerRetries : 0L;
            out.prop((Object)"Avg SystemIndexer Retry time", (Object)BRelTime.make((long)avgIndexerRetry));
            min = minIndexerRetryTime != Long.MAX_VALUE ? minIndexerRetryTime : 0L;
            out.prop((Object)"Min SystemIndexer Retry time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max SystemIndexer Retry time", (Object)BRelTime.make((long)maxIndexerRetryTime));
            out.prop((Object)"Max SystemIndexer Retry instance", (Object)maxRetryIndexer);
            out.prop((Object)"Total SystemIndexDescriptor execute attempts", (Object)String.valueOf(numIndexDescriptorExecutes));
            out.prop((Object)"Total SystemIndexDescriptor execute time", (Object)BRelTime.make((long)totalIndexDescriptorExecuteTime));
            long avgIndexDescriptorExecute = numIndexDescriptorExecutes > 0L ? totalIndexDescriptorExecuteTime / numIndexDescriptorExecutes : 0L;
            out.prop((Object)"Avg SystemIndexDescriptor execute time", (Object)BRelTime.make((long)avgIndexDescriptorExecute));
            min = minIndexDescriptorExecuteTime != Long.MAX_VALUE ? minIndexDescriptorExecuteTime : 0L;
            out.prop((Object)"Min SystemIndexDescriptor execute time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max SystemIndexDescriptor execute time", (Object)BRelTime.make((long)maxIndexDescriptorExecuteTime));
            out.prop((Object)"Max SystemIndexDescriptor execute instance", (Object)maxExecuteIndexDescriptor);
            out.endProps();
            if (this.worker != null) {
                this.worker.spy(out);
            }
        }
        super.spy(out);
    }

    static void updateStatistics(BComponent indexComponent, long duration, boolean retry) {
        Type type = indexComponent.getType();
        if (type.is(BSystemIndexer.TYPE)) {
            if (retry) {
                ++numIndexerRetries;
                totalIndexerRetryTime += duration;
                if (duration <= minIndexerRetryTime) {
                    minIndexerRetryTime = duration;
                }
                if (duration >= maxIndexerRetryTime) {
                    maxIndexerRetryTime = duration;
                    maxRetryIndexer = indexComponent.toDisplayPathString(null);
                }
            } else {
                ++numIndexerExecutes;
                totalIndexerExecuteTime += duration;
                if (duration <= minIndexerExecuteTime) {
                    minIndexerExecuteTime = duration;
                }
                if (duration >= maxIndexerExecuteTime) {
                    maxIndexerExecuteTime = duration;
                    maxExecuteIndexer = indexComponent.toDisplayPathString(null);
                }
            }
        } else if (type.is(BSystemIndexDescriptor.TYPE)) {
            ++numIndexDescriptorExecutes;
            totalIndexDescriptorExecuteTime += duration;
            if (duration <= minIndexDescriptorExecuteTime) {
                minIndexDescriptorExecuteTime = duration;
            }
            if (duration >= maxIndexDescriptorExecuteTime) {
                maxIndexDescriptorExecuteTime = duration;
                maxExecuteIndexDescriptor = indexComponent.toDisplayPathString(null);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        minIndexerExecuteTime = Long.MAX_VALUE;
        maxExecuteIndexer = "none";
        minIndexerRetryTime = Long.MAX_VALUE;
        maxRetryIndexer = "none";
        minIndexDescriptorExecuteTime = Long.MAX_VALUE;
        maxExecuteIndexDescriptor = "none";
        queueSize = Integer.getInteger("niagara.systemIndex.workerQueueSize", 5000);
        licensedStations = Collections.synchronizedMap(new HashMap());
    }

    private static class SystemIndexExecutor
    implements Executor {
        Queue queue;

        public SystemIndexExecutor(Queue queue) {
            this.queue = queue;
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.queue.enqueue((Object)command);
            }
            catch (QueueFullException qfe) {
                throw new LocalizableRuntimeException("systemIndex", "systemIndex.exceededMaxConcurrent");
            }
        }
    }
}

