/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemIndex.BIIndexQueryProvider;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.systemIndex.SystemIndexUtil;
import java.util.concurrent.Executor;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmSourceInfo", type="alarm:AlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="defaultIndexQueries", type="BOrdList", defaultValue="BSystemIndexService.DEFAULT_INDEX_QUERY_ORDS", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="useDefaultIndexQueries", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(systemIndex:systemIndex.useDefaultQueries.true)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(systemIndex:systemIndex.useDefaultQueries.false)%\")")}), @NiagaraProperty(name="customIndexQueries", type="BOrdList", defaultValue="BOrdList.NULL", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
@NiagaraAction(name="ackAlarm", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", returnType="baja:Boolean", flags=4)
public abstract class BSystemIndexDescriptor
extends BDescriptor
implements BIIndexQueryProvider,
BIAlarmSource {
    public static final Property alarmOnFailure = BSystemIndexDescriptor.newProperty((int)0, (boolean)false, null);
    public static final Property alarmSourceInfo = BSystemIndexDescriptor.newProperty((int)0, (BValue)BSystemIndexDescriptor.initAlarmSourceInfo(), null);
    public static final Property defaultIndexQueries = BSystemIndexDescriptor.newProperty((int)3, (BValue)BSystemIndexService.DEFAULT_INDEX_QUERY_ORDS, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property useDefaultIndexQueries = BSystemIndexDescriptor.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(systemIndex:systemIndex.useDefaultQueries.true)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(systemIndex:systemIndex.useDefaultQueries.false)%"))));
    public static final Property customIndexQueries = BSystemIndexDescriptor.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Action ackAlarm = BSystemIndexDescriptor.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSystemIndexDescriptor.class);
    private static final BIcon icon = BIcon.std((String)"index.png");
    private AlarmSupport alarmSupport;
    long numExecutes;
    long totalExecuteTime;
    long minExecuteTime = Long.MAX_VALUE;
    long maxExecuteTime;

    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BOrdList getDefaultIndexQueries() {
        return (BOrdList)this.get(defaultIndexQueries);
    }

    public void setDefaultIndexQueries(BOrdList v) {
        this.set(defaultIndexQueries, (BValue)v, null);
    }

    public boolean getUseDefaultIndexQueries() {
        return this.getBoolean(useDefaultIndexQueries);
    }

    public void setUseDefaultIndexQueries(boolean v) {
        this.setBoolean(useDefaultIndexQueries, v, null);
    }

    public BOrdList getCustomIndexQueries() {
        return (BOrdList)this.get(customIndexQueries);
    }

    public void setCustomIndexQueries(BOrdList v) {
        this.set(customIndexQueries, (BValue)v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public final BOrdList getOperationalIndexQueries() {
        return BSystemIndexer.computeIndexQueries(this.getCustomIndexQueries(), this.getDefaultIndexQueries(), this.getUseDefaultIndexQueries());
    }

    protected abstract void executeIndex(SystemIndexLog var1, Context var2) throws Exception;

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        try {
            Executor defaultExecutor;
            BSystemIndexService indexService = null;
            try {
                indexService = this.getSystemIndexService();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Executor executor = defaultExecutor = indexService != null && indexService.isOperational() ? indexService.getExecutor() : null;
            if (defaultExecutor == null) {
                throw new NotRunningException(BSystemIndexer.LEXICON.getText("systemIndex.inoperableSystemIndex"));
            }
            defaultExecutor.execute((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        catch (Exception e) {
            if (this.getState() != BDescriptorState.idle) {
                this.executeFail(e);
            }
            throw e;
        }
        return null;
    }

    public final void doExecute() {
        this.doExecute(null);
    }

    public final void doExecute(Context cx) {
        if (this.getDevice().isFatalFault() || this.getDevice().isDisabled()) {
            return;
        }
        try {
            this.validateIndexQueries(cx);
        }
        catch (LocalizableException | LocalizableRuntimeException e) {
            this.executeFail(e);
            return;
        }
        catch (Exception e) {
            this.executeFail(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemIndex.malformedIndexQueries"));
            return;
        }
        long startTicks = Clock.ticks();
        try {
            BSystemIndexer.runIndex(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemIndex.job.fullIndex", new Object[]{this.getIndexDescription(cx)}), cx, (log, context) -> {
                long start = DiagnosticUtil.startIfLoggable((String)"systemIndexDescriptor_execute");
                try {
                    this.executeInProgress();
                    if (log.isLoggingEnabled()) {
                        log.start("systemIndex", "systemIndex.job.startFullIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)});
                    }
                    this.executeIndex((SystemIndexLog)log, (Context)context);
                    if (this.getStatus().isAlarm()) {
                        BSystemIndexer.processAlarmNormal(this.alarmSupport);
                        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
                    }
                    this.executeOk();
                    if (log.isLoggingEnabled()) {
                        log.success("systemIndex", "systemIndex.job.completeFullIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)});
                    }
                }
                catch (Exception ex) {
                    BDevice parentDevice = this.getDevice();
                    Exception e = (Exception)SystemIndexUtil.processAndLogSystemIndexError(ex, (BComponent)(parentDevice instanceof NiagaraStation ? parentDevice : this));
                    this.executeFail(e);
                    if (log.isLoggingEnabled()) {
                        log.failed("systemIndex", "systemIndex.job.failedFullIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)}, (Throwable)e);
                    }
                    throw BSystemIndexer.convertIndexException(e);
                }
                finally {
                    if (start != 0L) {
                        DiagnosticUtil.complete((long)start, (String)"systemIndexDescriptor_execute", (Object)this.toPathString());
                    }
                }
            });
        }
        catch (Exception e) {
            if (this.getState() != BDescriptorState.idle) {
                BDevice parentDevice = this.getDevice();
                this.executeFail(SystemIndexUtil.processAndLogSystemIndexError(e, (BComponent)(parentDevice instanceof NiagaraStation ? parentDevice : this)));
            }
            throw e;
        }
        finally {
            this.updateStatistics(startTicks);
        }
    }

    public void executeFail(Throwable ex) {
        this.executeFail(SystemIndexUtil.getFailureReason(ex, true));
    }

    public void executeFail(String reason) {
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            boolean ackRequired = BSystemIndexer.processAlarmOffNormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int status = this.getStatus().getBits();
            status |= 8;
            if (ackRequired) {
                status |= 0x80;
            }
            this.setStatus(BStatus.make((int)status));
        }
        super.executeFail(reason);
    }

    public final void started() throws Exception {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        BSystemIndexer.checkDefaultIndexQueries((BComponent)this, defaultIndexQueries.getName(), customIndexQueries.getName());
        this.indexDescriptorStarted();
    }

    protected void indexDescriptorStarted() throws Exception {
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(defaultIndexQueries)) {
            BSystemIndexer.checkDefaultIndexQueries((BComponent)this, defaultIndexQueries.getName(), customIndexQueries.getName());
        }
        this.indexDescriptorChanged(property, context);
    }

    protected void indexDescriptorChanged(Property property, Context context) {
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.parent.parent.parent.displayName% %parent.parent.parent.displayName% %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(systemIndex:systemIndexFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(systemIndex:systemIndexSuccess)%"));
        return asi;
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BSystemIndexer.processAlarmAck(this.alarmSupport, ackRequest);
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    public final BSystemIndexService getSystemIndexService() {
        return (BSystemIndexService)BOrd.make((String)"service:systemIndex:SystemIndexService").get((BObject)this);
    }

    public final BSystemDbService getSystemDbService() {
        return (BSystemDbService)BOrd.make((String)"service:systemDb:SystemDbService").get((BObject)this);
    }

    protected String getIndexDescription(Context cx) {
        return this.toDisplayPathString(cx);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"SystemIndexDescriptor Statistics", 2);
            out.prop((Object)"Total Execute attempts", (Object)String.valueOf(this.numExecutes));
            out.prop((Object)"Total Execute time", (Object)BRelTime.make((long)this.totalExecuteTime));
            long avgIndexerExecute = this.numExecutes > 0L ? this.totalExecuteTime / this.numExecutes : 0L;
            out.prop((Object)"Avg Execute time", (Object)BRelTime.make((long)avgIndexerExecute));
            long min = this.minExecuteTime != Long.MAX_VALUE ? this.minExecuteTime : 0L;
            out.prop((Object)"Min Execute time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max Execute time", (Object)BRelTime.make((long)this.maxExecuteTime));
            out.endProps();
        }
        super.spy(out);
    }

    private void updateStatistics(long startTicks) {
        long duration = Clock.ticks() - startTicks;
        BSystemIndexService.updateStatistics((BComponent)this, duration, false);
        ++this.numExecutes;
        this.totalExecuteTime += duration;
        if (duration <= this.minExecuteTime) {
            this.minExecuteTime = duration;
        }
        if (duration >= this.maxExecuteTime) {
            this.maxExecuteTime = duration;
        }
    }
}

