/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.excel.impl;

import com.tridium.excel.CellStyle;
import com.tridium.excel.CreationHelper;
import com.tridium.excel.Font;
import com.tridium.excel.Name;
import com.tridium.excel.Sheet;
import com.tridium.excel.Workbook;
import com.tridium.excel.impl.CellStyleImpl;
import com.tridium.excel.impl.CreationHelperImpl;
import com.tridium.excel.impl.FontImpl;
import com.tridium.excel.impl.NameImpl;
import com.tridium.excel.impl.SheetImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookImpl
implements Workbook {
    final org.apache.poi.ss.usermodel.Workbook workbook;
    final XSSFWorkbook xmlWorkbook;

    WorkbookImpl(org.apache.poi.ss.usermodel.Workbook workbook) {
        this.workbook = workbook;
        this.xmlWorkbook = workbook instanceof XSSFWorkbook ? (XSSFWorkbook)workbook : null;
    }

    public void close() throws IOException {
        this.workbook.close();
    }

    public Sheet createSheet() {
        org.apache.poi.ss.usermodel.Sheet sheet = this.workbook.createSheet();
        return sheet == null ? null : new SheetImpl(sheet);
    }

    public Sheet createSheet(String sheetName) {
        org.apache.poi.ss.usermodel.Sheet sheet = this.workbook.createSheet(sheetName);
        return sheet == null ? null : new SheetImpl(sheet);
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public int getActiveSheetIndex() {
        return this.workbook.getActiveSheetIndex();
    }

    public int getSheetIndex(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    public Sheet getSheetAt(int index) {
        org.apache.poi.ss.usermodel.Sheet sheet = this.workbook.getSheetAt(index);
        return sheet == null ? null : new SheetImpl(sheet);
    }

    public Iterator<Sheet> sheetIterator() {
        return new SheetIterator(this.workbook.sheetIterator());
    }

    public Name createName() {
        org.apache.poi.ss.usermodel.Name name = this.workbook.createName();
        return name == null ? null : new NameImpl(name);
    }

    public List<? extends Name> getNames(String name) {
        return new NameList(this.workbook.getNames(name));
    }

    public Font createFont() {
        org.apache.poi.ss.usermodel.Font font = this.workbook.createFont();
        return font == null ? null : new FontImpl(font);
    }

    public CreationHelper getCreationHelper() {
        org.apache.poi.ss.usermodel.CreationHelper helper = this.workbook.getCreationHelper();
        return helper == null ? null : new CreationHelperImpl(helper);
    }

    public CellStyle createCellStyle() {
        org.apache.poi.ss.usermodel.CellStyle cellStyle = this.workbook.createCellStyle();
        return cellStyle == null ? null : new CellStyleImpl(cellStyle);
    }

    public void write(OutputStream stream) throws IOException {
        this.workbook.write(stream);
    }

    public boolean isXmlFormat() {
        return this.xmlWorkbook != null;
    }

    public String toString() {
        return this.workbook.toString();
    }

    public org.apache.poi.ss.usermodel.Workbook getPoiWorkbook() {
        return this.workbook;
    }

    static class NameListIterator
    implements ListIterator<Name> {
        final ListIterator<? extends org.apache.poi.ss.usermodel.Name> it;

        NameListIterator(ListIterator<? extends org.apache.poi.ss.usermodel.Name> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Name next() {
            return new NameImpl(this.it.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public Name previous() {
            return new NameImpl(this.it.previous());
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Name name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Name name) {
            throw new UnsupportedOperationException();
        }
    }

    static class NameList
    extends AbstractSequentialList<Name> {
        final List<? extends org.apache.poi.ss.usermodel.Name> names;

        NameList(List<? extends org.apache.poi.ss.usermodel.Name> names) {
            this.names = names;
        }

        @Override
        public ListIterator<Name> listIterator(int index) {
            return new NameListIterator(this.names.listIterator());
        }

        @Override
        public int size() {
            return this.names.size();
        }
    }

    static class SheetIterator
    implements Iterator<Sheet> {
        final Iterator<org.apache.poi.ss.usermodel.Sheet> it;

        SheetIterator(Iterator<org.apache.poi.ss.usermodel.Sheet> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Sheet next() {
            return new SheetImpl(this.it.next());
        }
    }
}

