/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver;

import com.tridium.obix.util.ObixUtils;
import com.tridium.silk.SoapContext;
import com.tridium.silk.Soaplet;
import com.tridium.silk.SoapletUtil;
import com.tridium.silk.Wsdl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.obix.driver.XElemTunnel;
import javax.baja.obix.driver.lobby.BObixLobby;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="servletName", type="String", defaultValue="obix", flags=1, override=true), @NiagaraProperty(name="debug", type="boolean", defaultValue="false"), @NiagaraProperty(name="lobby", type="obixDriver:ObixLobby", defaultValue="new BObixLobby()", flags=262), @NiagaraProperty(name="allowSessionReuse", type="boolean", defaultValue="true")})
public class BObixServer
extends BWebServlet
implements Soaplet {
    public static final Property servletName = BObixServer.newProperty((int)1, (String)"obix", null);
    public static final Property debug = BObixServer.newProperty((int)0, (boolean)false, null);
    public static final Property lobby = BObixServer.newProperty((int)262, (BValue)new BObixLobby(), null);
    public static final Property allowSessionReuse = BObixServer.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BObixServer.class);
    private static final String servletPath = "/obix";
    private static final String soapPath = "/obix/soap";
    private static final String wsdlPath = "/obix/wsdl";
    private static final String xsdPath = "/obix/xsd";
    private static final String xslPath = "/obix/xsl";
    private static final BRelTime defaultMaxInactiveInterval = BRelTime.makeSeconds((int)60);
    private boolean licensed = true;
    private static byte[] xsd;
    private static byte[] xsl;

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public BObixLobby getLobby() {
        return (BObixLobby)this.get(lobby);
    }

    public void setLobby(BObixLobby v) {
        this.set(lobby, (BValue)v, null);
    }

    public boolean getAllowSessionReuse() {
        return this.getBoolean(allowSessionReuse);
    }

    public void setAllowSessionReuse(boolean v) {
        this.setBoolean(allowSessionReuse, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObixNetwork getObixNetwork() {
        for (BComplex cur = this.getParent(); cur != null; cur = cur.getParent()) {
            if (!(cur instanceof BObixNetwork)) continue;
            return (BObixNetwork)cur;
        }
        return null;
    }

    public String getServletPath() {
        return servletPath;
    }

    public String getSoapPath() {
        return soapPath;
    }

    public XElem getWsdl(WebOp cx) throws Exception {
        String url = cx.getRequest().getRequestURL().toString();
        BOrd o = BOrd.make((String)"module://obixDriver/com/tridium/obix/rsc/wsdl.xsd");
        BIFile f = (BIFile)o.resolve((BObject)this).get();
        XParser xin = XParser.make((InputStream)new ByteArrayInputStream(f.read()));
        XElem wsdlSchema = xin.parse();
        wsdlSchema.addAttr("targetNamespace", "http://obix.org/ns/wsdl/1.0");
        XElem imp = wsdlSchema.elem("import");
        String servletUri = url.substring(0, url.lastIndexOf(this.getWsdlPath()));
        String xsdLoc = ObixUtils.concat(servletUri, this.getXsdPath());
        if (imp != null) {
            imp.addAttr("schemaLocation", xsdLoc);
        }
        String soap = url.substring(0, url.indexOf(this.getServletPath()));
        soap = soap + this.getSoapPath();
        Wsdl wsdl = new Wsdl("oBIX", "http://obix.org/ns/wsdl/1.0", soap);
        wsdl.addType(wsdlSchema);
        wsdl.addOperation("read", new XElem("obixRead"), new XElem("obix:obj"));
        wsdl.addOperation("write", new XElem("obixWrite"), new XElem("obix:obj"));
        wsdl.addOperation("invoke", new XElem("obixInvoke"), new XElem("obix:obj"));
        XElem ret = wsdl.getDocument();
        ret.defineNs("obix", "http://obix.org/ns/schema/1.0");
        return ret;
    }

    public String getWsdlPath() {
        return wsdlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getXsd() throws Exception {
        String string = xsdPath;
        synchronized (xsdPath) {
            if (xsd == null) {
                BOrd o = BOrd.make((String)"module://obixDriver/com/tridium/obix/rsc/obix.xsd");
                BIFile f = (BIFile)o.resolve((BObject)this).get();
                xsd = f.read();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return xsd;
        }
    }

    public String getXsdPath() {
        return xsdPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getXsl() throws Exception {
        String string = xslPath;
        synchronized (xslPath) {
            if (xsl == null) {
                BOrd o = BOrd.make((String)"module://obixDriver/com/tridium/obix/rsc/obix.xsl");
                BIFile f = (BIFile)o.resolve((BObject)this).get();
                xsl = f.read();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return xsl;
        }
    }

    public String getXslPath() {
        return xslPath;
    }

    public OrdTarget resolve(String href, Context cx) {
        href = ObixUtils.replace(href, "~", "|obix:");
        href = ObixUtils.replace(href, "/|", "|");
        return this.getLobby().resolve(ObixUtils.resource('/' + this.getServletName(), href), cx);
    }

    public void service(SoapContext cx) throws Exception {
        XElem body = cx.getRequest().getBody().elem(0);
        String bodyName = body.name();
        String href = body.get("href");
        OrdTarget tgt = this.resolve(href, (Context)cx);
        if (!href.endsWith("/")) {
            href = href + '/';
        }
        XElem input = null;
        if (body.contentSize() > 0) {
            input = body.elem(0);
        }
        XElemTunnel res = new XElemTunnel(bodyName, this, tgt, href, input, cx);
        cx.getResponse().addEntry((XElem)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(WebOp op) throws Exception {
        block37: {
            boolean netWorkDisabled = this.getObixNetwork().getStatus().isDisabled();
            HttpServletRequest req = op.getRequest();
            try {
                InputStream in;
                ServletOutputStream out;
                String uri;
                ObixEncoder enc;
                block36: {
                    String query;
                    if (!this.licensed) {
                        op.getResponse().sendError(403, "Unlicensed oBIX Server");
                        return;
                    }
                    if (!this.getEnabled() || netWorkDisabled) {
                        op.getResponse().sendError(410, "oBIX Server Disabled");
                        return;
                    }
                    enc = null;
                    uri = req.getRequestURI();
                    if (req.getProtocol().endsWith("1.1") && "false".equals(System.getProperty("obix.disableChunked", "false"))) {
                        op.getResponse().setHeader("transfer-encoding", "chunked");
                    }
                    if ((query = req.getQueryString()) != null) {
                        uri = uri + '?' + query;
                    }
                    out = null;
                    in = null;
                    if (!uri.startsWith(this.getSoapPath())) break block36;
                    SoapletUtil.service((WebOp)op, (Soaplet)this);
                    return;
                }
                try {
                    String method = TextUtil.toUpperCase((String)req.getMethod());
                    if (!"GET".equals(method)) {
                        in = this.getFullyReadInputStream(req);
                    }
                    op.setContentType("text/xml");
                    out = op.getResponse().getOutputStream();
                    if (uri.equalsIgnoreCase(this.getXslPath())) {
                        out.write(this.getXsl());
                        break block37;
                    }
                    if (uri.equalsIgnoreCase(this.getXsdPath())) {
                        out.write(this.getXsd());
                        break block37;
                    }
                    if ("GET".equals(method) && uri.equalsIgnoreCase(this.getWsdlPath())) {
                        XWriter x = new XWriter((OutputStream)out);
                        this.getWsdl(op).write(x);
                        x.flush();
                        break block37;
                    }
                    String str = req.getRequestURL().toString();
                    if (!str.endsWith("/")) {
                        str = str + '/';
                    }
                    enc = new ObixEncoder('/' + this.getServletName(), str, (OutputStream)out);
                    enc.setDebug(this.getDebug());
                    XWriter w = enc.getWriter();
                    w.prolog();
                    w.w((Object)"<?xml-stylesheet type='text/xsl' href='");
                    w.w((Object)this.getXslPath()).w((Object)"'?>\n");
                    Map<String, String> m = enc.attributes();
                    m.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    m.put("xsi:schemaLocation", "http://obix.org/ns/schema/1.0 " + this.getXsdPath());
                    boolean debug = this.getDebug();
                    uri = BObixServer.convertPercents(uri, debug);
                    uri = BObixServer.convertVirtuals(uri, debug);
                    OrdTarget tgt = this.resolve(uri, (Context)op);
                    if ("GET".equals(method)) {
                        enc.encode(tgt);
                    } else {
                        ObixDecoder dec = new ObixDecoder(in, (Context)tgt);
                        dec.setDebug(this.getDebug());
                        int avail = in.available();
                        if (avail > 0) {
                            dec.getDocument();
                        }
                        if ((avail = in.available()) > 0) {
                            byte[] tmp = new byte[avail];
                            while (in.read(tmp) > 0) {
                            }
                        }
                        switch (method) {
                            case "PUT": {
                                ObixUtils.serviceWrite(tgt, dec, enc);
                                break;
                            }
                            case "POST": {
                                ObixUtils.serviceInvoke(tgt, dec, enc);
                                break;
                            }
                            default: {
                                throw new Exception("Unsupported HTTP method: " + method);
                            }
                        }
                    }
                    enc.commit();
                }
                catch (Exception x) {
                    if (out == null) {
                        out = op.getResponse().getOutputStream();
                    }
                    if (enc == null) {
                        String str = req.getRequestURL().toString();
                        if (!str.endsWith("/")) {
                            str = str + '/';
                        }
                        enc = new ObixEncoder('/' + this.getServletName(), str, (OutputStream)out);
                        enc.setDebug(this.getDebug());
                    }
                    enc.encode(x);
                    enc.commit();
                }
            }
            finally {
                String authHdr = req.getHeader("Authorization");
                if (authHdr == null || this.getAllowSessionReuse()) {
                    req.getSession(false).setMaxInactiveInterval(this.getMaxInactiveInterval().getSeconds());
                } else {
                    req.getSession(false).invalidate();
                }
            }
        }
    }

    public InputStream getFullyReadInputStream(HttpServletRequest req) throws Exception {
        if (req.getContentLength() == -1) {
            return req.getInputStream();
        }
        DataInputStream dataIn = new DataInputStream((InputStream)req.getInputStream());
        byte[] buffer = new byte[req.getContentLength()];
        dataIn.readFully(buffer);
        return new ByteArrayInputStream(buffer);
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            Feature feature = this.getObixNetwork().getLicenseFeature();
            this.licensed = feature.getb("export", false);
            if (!this.licensed) {
                this.configFatal("Server not licensed");
            }
        }
        catch (LicenseException x) {
            this.licensed = false;
            this.configFatal("Server not licensed");
            throw x;
        }
    }

    private static String convertPercents(String uri, boolean dbg) {
        String ret = uri;
        int pctNdx = uri.indexOf(37);
        if (pctNdx >= 0) {
            if (dbg) {
                System.out.println(" >>>>>>> Correcting percent-escaped URI " + uri + "...");
            }
            ret = SlotPath.unescape((String)uri.replace('%', '$'));
            if (dbg) {
                System.out.println(" >>>>>>> URI converted to " + ret);
            }
        }
        return ret;
    }

    private static String convertVirtuals(String uri, boolean dbg) {
        String ret = uri;
        int ndx = uri.indexOf("|virtual:");
        if (ndx >= 0) {
            if (dbg) {
                System.out.println(" >>>>>>> Converting Virtual component URI " + uri + "...");
            }
            StringBuilder sb = new StringBuilder(uri.substring(0, ndx + 9));
            String sp = uri.substring(ndx + 9);
            sp = SlotPath.unescape((String)sp);
            sb.append(sp);
            ret = sb.toString();
            if (dbg) {
                System.out.println(" >>>>>>> URI escaped to " + ret);
            }
        }
        return ret;
    }

    private BRelTime getMaxInactiveInterval() {
        Property p = this.getProperty("maxInactiveInterval");
        if (p == null) {
            return defaultMaxInactiveInterval;
        }
        if (!p.getType().is(BRelTime.TYPE)) {
            return defaultMaxInactiveInterval;
        }
        return (BRelTime)this.get(p).as(BRelTime.class);
    }
}

