/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver;

import com.tridium.obix.driver.export.BObixExportFolder;
import com.tridium.obix.driver.util.BObixThreadPool;
import com.tridium.obix.driver.util.BObixTuningPolicyMap;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixClientFolder;
import javax.baja.obix.driver.BObixServer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmSourceInfo", type="alarm:AlarmSourceInfo", defaultValue="new BAlarmSourceInfo()", flags=4, override=true), @NiagaraProperty(name="health", type="driver:PingHealth", defaultValue="new BPingHealth()", flags=4, override=true), @NiagaraProperty(name="threadPool", type="obixDriver:ObixThreadPool", defaultValue="new BObixThreadPool()"), @NiagaraProperty(name="tuningPolicies", type="driver:TuningPolicyMap", defaultValue="new BObixTuningPolicyMap()"), @NiagaraProperty(name="server", type="obixDriver:ObixServer", defaultValue="new BObixServer()"), @NiagaraProperty(name="exports", type="obixDriver:ObixExportFolder", defaultValue="new BObixExportFolder()"), @NiagaraProperty(name="historyPolicies", type="driver:HistoryNetworkExt", defaultValue="new BHistoryNetworkExt()")})
@NiagaraAction(name="println", parameterType="BString", defaultValue="BString.make(\"\")")
public class BObixNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property alarmSourceInfo = BObixNetwork.newProperty((int)4, (BValue)new BAlarmSourceInfo(), null);
    public static final Property health = BObixNetwork.newProperty((int)4, (BValue)new BPingHealth(), null);
    public static final Property threadPool = BObixNetwork.newProperty((int)0, (BValue)new BObixThreadPool(), null);
    public static final Property tuningPolicies = BObixNetwork.newProperty((int)0, (BValue)new BObixTuningPolicyMap(), null);
    public static final Property server = BObixNetwork.newProperty((int)0, (BValue)new BObixServer(), null);
    public static final Property exports = BObixNetwork.newProperty((int)0, (BValue)new BObixExportFolder(), null);
    public static final Property historyPolicies = BObixNetwork.newProperty((int)0, (BValue)new BHistoryNetworkExt(), null);
    public static final Action println = BObixNetwork.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BObixNetwork.class);
    private HashMap<String, LicenzLimit> limitz;

    public BObixThreadPool getThreadPool() {
        return (BObixThreadPool)this.get(threadPool);
    }

    public void setThreadPool(BObixThreadPool v) {
        this.set(threadPool, (BValue)v, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public BObixServer getServer() {
        return (BObixServer)this.get(server);
    }

    public void setServer(BObixServer v) {
        this.set(server, (BValue)v, null);
    }

    public BObixExportFolder getExports() {
        return (BObixExportFolder)this.get(exports);
    }

    public void setExports(BObixExportFolder v) {
        this.set(exports, (BValue)v, null);
    }

    public BHistoryNetworkExt getHistoryPolicies() {
        return (BHistoryNetworkExt)this.get(historyPolicies);
    }

    public void setHistoryPolicies(BHistoryNetworkExt v) {
        this.set(historyPolicies, (BValue)v, null);
    }

    public void println(BString parameter) {
        this.invoke(println, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void doPrintln(BString arg) {
        System.out.println("\n\n********\n" + arg + "\n********\n");
    }

    public void enqueue(Runnable r) {
        this.getThreadPool().post(r);
    }

    public Type getDeviceFolderType() {
        return BObixClientFolder.TYPE;
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "obixDriver");
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        if (kids == null) {
            return new BINavNode[]{this.getExports()};
        }
        BINavNode[] ret = new BINavNode[kids.length + 1];
        ret[0] = this.getExports();
        System.arraycopy(kids, 0, ret, 1, kids.length);
        return ret;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void serviceStarted() {
        int maxThds = this.getThreadPool().getMaxThreads();
        int devsCnt = this.getDevices().length;
        if (devsCnt > maxThds) {
            this.getThreadPool().setMaxThreads(devsCnt);
        }
    }

    public void serviceStopped() {
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.limitz != null) {
            out.startTable(true);
            out.trTitle((Object)"Obix License Limits", 3);
            out.w((Object)"<tr>").th((Object)"Feature").th((Object)"Used").th((Object)"Limit").w((Object)"</tr>\n");
            for (LicenzLimit lic : this.limitz.values()) {
                String limit = lic.limit == Integer.MAX_VALUE ? "none" : "" + lic.limit;
                out.tr((Object)lic.key, (Object)("" + lic.used), (Object)limit);
            }
            out.endTable();
        }
        super.spy(out);
    }

    public final void started() throws Exception {
        try {
            super.started();
            if (Sys.getService((Type)TYPE) != this) {
                this.configFail("Duplicate ObixNetwork");
                throw new IllegalStateException("Only one ObixNetwork allowed per station.");
            }
            this.checkObixLicense();
            this.networkStarted();
        }
        catch (ServiceNotFoundException e) {
            this.getLogger().log(Level.SEVERE, "ObixNetwork not registered as a service!", e);
        }
    }

    protected void networkStarted() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String checkObixLimit(String key) {
        if (this.limitz == null) {
            return null;
        }
        HashMap<String, LicenzLimit> hashMap = this.limitz;
        synchronized (hashMap) {
            LicenzLimit lic = this.limitz.get(key);
            if (lic == null) {
                return "Unlicensed: " + key;
            }
            ++lic.used;
            if (lic.used > lic.limit) {
                return "Exceeded " + lic.key + " of " + lic.limit;
            }
            return null;
        }
    }

    private void checkObixLicense() {
        try {
            Feature feature = this.getObixFeature();
            if (feature == null) {
                return;
            }
            this.limitz = new HashMap();
            String[] keys = feature.list();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.endsWith(".limit")) continue;
                String val = feature.get(key);
                int limit = Integer.MAX_VALUE;
                if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
                    limit = Integer.parseInt(val);
                }
                LicenzLimit lic = new LicenzLimit();
                lic.key = key;
                lic.used = 0;
                lic.limit = limit;
                this.limitz.put(key, lic);
            }
        }
        catch (Exception e) {
            this.configFatal("Unlicensed: " + e);
            this.getLogger().log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
        }
    }

    private final Feature getObixFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "obixDriver");
    }

    static class LicenzLimit {
        String key;
        int limit;
        int used;

        LicenzLimit() {
        }

        public String toString() {
            return this.key + "(" + this.used + "/" + this.limit + ")";
        }
    }
}

