/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.util;

import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BAlarmLobbyAgent;
import com.tridium.obix.server.BContractLobbyAgent;
import com.tridium.obix.server.BStationLobbyAgent;
import com.tridium.obix.server.BUnitLobbyAgent;
import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.PermissionErr;
import com.tridium.obix.util.WrapperException;
import com.tridium.program.BCode;
import com.tridium.sys.Nre;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.obix.driver.lobby.BObixLobby;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.BIObixWritable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.security.BPassword;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

public class ObixUtils
implements ObixConstants {
    private static final long MILLIS_MIN = 60000L;
    private static final long MILLIS_HOUR = 3600000L;
    private static final long MILLIS_DAY = 86400000L;
    private static final long MAX_EXECUTE_WAIT_TICKS = 5000L;
    private static final BIcon objIcon = new BComponent().getIcon();

    public static boolean bool(String val) {
        if (val.equals("false")) {
            return false;
        }
        if (val.equals("0")) {
            return false;
        }
        return !val.equalsIgnoreCase("false");
    }

    public static boolean bool(String val, boolean def) {
        if (val == null) {
            return def;
        }
        return ObixUtils.bool(val);
    }

    public static XElem child(String name, XElem parent) {
        int len = parent.contentSize();
        for (int i = 0; i < len; ++i) {
            XElem e;
            String s;
            XContent kid = parent.content(i);
            if (!(kid instanceof XElem) || !(s = (e = (XElem)kid).get("name", "")).equals(name)) continue;
            return e;
        }
        return null;
    }

    public static String concat(String path1, String path2) {
        if (path1.equals("")) {
            return path2;
        }
        boolean p1 = path1.endsWith("/");
        boolean p2 = path2.startsWith("/");
        if (p1 && p2) {
            return path1 + path2.substring(1);
        }
        if (p1 || p2) {
            return path1 + path2;
        }
        return path1 + '/' + path2;
    }

    public static String dateTime(BAbsTime dt) {
        return dt.encodeToString();
    }

    public static BAbsTime dateTime(String encoded) {
        try {
            return (BAbsTime)BAbsTime.DEFAULT.decodeFromString(encoded);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public static String duration(long millis) {
        boolean neg;
        boolean bl = neg = millis < 0L;
        if (neg) {
            millis = -millis;
        }
        int d = (int)(millis / 86400000L);
        int h = (int)((millis %= 86400000L) / 3600000L);
        int mn = (int)((millis %= 3600000L) / 60000L);
        int s = (int)((millis %= 60000L) / 1000L);
        long ms = millis % 1000L;
        return ObixUtils.duration(neg, 0, 0, d, h, mn, s, ms);
    }

    public static long duration(String s) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        long millis = 0L;
        try {
            boolean neg = false;
            DurationParser p = new DurationParser(s);
            if (p.cur == 45) {
                neg = true;
                p.consume();
            } else if (p.cur == 43) {
                p.consume();
            }
            p.consume(80);
            if (p.cur == -1) {
                throw new Exception();
            }
            int num = p.num();
            if (p.cur == 68) {
                p.consume();
                millis += (long)num * 24L * 60L * 60L * 1000L;
                num = p.num();
            }
            if (num >= 0 && p.cur == 72) {
                if (!p.time) {
                    throw new Exception();
                }
                p.consume();
                millis += (long)num * 60L * 60L * 1000L;
                num = p.num();
            }
            if (num >= 0 && p.cur == 77) {
                if (!p.time) {
                    throw new Exception();
                }
                p.consume();
                millis += (long)num * 60L * 1000L;
                num = p.num();
            }
            if (num >= 0 && p.cur == 83 || p.cur == 46) {
                if (!p.time) {
                    throw new Exception();
                }
                millis += (long)num * 1000L;
                if (p.cur == 46) {
                    p.consume();
                    millis += (long)p.frac();
                }
                p.consume(83);
            }
            if (p.cur != -1) {
                throw new Exception();
            }
            if (neg) {
                millis *= -1L;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid duration: " + s);
        }
        return millis;
    }

    public static void encode(ObixEncoder enc, Obj obj, BObject val, OrdTarget cx) throws Exception {
        try {
            BIcon icon = val.getIcon();
            if (!icon.equals((Object)objIcon)) {
                BOrd ord = icon.getOrdList().get(0);
                obj.setIcon("/ord?" + ord.toString(null));
            }
        }
        catch (Exception icon) {
            // empty catch block
        }
        obj.setDisplay(val.toString((Context)cx));
        if (val instanceof BComplex) {
            BComplex vals = (BComplex)val;
            if (enc.getName() != null) {
                obj.setDisplayName(vals.getDisplayName((Context)cx));
            }
            ObixUtils.encodeContracts(obj, val, enc);
        } else if (val instanceof BValue) {
            Slot s = ObixUtils.getSlot(cx);
            if (s != null && enc.getName() != null) {
                obj.setDisplayName(s.getDefaultDisplayName((Context)cx));
            }
            if (val instanceof BSimple) {
                if (cx.canWrite()) {
                    obj.setWritable(Boolean.TRUE);
                }
                ObixUtils.encodeSimple(enc, obj, (BSimple)val, (Context)cx);
                if (enc.encodeSimpleContracts() && obj.getElement() == "str" && !(val instanceof BString)) {
                    ObixUtils.encodeContracts(obj, val, enc);
                }
            } else {
                ObixUtils.encodeContracts(obj, val, enc);
            }
        } else if (val instanceof BINavNode) {
            BINavNode n = (BINavNode)val;
            obj.setDisplay(n.getClass().getName());
            if (enc.getName() != null) {
                obj.setDisplayName(n.getNavDisplayName((Context)cx));
            }
        }
    }

    public static void encodeContracts(Obj obj, BObject val, ObixEncoder cx) throws Exception {
        ObixUtils.encodeContracts(obj, val.getType(), cx);
    }

    public static void encodeContracts(Obj obj, Type t, ObixEncoder cx) throws Exception {
        for (Type cur = t; cur != null; cur = cur.getSuperType()) {
            if (cur == BComponent.TYPE || cur == BStruct.TYPE || cur == BObject.TYPE || cur == BValue.TYPE) {
                return;
            }
            if (cur.is(BSimple.TYPE)) {
                if (t.is(BAbsTime.TYPE)) {
                    obj.addContract("obix:abstime");
                } else if (t.is(BRelTime.TYPE)) {
                    obj.addContract("obix:reltime");
                } else if (t.is(BIBoolean.TYPE)) {
                    obj.addContract("obix:bool");
                } else if (t.is(BIEnum.TYPE)) {
                    obj.addContract("obix:enum");
                } else if (t.is(BOrd.TYPE)) {
                    obj.addContract("obix:uri");
                } else if (t.is(BInteger.TYPE)) {
                    obj.addContract("obix:int");
                } else if (t.is(BFloat.TYPE)) {
                    obj.addContract("obix:real");
                } else if (t.is(BDouble.TYPE)) {
                    obj.addContract("obix:real");
                } else if (!cur.isAbstract()) {
                    obj.addContract(ObixUtils.makeContractUri(cx, cur));
                }
                return;
            }
            if (cur.isAbstract()) continue;
            obj.addContract(ObixUtils.makeContractUri(cx, cur));
        }
    }

    public static void encodeSimple(ObixEncoder enc, Obj obj, BSimple val, Context cx) throws Exception {
        if (val instanceof BAbsTime) {
            BObject tzf;
            obj.setIs(null);
            obj.setElement("abstime");
            BAbsTime t = (BAbsTime)val;
            obj.setVal(ObixUtils.dateTime(t));
            BFacets f = cx.getFacets();
            String tz = null;
            if (f != null && (tzf = f.getFacet("TimeZone")) != null) {
                tz = tzf.toString();
            }
            if (tz == null) {
                tz = t.getTimeZone().getId();
            }
            obj.setTz(tz);
        } else if (val instanceof BRelTime) {
            obj.setIs(null);
            obj.setElement("reltime");
            obj.setVal(ObixUtils.duration(((BRelTime)val).getMillis()));
        } else if (val instanceof BIBoolean) {
            obj.setElement("bool");
            BIBoolean ibool = (BIBoolean)val;
            obj.setVal(String.valueOf(ibool.getBoolean()));
            BFacets f = cx.getFacets();
            if (f == null) {
                f = ibool.getBooleanFacets();
            }
            if (ObixUtils.isBoolFacets(f)) {
                BString s = null;
                s = ibool.getBoolean() ? (BString)f.get("trueText") : (BString)f.get("falseText");
                if (s != null) {
                    obj.setDisplay(s.toString(cx));
                }
                if (obj.getHref() != null) {
                    obj.setRange(ObixUtils.makeBoolRangeUri(obj.getHref()));
                }
            }
        } else if (val instanceof BIEnum) {
            obj.setIs(null);
            obj.setElement("enum");
            BIEnum e = (BIEnum)val;
            int ordinal = e.getEnum().getOrdinal();
            BEnumRange r = (BEnumRange)cx.getFacets().get("range");
            if (r == null || r.getOrdinals().length == 0) {
                r = e.getEnum().getRange();
            }
            obj.setVal(r.getTag(ordinal));
            obj.setDisplay(r.getDisplayTag(ordinal, cx));
            int[] instance = r.getOrdinals();
            int[] frozen = null;
            Type frozenType = r.getFrozenType();
            if (frozenType != null) {
                frozen = ((BEnum)frozenType.getInstance()).getRange().getOrdinals();
            }
            if (frozen != null && frozen.length == instance.length) {
                if (frozenType.is(BWeekday.TYPE)) {
                    obj.setRange("obix:Weekday");
                } else if (frozenType.is(BMonth.TYPE)) {
                    obj.setRange("obix:Month");
                } else {
                    obj.setRange(ObixUtils.makeRangeUri(ObixUtils.makeContractUri(enc, r.getFrozenType())));
                }
            } else if (obj.getHref() != null) {
                obj.setRange(ObixUtils.makeRangeUri(obj.getHref()));
            }
        } else if (val instanceof BINumeric) {
            ObixUtils.encodeNumeric(enc, obj, (BINumeric)val, cx);
        } else if (val instanceof BString) {
            obj.setElement("str");
            obj.setVal(val.toString());
            ObixUtils.checkForProgramCode(obj, cx);
        } else if (val instanceof BOrd) {
            obj.setElement("uri");
            obj.setVal(val.toString(cx));
        } else if (val instanceof BPassword) {
            obj.setElement("str");
            obj.setVal("");
        } else {
            obj.setElement("str");
            try {
                obj.setVal(val.encodeToString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ObixUtils.checkForProgramCode(obj, cx);
        }
    }

    private static void checkForProgramCode(Obj obj, Context cx) {
        String name;
        OrdTarget ot;
        if (cx instanceof OrdTarget && (ot = (OrdTarget)cx).getComponent() instanceof BCode && ((name = ot.getPropertyInParent().getName()) == "source" || name == "classFile")) {
            obj.setVal("");
            obj.setDisplay("");
        }
    }

    public static BComplex getParent(OrdTarget t) {
        BComponent parent = t.getComponent();
        Property[] ary = t.getPropertyPathInComponent();
        if (ary == null) {
            return parent;
        }
        int idx = ary.length - 1;
        for (int i = 0; i < idx; ++i) {
            parent = (BComplex)parent.get(ary[i]);
        }
        return parent;
    }

    public static Slot getSlot(OrdTarget t) {
        Property[] ary = t.getPropertyPathInComponent();
        if (ary == null || ary.length == 0) {
            return t.getSlotInComponent();
        }
        return ary[ary.length - 1];
    }

    public static int num(String val, int def) {
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static String makeAlarmUri(ObixEncoder out, String uuid) {
        if (uuid == null) {
            return null;
        }
        return ObixUtils.concat(ObixUtils.concat(out.getLobbyPath(), BAlarmLobbyAgent.LOBBY_NAME), uuid);
    }

    public static String makeBoolRangeUri(String path) {
        int i = path.indexOf("~param");
        if (i > 0) {
            path = path.substring(0, i);
        }
        return ObixUtils.concat(path, "~bool");
    }

    public static String makeContractUri(ObixEncoder out, Type type) throws Exception {
        return ObixUtils.concat(ObixUtils.concat(out.getLobbyPath(), BContractLobbyAgent.LOBBY_NAME), type.getTypeSpec().encodeToString());
    }

    public static String makeSlotPathUri(ObixEncoder out, String path) {
        return ObixUtils.concat(ObixUtils.concat(out.getLobbyPath(), BStationLobbyAgent.LOBBY_NAME), path);
    }

    public static String makeRangeUri(String path) {
        if (path == null) {
            return "~range";
        }
        return ObixUtils.concat(path, "~range");
    }

    public static String makeUnitUri(ObixEncoder out, BUnit unit) {
        if (unit == null || unit.isNull()) {
            return null;
        }
        return ObixUtils.concat(ObixUtils.concat(out.getLobbyPath(), BUnitLobbyAgent.LOBBY_NAME), unit.getUnitName());
    }

    public static String resource(String lobby, String uri) {
        int idx = uri.indexOf(lobby);
        if (idx < 0) {
            throw new BadUriErr();
        }
        if ((uri = uri.substring(idx + lobby.length())).equals("") || uri.equals("/")) {
            return "/";
        }
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static void serviceInvoke(OrdTarget ot, ObixDecoder dec, ObixEncoder enc) throws Exception {
        BObject tgt = ot.get();
        if (tgt instanceof BIObixInvocable) {
            ((BIObixInvocable)tgt).invoke(dec, enc);
        } else {
            Action a = (Action)ot.getSlotInComponent();
            if (tgt instanceof BObixLobby && a == null) {
                enc.encode(ot);
                return;
            }
            if (a == null) {
                throw new BadUriErr("POST " + enc.getHref());
            }
            BValue val = null;
            if (a.getParameterDefault() != null) {
                val = dec.decode(a.getParameterDefault());
            }
            BValue res = ot.getComponent().invoke(a, val, (Context)ot);
            int count = AccessController.doPrivileged(() -> Nre.getEngineManager()).getCycles();
            long ticks = Clock.ticks();
            int cycles = ObixUtils.waitForPointExecute(ot, count, ticks);
            enc.setHref(null);
            if (res instanceof BIObixEncodable) {
                ((BIObixEncodable)res).encode(enc, (Context)ot);
            } else {
                OrdTarget ot2 = ot.getOrd().getParent().resolve(null);
                enc.encode(new ObixTarget(ot2, (BObject)res));
            }
            if (enc.isDebug()) {
                System.out.println("EngineManager cycles waiting for post-invoke execution = " + cycles);
            }
        }
    }

    public static void serviceWrite(OrdTarget ot, ObixDecoder dec, ObixEncoder enc) throws Exception {
        BObject tgt = ot.get();
        try {
            if (tgt instanceof BIObixWritable) {
                ((BIObixWritable)tgt).write(dec);
            } else {
                if (tgt == null || ot.getPropertyInParent() == null) {
                    throw new BadUriErr("PUT " + enc.getHref());
                }
                tgt = tgt.asValue().newCopy(true);
                BValue val = dec.decode(tgt.asValue());
                BComponent parent = ot.getComponent();
                String name = ot.getPropertyInParent().getName();
                if (parent instanceof BCode && (name == "source" || name == "classFile")) {
                    throw new PermissionException("Cannot write program code");
                }
                Property[] pary = ot.getPropertyPathInComponent();
                int idx = pary.length - 1;
                for (int i = 0; i < idx; ++i) {
                    parent = (BComplex)parent.get(pary[i]);
                }
                parent.set(pary[idx], val, (Context)ot.getUser());
            }
            OrdTarget ot2 = ot.getOrd().resolve();
            enc.encode(ot2);
        }
        catch (PermissionException pe) {
            throw new PermissionErr(ot.getUser().getName() + " cannot write this object");
        }
    }

    public static String servletUri(String url, String servletName) {
        int idx = url.indexOf("://");
        idx = idx > 0 ? url.indexOf(47, idx + 3) : url.indexOf(47);
        if (idx < 0) {
            return url;
        }
        idx = url.indexOf(servletName);
        if (idx < 0) {
            return url;
        }
        return url.substring(0, idx + servletName.length()) + "/";
    }

    public static String toPath(OrdTarget t) {
        BComponent comp = t.getComponent();
        String ret = comp.toPathString();
        Property[] ary = t.getPropertyPathInComponent();
        if (ary == null) {
            return ret;
        }
        int len = ary.length;
        for (int i = 0; i < len; ++i) {
            ret = ObixUtils.concat(ret, ary[i].getName());
        }
        return ret;
    }

    public static String[] toPathArray(String path) {
        Vector<String> v = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == '/') {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static String toString(XElem e) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XWriter x = new XWriter((OutputStream)out);
            e.write(x);
            x.flush();
            return new String(out.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String ndEscape(String s) {
        if (s.length() == 0) {
            return "";
        }
        s = SlotPath.escape((String)s);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '$') continue;
            chars[i] = 37;
        }
        return new String(chars);
    }

    public static String ndUnescape(String s) {
        if (s.length() == 0) {
            return "";
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '%') continue;
            chars[i] = 36;
        }
        String s2 = new String(chars);
        int ndx = s2.indexOf("|virtual:");
        if (ndx < 0) {
            return SlotPath.unescape((String)s2);
        }
        String s3 = s2.substring(0, ndx + 9);
        s3 = s3 + SlotPath.unescape((String)s2.substring(ndx + 9));
        return s3;
    }

    public static String replace(String src, String tok, String neu) {
        if (src == null) {
            return null;
        }
        int to = src.indexOf(tok);
        if (to < 0) {
            return src;
        }
        StringBuffer buf = new StringBuffer();
        int from = 0;
        int toklen = tok.length();
        while (to >= 0) {
            buf.append(src.substring(from, to));
            buf.append(neu);
            from = to + toklen;
            to = src.indexOf(tok, from);
        }
        if (from < src.length()) {
            buf.append(src.substring(from));
        }
        return buf.toString();
    }

    static void encodeNumeric(ObixEncoder enc, Obj obj, BINumeric val, Context cx) throws Exception {
        int i;
        double d;
        boolean integer = val instanceof BInteger;
        obj.setIs(null);
        if (integer) {
            obj.setElement("int");
            obj.setVal(new Integer((int)val.getNumeric()).toString());
        } else {
            obj.setElement("real");
            obj.setVal(String.valueOf(val.getNumeric()));
        }
        BFacets f = cx.getFacets();
        if (f == null) {
            f = val.getNumericFacets();
        }
        if (f.get("min") != null && !Double.isInfinite(d = f.getd("min", 0.0))) {
            if (integer) {
                obj.setMin(String.valueOf((int)d));
            } else {
                obj.setMin(String.valueOf(d));
            }
        }
        if (f.get("max") != null && !Double.isInfinite(d = f.getd("max", 0.0))) {
            if (integer) {
                obj.setMax(String.valueOf((int)d));
            } else {
                obj.setMax(String.valueOf(d));
            }
        }
        if (f.get("units") != null) {
            BUnit u = (BUnit)f.get("units");
            if (UnitDatabase.getUnit((String)u.getUnitName()) != null) {
                obj.setUnits("obix:units/" + u.getUnitName());
            } else {
                obj.setUnits(ObixUtils.makeUnitUri(enc, u));
            }
        }
        if (f.get("precision") != null && (i = f.geti("precision", 1)) != 1) {
            obj.setPrecision(String.valueOf(i));
        }
    }

    private static String duration(boolean n, int y, int mon, int d, int h, int min, int s, long ms) {
        StringBuffer sb = new StringBuffer();
        if (n) {
            sb.append('-');
        }
        sb.append('P');
        if (y != 0) {
            sb.append(y).append('Y');
        }
        if (mon != 0) {
            sb.append(mon).append('M');
        }
        if (d != 0) {
            sb.append(d).append("D");
        }
        sb.append("T");
        if (h != 0) {
            sb.append(h).append('H');
        }
        if (min != 0) {
            sb.append(min).append('M');
        }
        sb.append(s);
        if (ms != 0L) {
            sb.append('.').append(ms);
        }
        sb.append('S');
        return sb.toString();
    }

    private static boolean isBoolFacets(BFacets f) {
        if (f.isNull()) {
            return false;
        }
        if (f.get("trueText") != null) {
            return true;
        }
        return f.get("falseText") != null;
    }

    private static int waitForPointExecute(OrdTarget ot, int cycleCount, long startTicks) {
        BComponent c = ot.getComponent();
        long endTicks = startTicks + 5000L;
        int ret = 0;
        if (c instanceof BControlPoint) {
            int count = AccessController.doPrivileged(() -> Nre.getEngineManager()).getCycles();
            long ticks = Clock.ticks();
            long sleep = 10L;
            while (count == cycleCount && ticks < endTicks) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                count = AccessController.doPrivileged(() -> Nre.getEngineManager()).getCycles();
                ticks = Clock.ticks();
                sleep += 10L;
                ++ret;
            }
            return ret;
        }
        return -1;
    }

    static class DurationParser {
        String s;
        int off;
        int cur;
        boolean curIsDigit;
        boolean time;

        DurationParser(String s) {
            this.s = s;
            this.cur = s.charAt(0);
        }

        int frac() {
            int millis = 0;
            if (this.curIsDigit) {
                millis += this.digit() * 100;
                this.consume();
                if (this.curIsDigit) {
                    millis += this.digit() * 10;
                    this.consume();
                    if (this.curIsDigit) {
                        millis += this.digit();
                        this.consume();
                        while (this.curIsDigit) {
                            this.consume();
                        }
                    }
                }
            }
            return millis;
        }

        int num() {
            if (this.cur == 84) {
                this.time = true;
                this.consume();
            }
            int num = 0;
            while (this.curIsDigit) {
                num = num * 10 + this.digit();
                this.consume();
            }
            return num;
        }

        int digit() {
            return this.cur - 48;
        }

        void consume(int ch) {
            if (this.cur != ch) {
                throw new IllegalStateException();
            }
            this.consume();
        }

        void consume() {
            ++this.off;
            if (this.off < this.s.length()) {
                this.cur = this.s.charAt(this.off);
                this.curIsDigit = 48 <= this.cur && this.cur <= 57;
            } else {
                this.cur = -1;
                this.curIsDigit = false;
            }
        }
    }
}

