/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.history.rollup.BHistoryRollup;
import com.tridium.history.rollup.BHistoryRollupRecord;
import com.tridium.obix.server.BObixHistoryAgent;
import com.tridium.obix.util.Obj;
import javax.baja.collection.BITable;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BObixHistoryRollup
extends BObject
implements BIObixEncodable,
BIObixInvocable {
    public static final Type TYPE = Sys.loadType(BObixHistoryRollup.class);
    BIHistory history;

    public Type getType() {
        return TYPE;
    }

    public BObixHistoryRollup() {
    }

    public BObixHistoryRollup(BIHistory history) {
        this.history = history;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        obj.initOp("rollup", "obix:HistoryRollupIn", "obix:HistoryRollupOut");
        obj.setHref(out.getHref());
        obj.write(out, false);
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        BRelTime interval = null;
        BInteger limit = BInteger.MAX;
        BAbsTime start = null;
        BAbsTime end = null;
        try {
            BComponent filter = (BComponent)in.decode();
            if (filter != null) {
                limit = (BInteger)filter.get("limit");
                start = (BAbsTime)filter.get("start");
                end = (BAbsTime)filter.get("end");
                interval = (BRelTime)filter.get("interval");
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        Obj obj = new Obj().setIs("obix:HistoryQueryOut");
        obj.setHref(out.getHref());
        obj.write(out, true);
        obj.initList("data", "obix:HistoryRollupRecord").write(out, true);
        out.commit();
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
            BITable results = conn.timeQuery(this.history, start, end);
            BITable rollupResults = BHistoryRollup.rollup((BITable)results, (BRelTime)interval);
            OrdTarget base = this.history.getOrdInSession().resolve(null, (Context)in);
            BObixHistoryAgent.RollupResults res = BObixHistoryAgent.iterateRollupResults(out, (BITable<BHistoryRollupRecord>)rollupResults, limit, base);
            obj.initList(null, null).endElem(out);
            obj.initInt("count", res.count).write(out, false);
            if (res.first != null) {
                obj.initAbstime("start", res.first.getTimestamp()).write(out, false);
            } else if (start != null) {
                obj.initAbstime("start", start).write(out, false);
            }
            if (res.last != null) {
                obj.initAbstime("end", res.last.getEndTimestamp()).write(out, false);
            } else if (end != null) {
                obj.initAbstime("end", end).write(out, false);
            }
            obj.reset().endElem(out);
        }
    }
}

