/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.util.Obj;
import java.util.StringTokenizer;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BObixHistoryAppend
extends BObject
implements BIObixEncodable,
BIObixInvocable {
    public static final Type TYPE = Sys.loadType(BObixHistoryAppend.class);
    BIHistory history;
    BHistoryRecord rec;
    String uri;

    public Type getType() {
        return TYPE;
    }

    public BObixHistoryAppend(BIHistory history) {
        this(history, null);
    }

    public BObixHistoryAppend(BIHistory history, OrdQuery query) {
        this.history = history;
    }

    public BObixHistoryAppend(String uri) {
        this.uri = uri;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        obj.initOp("append", "obix:HistoryAppendIn", "obix:HistoryAppendOut");
        obj.setHref(out.getHref());
        obj.write(out, false);
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        Obj obj = new Obj().setIs("obix:HistoryQueryOut");
        BAbsTime existingLastTS = BAbsTime.DEFAULT;
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistorySpaceConnection conn = db.getConnection(null);){
            BAbsTime newEnd;
            BValue v;
            BAbsTime ts;
            Type valueType;
            BComplex addRec;
            int numAdded = 0;
            int ndx = 0;
            BAbsTime previousTS = BAbsTime.DEFAULT;
            in.setDebug(true);
            BComponent appendRecords = (BComponent)in.decode();
            BComplex data = (BComplex)appendRecords.get("data");
            SlotCursor c = data.getProperties();
            if (this.history == null) {
                if (out.isDebug()) {
                    System.out.println("create history from uri " + this.uri);
                }
                StringTokenizer st = new StringTokenizer(this.uri, "/");
                String stationName = st.nextToken();
                String historyName = st.nextToken();
                int hndx = historyName.indexOf(124);
                if (hndx > 0) {
                    historyName = historyName.substring(0, hndx);
                }
                if (!stationName.equals(Sys.getStation().getStationName())) {
                    throw new IllegalArgumentException("History name must match station name");
                }
                if (!c.next()) {
                    throw new IllegalArgumentException("List of append records is empty!");
                }
                addRec = (BComplex)c.get();
                this.history = this.makeHistory(conn, BHistoryId.make((String)stationName, (String)historyName), addRec.get("value"));
                valueType = this.rec.get("value").getType();
                ts = (BAbsTime)addRec.get("timestamp");
                v = addRec.get("value");
                if (ts == null || v == null) {
                    throw new IllegalArgumentException("Append record 0 does not have proper format");
                }
                previousTS = ts;
                ++ndx;
            } else {
                this.rec = (BHistoryRecord)this.history.getRecordType().getInstance();
                valueType = this.rec.get("value").getType();
                existingLastTS = conn.getLastTimestamp(this.history);
            }
            while (c.next()) {
                addRec = (BComplex)c.get();
                ts = (BAbsTime)addRec.get("timestamp");
                v = addRec.get("value");
                if (ts == null || v == null) {
                    throw new IllegalArgumentException("Append record " + ndx + " does not have proper format");
                }
                if (!ts.isAfter(existingLastTS)) {
                    throw new IllegalArgumentException("Append record " + ndx + " timestamp is before existing last timestamp");
                }
                if (!ts.isAfter(previousTS)) {
                    throw new IllegalArgumentException("Append record " + ndx + " timestamp is out of order");
                }
                if (v.getType() != valueType) {
                    throw new IllegalArgumentException("Append record " + ndx + " value type [" + v.getType() + "] does not match history type [" + valueType + ']');
                }
                previousTS = ts;
                ++ndx;
            }
            c = data.getProperties();
            while (c.next()) {
                addRec = (BComplex)c.get();
                ts = (BAbsTime)addRec.get("timestamp");
                v = addRec.get("value");
                this.rec.setTimestamp(ts);
                this.rec.set("value", v);
                conn.append(this.history, (BIHistoryRecordSet)this.rec);
                ++numAdded;
                newEnd = ts;
            }
            obj.setHref(out.getHref());
            obj.write(out, true);
            BAbsTime newStart = conn.getFirstTimestamp(this.history);
            newEnd = conn.getLastTimestamp(this.history);
            int newCount = conn.getRecordCount(this.history);
            obj.initInt("numAdded", numAdded).write(out, false);
            obj.initInt("newCount", newCount).write(out, false);
            obj.initAbstime("newStart", newStart).write(out, false);
            obj.initAbstime("newEnd", newEnd).write(out, false);
            obj.reset().endElem(out);
        }
        catch (Exception e) {
            e.printStackTrace();
            out.encode(e);
        }
    }

    private BIHistory makeHistory(HistorySpaceConnection conn, BHistoryId historyId, BValue v) {
        BHistoryConfig config = new BHistoryConfig();
        config.setCapacity(BCapacity.UNLIMITED);
        config.setId(historyId);
        Type t = v.getType();
        if (this.rec == null) {
            this.rec = t.is(BDouble.TYPE) ? new BNumericTrendRecord() : (t.is(BBoolean.TYPE) ? new BBooleanTrendRecord() : (t.is(BInteger.TYPE) ? new BEnumTrendRecord() : new BStringTrendRecord()));
        }
        config.setRecordType(this.rec.getType().getTypeSpec());
        if (!conn.exists(historyId)) {
            conn.createHistory(config);
        }
        return conn.getHistory(historyId);
    }
}

