/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BAlarmServiceAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixWatchable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BAlarmServiceFeed
extends BObject
implements BIObixEncodable,
BIObixWatchable {
    public static final Type TYPE = Sys.loadType(BAlarmServiceFeed.class);
    BAbsTime end;
    String href;
    BAbsTime last;
    BInteger limit;
    BAlarmService service;
    BAlarmClass alarmClass;
    BAbsTime start;
    OrdTarget target;

    public Type getType() {
        return TYPE;
    }

    public BAlarmServiceFeed() {
    }

    public BAlarmServiceFeed(BAlarmService service) {
        this.service = service;
    }

    public BAlarmServiceFeed(BAlarmClass ac) {
        this.alarmClass = ac;
        this.service = (BAlarmService)ac.getParent();
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        obj.initFeed(null, "obix:AlarmFilter", "obix:Alarm");
        obj.setHref(out.getHref());
        obj.write(out, false);
    }

    @Override
    public String getWatchHref() {
        return this.href;
    }

    @Override
    public OrdTarget getWatchTarget(Context cx) {
        return this.target;
    }

    @Override
    public void watchCleanup() {
    }

    @Override
    public void watchInit(XElem uri, OrdTarget target) {
        this.href = uri.get("val");
        this.target = target;
        try {
            ObixDecoder in;
            BComponent filter;
            XElem arg = ObixUtils.child("in", uri);
            if (arg != null && (filter = (BComponent)(in = new ObixDecoder(arg, (Context)target)).decode()) != null) {
                this.limit = (BInteger)filter.get("limit");
                this.start = (BAbsTime)filter.get("start");
                this.end = (BAbsTime)filter.get("end");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void watchChanges(ObixEncoder out, Context cx) {
        Obj obj = new Obj().initFeed(null, "obix:AlarmFilter", "obix:Alarm");
        obj.setHref(this.href).write(out, true);
        out.commit();
        BOrd o = BOrd.make((String)BAlarmServiceAgent.queryChanges(this.last, this.end, this.alarmClass));
        this.last = Clock.time();
        BITable results = (BITable)o.resolve((BObject)this.service).get();
        BAlarmServiceAgent.IterationResults res = BAlarmServiceAgent.iterateResults(this.limit, (BITable<BAlarmRecord>)results, obj, out, cx);
        if (res.last != null) {
            this.last = res.last;
        }
        obj.initFeed(null, null, null).endElem(out);
    }

    @Override
    public void watchRefresh(ObixEncoder out, Context cx) {
        Obj obj = new Obj().initFeed(null, "obix:AlarmFilter", "obix:Alarm");
        obj.setHref(this.href).write(out, true);
        out.commit();
        this.last = Clock.time();
        BOrd o = BOrd.make((String)BAlarmServiceAgent.queryRefresh(this.start, this.end, this.alarmClass));
        this.last = Clock.time();
        BITable results = (BITable)o.resolve((BObject)this.service).get();
        BAlarmServiceAgent.IterationResults res = BAlarmServiceAgent.iterateResults(this.limit, (BITable<BAlarmRecord>)results, obj, out, cx);
        if (res.last != null) {
            this.last = res.last;
        }
        obj.initFeed(null, null, null).endElem(out);
    }
}

