/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.naming;

import com.tridium.obix.naming.BIObixScheme;
import com.tridium.obix.naming.ObixQuery;
import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BAlarmServiceFeed;
import com.tridium.obix.server.BAlarmServiceQuery;
import com.tridium.obix.util.BadUriErr;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BObixAlarmScheme
extends BObject
implements BIObixScheme {
    public static final Type TYPE = Sys.loadType(BObixAlarmScheme.class);

    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        ObixQuery q = (ObixQuery)query;
        String s = q.nameAt(0);
        BObject o = base.get();
        if (o instanceof BAlarmService) {
            BAlarmService svc = (BAlarmService)o;
            if (s.equals("alarmFeed")) {
                return new ObixTarget(base, new BAlarmServiceFeed(svc));
            }
            if (s.equals("alarmQuery")) {
                return new ObixTarget(base, new BAlarmServiceQuery(svc));
            }
        }
        if (o instanceof BAlarmClass) {
            BAlarmClass ac = (BAlarmClass)o;
            if (s.equals("alarmFeed")) {
                return new ObixTarget(base, new BAlarmServiceFeed(ac));
            }
            if (s.equals("alarmQuery")) {
                return new ObixTarget(base, new BAlarmServiceQuery(ac));
            }
        }
        throw new BadUriErr();
    }
}

