/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.util;

import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BObixDiscoveryJob
extends BJob {
    public static final Action discover = BObixDiscoveryJob.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BObixDiscoveryJob.class);
    private boolean canceled = false;
    private BObixNetwork network;

    public void discover() {
        this.invoke(discover, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObixDiscoveryJob() {
    }

    public BObixDiscoveryJob(BObixNetwork network) {
        this.network = network;
    }

    public void addResult(String name, BValue result) {
        this.add(SlotPath.escape((String)name) + "?", result, 2);
    }

    public abstract void doDiscover();

    public void doCancel(Context cx) {
        this.canceled = true;
    }

    public void doRun(Context cx) {
        this.canceled = false;
        this.discover();
    }

    public BObixNetwork getNetwork() {
        return this.network;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == discover) {
            this.network.enqueue((Runnable)new Invocation((BComponent)this, discover, arg, cx));
            return null;
        }
        return super.post(action, arg, cx);
    }

    public void startJob() {
        this.setJobState(BJobState.running);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
    }
}

