/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.schedule;

import com.tridium.obix.driver.schedule.BObixScheduleDeviceExt;
import com.tridium.obix.driver.schedule.BObixScheduleDiscoveryResult;
import com.tridium.obix.driver.util.BObixDiscoveryJob;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;
import obix.Uri;

public class BObixScheduleDiscoveryJob
extends BObixDiscoveryJob {
    public static final Action fetch = BObixScheduleDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BObixScheduleDiscoveryJob.class);
    private static Uri lobby = new Uri("obix:Lobby");
    protected BValue args;
    protected BObixScheduleDeviceExt ext;

    public BObixScheduleDiscoveryResult fetch(BString arg) {
        return (BObixScheduleDiscoveryResult)this.invoke(fetch, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BObixScheduleDiscoveryJob() {
    }

    public BObixScheduleDiscoveryJob(BObixScheduleDeviceExt ext, BValue args) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.args = args;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixScheduleDiscoveryResult res = this.read(this.args.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixScheduleDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixScheduleDiscoveryResult getResult() {
        return (BObixScheduleDiscoveryResult)this.get("result");
    }

    protected BObixScheduleDiscoveryResult read(String href, Context cx) throws Exception {
        Obj obj = this.ext.getObixClient().obixRead(new Uri(href));
        return this.result(obj);
    }

    private BObixScheduleDiscoveryResult result(Obj obj) throws Exception {
        BObixClient client = this.ext.getObixClient();
        BObixScheduleDiscoveryResult res = new BObixScheduleDiscoveryResult();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(lobby)) {
            res.setObixName("lobby");
        }
        if (obj.getIs() != null) {
            res.setSchedule(obj.getIs().contains(this.ext.getScheduleContract()));
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        int count = 0;
        for (int i = 0; i < kids.length; ++i) {
            BObixScheduleDiscoveryResult hr;
            if (kids[i].isOp() || kids[i].isFeed()) continue;
            String name = kids[i].getName();
            if (name == null || name.equals("")) {
                name = kids[i].getDisplayName();
            }
            if (name == null || name.equals("")) {
                name = kids[i].getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kids[i].isRef()) {
                Uri uri = kids[i].getNormalizedHref();
                if (uri == null) continue;
                children.add(name, (BValue)BString.make((String)uri.get()));
                ++count;
                continue;
            }
            if (kids[i].getHref() == null || (hr = this.result(kids[i])) == null) continue;
            children.add(name, (BValue)hr);
            ++count;
        }
        if (count == 0 && !res.getSchedule()) {
            return null;
        }
        return res;
    }
}

