/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixForceUpdate;
import com.tridium.obix.driver.point.BObixPointDeviceExt;
import com.tridium.obix.driver.point.BObixPointFolder;
import com.tridium.obix.driver.point.BObixProxyAction;
import com.tridium.obix.driver.util.BIObixPollable;
import com.tridium.obix.driver.util.BObixSubscription;
import com.tridium.obix.driver.util.BObixTuningPolicy;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIRemoteAlarmSource;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import obix.Contract;
import obix.Err;
import obix.Int;
import obix.Obj;
import obix.Op;
import obix.Reltime;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ErrException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceFacets", type="BFacets", defaultValue="makeDeviceFacets()", override=true), @NiagaraProperty(name="href", type="String", defaultValue=""), @NiagaraProperty(name="subscription", type="BObixSubscription", defaultValue="BObixSubscription.unsubscribed", flags=67)})
@NiagaraActions(value={@NiagaraAction(name="forceUpdate"), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public class BObixProxyExt
extends BProxyExt
implements BIObixPollable,
BIRemoteAlarmSource {
    public static final Property deviceFacets = BObixProxyExt.newProperty((int)0, (BValue)BObixProxyExt.makeDeviceFacets(), null);
    public static final Property href = BObixProxyExt.newProperty((int)0, (String)"", null);
    public static final Property subscription = BObixProxyExt.newProperty((int)67, (BValue)BObixSubscription.unsubscribed, null);
    public static final Action forceUpdate = BObixProxyExt.newAction((int)0, null);
    public static final Action ackAlarm = BObixProxyExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BObixProxyExt.class);
    static Uri writablePoint = new Uri("obix:WritablePoint");
    private static final String R2CMD_MANUAL_SET = "manualSet";
    private static final String R2CMD_MANUAL_ACTIVE = "manualActive";
    private static final String R2CMD_MANUAL_INACTIVE = "manualInactive";
    private static final String R2CMD_MANUAL_AUTO = "manualAuto";
    private static final String R2CMD_OVERRIDE = "override";
    private static final String R2CMD_CANCEL = "cancel";
    private static final String R2CMD_SET_OVERRIDE_VALUE = "setOverrideValue";
    private BObixPointDeviceExt deviceExt = null;
    private BObixPointFolder folder = null;
    private boolean force = false;
    private boolean readSubscribed = false;
    private String subscribedHref = null;
    private boolean licenseChecked = false;
    private boolean fatalFault = false;
    private String fatalFaultCause = null;
    private Context context = null;

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String v) {
        this.setString(href, v, null);
    }

    public BObixSubscription getSubscription() {
        return (BObixSubscription)this.get(subscription);
    }

    public void setSubscription(BObixSubscription v) {
        this.set(subscription, (BValue)v, null);
    }

    public void forceUpdate() {
        this.invoke(forceUpdate, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled()) {
            this.getObixNetwork().enqueue(new Runnable(){

                @Override
                public void run() {
                    BObixProxyExt.this.checkObixLicense();
                }
            });
        }
        this.proxyAtSteadyState();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        this.context = cx;
        if (cx == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(href)) {
            if (this.subscribedHref != null && this.getSubscription().isSubscribed()) {
                this.getObixPointDeviceExt().unsubscribe(this.subscribedHref, this, cx);
            }
            if (this.isReadSubscribed()) {
                this.readSubscribed(cx);
            }
        } else if (prop.equals(enabled)) {
            if (!this.isDisabled()) {
                this.checkObixLicense();
            }
        } else if (prop.equals(tuningPolicyName)) {
            this.getObixPointDeviceExt().updateRefreshPeriod(this.getTuningPolicy().getStaleTime());
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord alarm) throws Exception {
        return this.getObixClient().getAlarms().doAckAlarm(alarm);
    }

    public void doForceUpdate() {
        this.force = true;
        this.read();
    }

    public Type getDeviceExtType() {
        return BObixPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParent() instanceof BIWritablePoint) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public BObixPointFolder getFolder() {
        if (this.folder == null) {
            for (BComplex cur = this.getParent(); cur != null; cur = cur.getParent()) {
                if (!(cur instanceof BObixPointFolder)) continue;
                this.folder = (BObixPointFolder)cur;
                break;
            }
        }
        return this.folder;
    }

    public Logger getLogger() {
        return this.getObixPointDeviceExt().getLogger();
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getDevice();
    }

    public BObixPointDeviceExt getObixPointDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BObixPointDeviceExt)this.getDeviceExt();
        }
        return this.deviceExt;
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public BPollFrequency getPollFrequency() {
        return ((BObixTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    public boolean isReadSubscribed() {
        return this.readSubscribed;
    }

    @Override
    public void poll() {
        if (this.getSubscription().isUnsubscribed()) {
            this.read();
        }
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void read() {
        this.getObixPointDeviceExt().read(this);
    }

    public void readSubscribed(Context cx) {
        this.context = cx;
        if (!this.licenseChecked) {
            this.checkObixLicense();
        }
        if (this.fatalFault) {
            this.readFail(this.fatalFaultCause);
            return;
        }
        this.readSubscribed = true;
        if (this.getSubscription().isSubscribed()) {
            return;
        }
        if (this.getHref().equals("")) {
            this.subscribeFail("Empty href");
        } else {
            this.setSubscription(BObixSubscription.pending);
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.readSubscribedCx);
        }
    }

    public void readUnsubscribed(Context cx) {
        this.readSubscribed = false;
        this.context = cx;
        if (!this.getSubscription().isUnsubscribed()) {
            this.getObixPointDeviceExt().unsubscribe(this.subscribedHref != null ? this.subscribedHref : this.getHref(), this, cx);
        } else {
            this.getObixClient().getPollScheduler().unsubscribe(this);
        }
        this.setSubscription(BObixSubscription.unsubscribed);
    }

    public void setStale(boolean stale, Context cx) {
        super.setStale(stale, cx);
        this.context = cx;
        if (Sys.atSteadyState() && stale && this.getObixClient().getStatus().isValid() && this.getSubscription().isSubscribed()) {
            if (this.getObixPointDeviceExt().getSubDebug()) {
                System.out.println("setting stale on " + this + " in " + (Object)((Object)this.getObixClient()) + "; resubscribing");
            }
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.staleCx);
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("ObixProxyExt");
        out.prop((Object)"deviceExt", (Object)this.deviceExt);
        out.prop((Object)"folder", (Object)this.folder);
        out.prop((Object)"force", this.force);
        out.prop((Object)"readSubscribed", this.readSubscribed);
        out.prop((Object)"subscribedHref", (Object)this.subscribedHref);
        out.prop((Object)"licenseChecked", this.licenseChecked);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)"fatalFaultCause", (Object)this.fatalFaultCause);
        out.endProps();
        super.spy(out);
    }

    public final void started() throws Exception {
        super.started();
        this.proxyStarted();
    }

    public void stopped() throws Exception {
        this.deviceExt = null;
        this.folder = null;
        super.stopped();
    }

    public String toString(Context cx) {
        return "ObixPxExt:" + this.getHref();
    }

    public boolean write(Context cx) {
        this.context = cx;
        if (!this.licenseChecked) {
            this.checkObixLicense();
        }
        if (this.fatalFault) {
            this.writeFail(this.fatalFaultCause);
            return false;
        }
        if (this.getHref().equals("")) {
            return false;
        }
        this.getObixPointDeviceExt().write(this, cx);
        return true;
    }

    protected void batchWrite(BatchIn bin) {
        block10: {
            BEnumRange range;
            BComplex parent = this.getParent();
            BFacets deviceFacet = this.getDeviceFacets();
            BEnumRange bEnumRange = range = deviceFacet == null ? null : (BEnumRange)deviceFacet.get("range");
            if (parent instanceof BEnumWritable && (range == null || range.isNull())) {
                String language = this.context == null ? "" : this.context.getLanguage();
                Lexicon lexicon = Lexicon.make((String)"obixDriver", (String)language);
                String errorMsg = lexicon == null ? "No Range defined" : lexicon.get("ErrorMsg.enumRange", "No Range defined");
                this.writeFail(errorMsg);
            } else {
                BStatusValue val = this.getWriteValue();
                Obj o = this.convert(val);
                o.setStatus(null);
                try {
                    if (this.getWriteOp() == null) {
                        if (!o.isNull()) {
                            bin.write(o);
                        } else {
                            this.writeReset();
                        }
                    } else {
                        Obj writePointIn = new Obj();
                        writePointIn.setIs(new Contract("obix:WritePointIn"));
                        writePointIn.add("value", o);
                        bin.invoke(new Uri(this.getWriteOp()), writePointIn);
                    }
                }
                catch (ErrException x) {
                    if (this.isRunning()) {
                        this.writeFail(this.getErrorString(x.err));
                    }
                }
                catch (Exception x) {
                    if (!this.isRunning()) break block10;
                    this.writeFail(x.toString());
                }
            }
        }
    }

    protected void batchWriteResult(Obj o) {
        if (o.isErr()) {
            this.writeFail(this.getErrorString((Err)o));
        } else {
            this.writeOk(this.convert(o));
        }
    }

    protected void force(Obj obj) {
        BFacets newFacets;
        Uri uri;
        if (!this.isRunning()) {
            return;
        }
        BControlPoint pt = (BControlPoint)this.getParent();
        if (pt == null) {
            return;
        }
        BObixClient client = this.getObixClient();
        if (client == null) {
            return;
        }
        Property[] props = pt.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue value = pt.get(props[i]);
            if (value instanceof BObixForceUpdate) {
                pt.remove(props[i]);
            }
            if (!(value instanceof BObixProxyAction)) continue;
            pt.remove(props[i]);
        }
        pt.add("forceUpdate?", (BValue)new BObixForceUpdate());
        Obj[] kids = obj.list();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isOp()) continue;
            Op op = (Op)kids[i];
            Uri href = this.getObixPointDeviceExt().getFullNormalizedHref(op, obj);
            if (href == null || !this.isSimple(op.getIn()) || !this.isSimple(op.getOut())) continue;
            Type in = this.getSimpleType(op.getIn().primary());
            Type out = this.getSimpleType(op.getOut().primary());
            href = client.getRelativeUri(href);
            BObixProxyAction a = new BObixProxyAction(href.get(), in, out);
            int flags = 0;
            String name = op.getName();
            if (name.equals(R2CMD_MANUAL_SET) || name.equals(R2CMD_MANUAL_ACTIVE) || name.equals(R2CMD_MANUAL_INACTIVE) || name.equals(R2CMD_MANUAL_AUTO) || name.equals(R2CMD_OVERRIDE) || name.equals(R2CMD_CANCEL) || name.equals(R2CMD_SET_OVERRIDE_VALUE)) {
                flags |= 0x100;
            }
            if ((name = op.toDisplayName()).equals("")) {
                flags |= 4;
                name = op.getName();
            }
            pt.add(name + "?", (BValue)a, flags);
        }
        String s = this.getDeviceFacets().gets("boolUri", null);
        if (s != null) {
            uri = new Uri(s);
            BFacets bool = client.makeBoolRange(uri);
            BFacets newFacets2 = BFacets.make((BFacets)this.getDeviceFacets(), (BFacets)bool);
            this.setDeviceFacets(newFacets2);
        }
        if ((s = this.getDeviceFacets().gets("enumUri", null)) != null) {
            uri = new Uri(s);
            newFacets = BFacets.make((BFacets)this.getDeviceFacets(), (String)"range", (BIDataValue)client.makeEnumRange(uri));
            this.setDeviceFacets(newFacets);
        }
        if ((s = this.getDeviceFacets().gets("unitsUri", null)) != null) {
            uri = new Uri(s);
            newFacets = BFacets.make((BFacets)this.getDeviceFacets(), (String)"units", (BIDataValue)client.makeUnits(uri));
            this.setDeviceFacets(newFacets);
        }
        if (this.getDeviceFacets().getb("uninitialized", false)) {
            BFacets f = BFacets.makeRemove((BFacets)this.getDeviceFacets(), (String)"uninitialized");
            this.setDeviceFacets(f);
            f = BFacets.makeRemove((BFacets)f, (String)"element");
            f = BFacets.makeRemove((BFacets)f, (String)"boolUri");
            f = BFacets.makeRemove((BFacets)f, (String)"enumUri");
            f = BFacets.makeRemove((BFacets)f, (String)"unitsUri");
            BFacets pointFacets = (BFacets)this.getParent().get("facets");
            pointFacets = BFacets.make((BFacets)pointFacets, (BFacets)f);
            this.getParent().set("facets", (BValue)pointFacets);
        }
        if (this.isReadSubscribed() && this.getSubscription().isUnsubscribed()) {
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.forceCx);
        }
    }

    protected void performWrite() throws Exception {
        block8: {
            BStatusValue val = this.getWriteValue();
            Obj o = this.convert(val);
            o.setStatus(null);
            try {
                if (this.getWriteOp() == null) {
                    if (!o.isNull()) {
                        o = this.getObixClient().obixWrite(o);
                    } else {
                        this.writeReset();
                    }
                } else {
                    o = this.getObixClient().obixInvoke(new Uri(this.getWriteOp()), o);
                }
                if (o.isErr()) {
                    this.writeFail(this.getErrorString((Err)o));
                } else {
                    this.writeOk(this.convert(o));
                    this.getLogger().fine("Write success (" + this.toPathString() + ") - " + val);
                }
            }
            catch (ErrException x) {
                if (!this.isRunning()) break block8;
                this.writeFail(this.getErrorString(x.err));
            }
        }
    }

    protected void proxyAtSteadyState() throws Exception {
    }

    protected void proxyStarted() throws Exception {
    }

    protected void readOk(Obj obj) {
        block8: {
            try {
                BFacets newFacets;
                if (this.fatalFault) {
                    this.readFail(this.fatalFaultCause);
                    return;
                }
                if (obj.isErr()) {
                    this.readFail(this.getErrorString((Err)obj));
                    return;
                }
                BFacets base = this.getDeviceFacets();
                if (!base.equals((Object)(newFacets = BObixProxyExt.makeFacets(base, obj, this.getObixClient())))) {
                    this.setDeviceFacets(newFacets);
                }
                if (this.force || this.getDeviceFacets().getb("uninitialized", false)) {
                    Obj forceObj = this.getObixPointDeviceExt().getForceObj(obj);
                    this.force = false;
                    this.force(forceObj);
                }
                BStatusValue v = this.convert(obj);
                this.readOk(v);
                if (!v.getStatus().isOk()) {
                    this.setFaultCause("Status reported by server.");
                } else {
                    this.setFaultCause("");
                }
            }
            catch (Exception x) {
                if (!this.isRunning()) break block8;
                this.getLogger().log(Level.SEVERE, "Receiving - " + obj.getHref(), x);
                this.readFail(x.toString());
            }
        }
    }

    protected void subscribeFail(String cause) {
        this.getLogger().fine(this.toPathString() + ": subscribe failure (" + cause + ")");
        this.setSubscription(BObixSubscription.unsubscribed);
        this.readFail(cause);
    }

    protected void subscribeFailTryPolling(String cause) {
        this.getLogger().fine(this.toPathString() + ": subscribe failure (" + cause + ")");
        this.setSubscription(BObixSubscription.unsubscribed);
        if (!this.getHref().equals("")) {
            this.getObixClient().getPollScheduler().subscribe(this);
        } else {
            this.readFail(cause);
        }
    }

    protected void subscribeOk() {
        this.subscribedHref = this.getHref();
        this.setSubscription(BObixSubscription.subscribed);
        this.getObixClient().getPollScheduler().unsubscribe(this);
    }

    static BFacets makeFacets(BFacets base, Obj obj, BObixClient client) throws Exception {
        Obj op;
        BFacets newFacets = client.makeFacets(base, obj);
        Hashtable<String, BString> t = new Hashtable<String, BString>();
        t.put("element", BString.make((String)obj.getElement()));
        if (obj.getIs() != null && obj.getIs().contains(writablePoint) && (op = obj.get("writePoint")) != null) {
            t.put("writeOp", BString.make((String)client.getRelativeUri(op.getNormalizedHref()).get()));
        }
        return BFacets.make((BFacets)newFacets, (BFacets)BFacets.make(t));
    }

    private void checkObixLicense() {
        String licenseFault;
        if (this.licenseChecked) {
            return;
        }
        Boolean isTridium = this.getObixClient().isTridiumServer();
        if (isTridium == null) {
            return;
        }
        if (!isTridium.booleanValue() && (licenseFault = this.getObixNetwork().checkObixLimit("foreignPoint.limit")) != null) {
            this.configFatal(licenseFault);
        }
        this.licenseChecked = true;
    }

    private BStatusValue convert(Obj obj) {
        return this.getObixClient().makeStatusValue(obj, this.getDeviceFacets());
    }

    private Obj convert(BStatusValue val) {
        Obj obj = this.getObixClient().makeObj((BValue)val, (Context)this.getDeviceFacets());
        String e = this.getElement();
        if (e.equals("int") && val instanceof BStatusNumeric) {
            BDouble v = (BDouble)val.getValueValue();
            Int oInt = new Int();
            oInt.set((long)((int)v.getDouble()));
            oInt.setNull(obj.isNull());
            obj = oInt;
        } else if (e.equals("reltime") && val instanceof BStatusNumeric) {
            Reltime oRel = new Reltime();
            BNumber num = (BNumber)val.getValueValue();
            BRelTime v = BRelTime.make((long)num.getLong());
            oRel.set(v.getMillis());
            oRel.setNull(obj.isNull());
            obj = oRel;
        } else if (e.equals("uri") && val instanceof BStatusString) {
            BStatusString ss = (BStatusString)val;
            Uri tmp = new Uri(ss.getValue());
            tmp.setNull(obj.isNull());
            obj = tmp;
        }
        obj.setHref(new Uri(this.getHref()));
        return obj;
    }

    private String getElement() {
        return this.getDeviceFacets().gets("element", "obj");
    }

    private String getErrorString(Err err) {
        String ret = err.getDisplay();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return ObixEncoder.toString((Obj)err);
    }

    private Type getSimpleType(Uri uri) {
        if (uri == null) {
            return null;
        }
        String s = uri.get();
        if (!s.startsWith("obix:")) {
            return null;
        }
        if (s.equals("obix:abstime")) {
            return BAbsTime.TYPE;
        }
        if (s.equals("obix:bool")) {
            return BBoolean.TYPE;
        }
        if (s.equals("obix:enum")) {
            return BIEnum.TYPE;
        }
        if (s.equals("obix:int")) {
            return BInteger.TYPE;
        }
        if (s.equals("obix:real")) {
            return BDouble.TYPE;
        }
        if (s.equals("obix:reltime")) {
            return BRelTime.TYPE;
        }
        if (s.equals("obix:str")) {
            return BString.TYPE;
        }
        return null;
    }

    private String getWriteOp() {
        return this.getDeviceFacets().gets("writeOp", null);
    }

    private boolean isSimple(Contract c) {
        if (c == null) {
            return true;
        }
        Uri uri = c.primary();
        if (uri == null) {
            return true;
        }
        if (uri.get().equals("obix:Nil")) {
            return true;
        }
        if (uri.get().equals("obix:obj") && c.size() == 1) {
            return true;
        }
        return this.getSimpleType(uri) != null;
    }

    private static BFacets makeDeviceFacets() {
        return BFacets.make((BFacets)BFacets.NULL, (String)"uninitialized", (BIDataValue)BBoolean.TRUE);
    }
}

