/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.obix.driver.BObixClient;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import obix.Obj;
import obix.Uri;

public class BObixProxyAction
extends BAction {
    public static final Property href = BObixProxyAction.newProperty((int)0, (String)"", null);
    public static final Property inTypeSpec = BObixProxyAction.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    public static final Property outTypeSpec = BObixProxyAction.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    public static final Type TYPE = Sys.loadType(BObixProxyAction.class);

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String v) {
        this.setString(href, v, null);
    }

    public BTypeSpec getInTypeSpec() {
        return (BTypeSpec)this.get(inTypeSpec);
    }

    public void setInTypeSpec(BTypeSpec v) {
        this.set(inTypeSpec, (BValue)v, null);
    }

    public BTypeSpec getOutTypeSpec() {
        return (BTypeSpec)this.get(outTypeSpec);
    }

    public void setOutTypeSpec(BTypeSpec v) {
        this.set(outTypeSpec, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObixProxyAction() {
    }

    public BObixProxyAction(String href, Type in, Type out) {
        this.setHref(href);
        if (in != null) {
            this.setInTypeSpec(in.getTypeSpec());
        }
        if (out != null) {
            this.setOutTypeSpec(out.getTypeSpec());
        }
    }

    public BValue getParameterDefault() {
        Type paramType = this.getParameterType();
        if (paramType == null) {
            return null;
        }
        if (paramType.is(BIEnum.TYPE)) {
            BControlPoint pt = (BControlPoint)this.getParent();
            BStatusValue sv = (BStatusValue)pt.get(pt.getOutProperty());
            if (sv instanceof BStatusEnum) {
                return sv.getValueValue();
            }
            BObixProxyExt ext = this.ext();
            BFacets f = ext.getDeviceFacets();
            BEnumRange range = (BEnumRange)f.get("range");
            if (range != null) {
                int[] ords = range.getOrdinals();
                return range.get(ords[0]);
            }
        }
        return (BValue)paramType.getInstance();
    }

    public Type getParameterType() {
        BTypeSpec typeSpec = this.getInTypeSpec();
        if (typeSpec.isNull()) {
            return null;
        }
        return typeSpec.getResolvedType();
    }

    public Type getReturnType() {
        BTypeSpec typeSpec = this.getOutTypeSpec();
        if (typeSpec.isNull()) {
            return null;
        }
        return typeSpec.getResolvedType();
    }

    public BValue invoke(BComponent target, BValue arg) throws Exception {
        BObixProxyExt ext = this.ext();
        if (ext == null) {
            return null;
        }
        BObixClient oc = ext.getObixClient();
        Obj o = oc.obixInvoke(new Uri(this.getHref()), oc.makeObj(arg, (Context)ext.getDeviceFacets()));
        return oc.makeSimple(o, (Context)ext.getDeviceFacets());
    }

    private BObixProxyExt ext() {
        BControlPoint pt;
        BAbstractProxyExt ext;
        BComplex parent = this.getParent();
        if (parent instanceof BControlPoint && (ext = (pt = (BControlPoint)parent).getProxyExt()) instanceof BObixProxyExt) {
            return (BObixProxyExt)ext;
        }
        return null;
    }
}

