/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixPointDeviceExt;
import com.tridium.obix.driver.point.BObixPointDiscoveryResult;
import com.tridium.obix.driver.point.BObixProxyExt;
import com.tridium.obix.driver.util.BObixDiscoveryJob;
import java.util.Arrays;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import obix.Bool;
import obix.Contract;
import obix.Enum;
import obix.Int;
import obix.Obj;
import obix.Real;
import obix.Reltime;
import obix.Uri;
import obix.Val;

@NiagaraType
@NiagaraAction(name="fetch", parameterType="baja:String", defaultValue="BString.make(\"\")", returnType="obixDriver:ObixPointDiscoveryResult")
public class BObixPointDiscoveryJob
extends BObixDiscoveryJob {
    public static final Action fetch = BObixPointDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BObixPointDiscoveryJob.class);
    private static final Uri lobby = new Uri("obix:Lobby");
    protected BValue uri;
    protected BObixPointDeviceExt ext;

    public BObixPointDiscoveryResult fetch(BString parameter) {
        return (BObixPointDiscoveryResult)this.invoke(fetch, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BObixPointDiscoveryJob() {
    }

    public BObixPointDiscoveryJob(BObixPointDeviceExt ext, BValue uri) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.uri = uri;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixPointDiscoveryResult res = this.read(this.uri.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixPointDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixPointDiscoveryResult getResult() {
        return (BObixPointDiscoveryResult)this.get("result");
    }

    protected boolean checkAddRef(Obj ref) {
        return ref.getNormalizedHref() != null;
    }

    protected boolean checkAddResult(BObixPointDiscoveryResult pr, Obj res) {
        return pr != null;
    }

    protected BObixPointDiscoveryResult read(String href, Context cx) throws Exception {
        Obj obj = this.ext.getObixClient().obixRead(new Uri(href));
        return this.result(obj);
    }

    private static Uri normalize(Obj obj, Uri uri) {
        if (uri == null || uri.get().isEmpty()) {
            return null;
        }
        if (obj == null) {
            return uri;
        }
        Uri base = obj.getRoot().getHref();
        if (base == null || base.get().isEmpty()) {
            return uri;
        }
        return uri.normalize(base);
    }

    private BObixPointDiscoveryResult result(Obj obj) throws Exception {
        BObixPointDiscoveryResult res = new BObixPointDiscoveryResult();
        BObixClient client = this.ext.getObixClient();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(lobby)) {
            res.setObixName("lobby");
        }
        BFacets facets = BFacets.DEFAULT;
        if (obj.isVal()) {
            if (obj.isBool()) {
                facets = BFacets.makeBoolean();
                Bool oBool = (Bool)obj;
                res.setValue((BValue)BBoolean.make((boolean)oBool.get()));
            } else if (obj.isReal()) {
                facets = BFacets.makeNumeric();
                Real oReal = (Real)obj;
                res.setValue((BValue)BDouble.make((double)oReal.get()));
            } else if (obj.isInt()) {
                facets = BFacets.makeInt();
                Int oInt = (Int)obj;
                res.setValue((BValue)BDouble.make((double)oInt.get()));
            } else if (obj.isEnum()) {
                facets = BFacets.makeEnum();
                Enum oEnum = (Enum)obj;
                Uri range = BObixPointDiscoveryJob.normalize((Obj)oEnum, oEnum.getRange());
                String enumTagRaw = oEnum.get();
                if (range == null) {
                    BEnumRange noRange = BEnumRange.make((int[])new int[]{-1}, (String[])new String[]{SlotPath.escape((String)enumTagRaw)});
                    res.setValue((BValue)BDynamicEnum.make((int)-1, (BEnumRange)noRange));
                } else {
                    String enumTag;
                    BEnumRange er = client.makeEnumRange(range);
                    if (er.isTag(enumTag = SlotPath.escape((String)enumTagRaw))) {
                        res.setValue((BValue)er.get(enumTag));
                    } else {
                        try {
                            int i = Integer.parseInt(enumTagRaw);
                            res.setValue((BValue)BDynamicEnum.make((int)i, (BEnumRange)er));
                        }
                        catch (NumberFormatException e) {
                            int outOfRangeVal;
                            int[] rawOrds = er.getOrdinals();
                            int[] fixOrds = new int[rawOrds.length + 1];
                            System.arraycopy(rawOrds, 0, fixOrds, 0, rawOrds.length);
                            Arrays.sort(rawOrds);
                            fixOrds[fixOrds.length - 1] = outOfRangeVal = rawOrds[rawOrds.length - 1] + 1;
                            String[] fixTags = new String[fixOrds.length];
                            for (int i = 0; i < fixOrds.length - 1; ++i) {
                                fixTags[i] = er.getTag(fixOrds[i]);
                            }
                            fixTags[fixOrds.length - 1] = enumTag;
                            BEnumRange fixEr = BEnumRange.make((int[])fixOrds, (String[])fixTags);
                            res.setValue((BValue)BDynamicEnum.make((int)outOfRangeVal, (BEnumRange)fixEr));
                        }
                    }
                    facets = BFacets.make((BFacets)facets, (String)"range", (BIDataValue)er);
                }
            } else if (obj.isReltime()) {
                facets = BFacets.makeNumeric();
                Reltime oRel = (Reltime)obj;
                res.setValue((BValue)BDouble.make((double)oRel.get()));
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"));
            } else {
                Val oVal = (Val)obj;
                res.setValue((BValue)BString.make((String)oVal.encodeVal()));
            }
            if (obj.isWritable()) {
                res.setMode(BReadWriteMode.readWrite);
            } else {
                res.setMode(BReadWriteMode.readonly);
            }
        }
        if (obj.getIs() != null) {
            res.setIs(obj.getIs().toString());
        }
        facets = BObixProxyExt.makeFacets(facets, obj, client);
        res.setFacets(facets);
        if (obj.isWritable()) {
            res.setMode(BReadWriteMode.readWrite);
        } else if (facets.gets("writeOp", null) != null) {
            res.setMode(BReadWriteMode.readWrite);
        } else {
            res.setMode(BReadWriteMode.readonly);
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        for (Obj kid : kids) {
            BObixPointDiscoveryResult pr;
            if (kid.isOp() || kid.isFeed()) continue;
            String name = kid.getName();
            if (name == null || name.isEmpty()) {
                name = kid.getDisplayName();
            }
            if (name == null || name.isEmpty()) {
                Contract c = kid.getIs();
                name = c != null && c.contains(lobby) ? "lobby" : kid.getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kid.isRef()) {
                if (!this.checkAddRef(kid)) continue;
                children.add(name, (BValue)BString.make((String)kid.getNormalizedHref().get()));
                continue;
            }
            if (kid.getHref() == null || !this.checkAddResult(pr = this.result(kid), kid)) continue;
            children.add(name, (BValue)pr);
        }
        return res;
    }
}

