/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.history;

import com.tridium.obix.driver.history.BObixHistoryDeviceExt;
import com.tridium.obix.driver.history.BObixHistoryDiscoveryResult;
import com.tridium.obix.driver.util.BObixDiscoveryJob;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;
import obix.Uri;

public class BObixHistoryDiscoveryJob
extends BObixDiscoveryJob {
    public static final Action fetch = BObixHistoryDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BObixHistoryDiscoveryJob.class);
    private static Uri lobby = new Uri("obix:Lobby");
    private static Uri historyQuery = new Uri("obix:History");
    protected BValue args;
    protected BObixHistoryDeviceExt ext;

    public BObixHistoryDiscoveryResult fetch(BString arg) {
        return (BObixHistoryDiscoveryResult)this.invoke(fetch, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BObixHistoryDiscoveryJob() {
    }

    public BObixHistoryDiscoveryJob(BObixHistoryDeviceExt ext, BValue args) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.args = args;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixHistoryDiscoveryResult res = this.read(this.args.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixHistoryDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixHistoryDiscoveryResult getResult() {
        return (BObixHistoryDiscoveryResult)this.get("result");
    }

    protected BObixHistoryDiscoveryResult read(String href, Context cx) throws Exception {
        Obj obj = this.ext.getObixClient().obixRead(new Uri(href));
        return this.result(obj);
    }

    private BObixHistoryDiscoveryResult result(Obj obj) throws Exception {
        BObixClient client = this.ext.getObixClient();
        boolean isQuery = false;
        BObixHistoryDiscoveryResult res = new BObixHistoryDiscoveryResult();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(lobby)) {
            res.setObixName("lobby");
        }
        if (obj.getIs() != null && obj.getIs().contains(historyQuery)) {
            Obj tmp = obj.get("query");
            if (tmp != null && tmp.getHref() != null) {
                res.setQuery(client.getRelativeUri(tmp.getNormalizedHref()).get());
                isQuery = true;
            }
            if ((tmp = obj.get("start")) != null && !tmp.isNull()) {
                res.setStart(tmp.toDisplayString());
            }
            if ((tmp = obj.get("end")) != null && !tmp.isNull()) {
                res.setEnd(tmp.toDisplayString());
            }
            if ((tmp = obj.get("count")) != null && !tmp.isNull()) {
                res.setCount(tmp.toDisplayString());
            }
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        int count = 0;
        for (int i = 0; i < kids.length; ++i) {
            BObixHistoryDiscoveryResult hr;
            if (kids[i].isOp() || kids[i].isFeed()) continue;
            String name = kids[i].getName();
            if (name == null || name.equals("")) {
                name = kids[i].getDisplayName();
            }
            if (name == null || name.equals("")) {
                name = kids[i].getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kids[i].isRef()) {
                Uri uri = kids[i].getNormalizedHref();
                if (uri == null) continue;
                children.add(name, (BValue)BString.make((String)uri.get()));
                ++count;
                continue;
            }
            if (kids[i].getHref() == null || (hr = this.result(kids[i])) == null) continue;
            children.add(name, (BValue)hr);
            ++count;
        }
        if (count == 0 && !isQuery) {
            return null;
        }
        return res;
    }
}

