/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.alarm;

import com.tridium.obix.driver.alarm.BObixAlarmDeviceExt;
import com.tridium.obix.driver.util.BObixSubscription;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Abstime;
import obix.Contract;
import obix.Obj;
import obix.Str;
import obix.Uri;
import obix.Val;

public class BObixAlarmImport
extends BComponent
implements BIStatus,
BIAlarmSource {
    public static final Property alarmClass = BObixAlarmImport.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Property href = BObixAlarmImport.newProperty((int)0, (String)"", null);
    public static final Property lastReceivedTime = BObixAlarmImport.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property subscription = BObixAlarmImport.newProperty((int)67, (BValue)BObixSubscription.unsubscribed, null);
    public static final Property status = BObixAlarmImport.newProperty((int)1, (BValue)BStatus.down, null);
    public static final Property faultCause = BObixAlarmImport.newProperty((int)3, (String)"", null);
    public static final Action ackAlarm = BObixAlarmImport.newAction((int)0, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BObixAlarmImport.class);
    static Uri ACK_ALARM = new Uri("obix:AckAlarm");
    static Uri STATEFUL_ALARM = new Uri("obix:StatefulAlarm");
    private BObixAlarmDeviceExt deviceExt = null;
    private static BAlarmService service = null;
    private BOrdList source = null;
    protected String subscribedHref = null;

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String v) {
        this.setString(href, v, null);
    }

    public BAbsTime getLastReceivedTime() {
        return (BAbsTime)this.get(lastReceivedTime);
    }

    public void setLastReceivedTime(BAbsTime v) {
        this.set(lastReceivedTime, (BValue)v, null);
    }

    public BObixSubscription getSubscription() {
        return (BObixSubscription)this.get(subscription);
    }

    public void setSubscription(BObixSubscription v) {
        this.set(subscription, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord arg) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && cx != Context.decoding && p == href) {
            this.getLogger().fine("Alarm subject href changed - " + this.toPathString());
            this.getObixAlarmDeviceExt().unsubscribe(this.subscribedHref, this, cx);
            this.getObixAlarmDeviceExt().subscribe(this.getHref(), this, cx);
        }
        super.changed(p, cx);
    }

    public BBoolean doAckAlarm(BAlarmRecord alarm) {
        try {
            this.getLogger().fine("AckAlarm (" + this.getHref() + ") " + alarm.toSummaryString());
            BString ackRef = (BString)alarm.getAlarmFacet("ackHref");
            if (ackRef == null) {
                this.getLogger().severe("No href for alarm: " + alarm.toSummaryString());
                return BBoolean.FALSE;
            }
            Uri op = new Uri(ackRef.getString());
            Obj arg = new Obj();
            arg.setIs(new Contract("obix:AlarmAckIn"));
            Str user = new Str();
            user.setName("ackUser");
            user.setStr(alarm.getUser());
            if (alarm.getAlarmFacet("forceCleared") != null) {
                this.getLogger().fine("Attempt to force clear alarm on server");
                Str force = new Str();
                force.setName("forceCleared");
                force.setStr(this.getObixClient().getAuthUser());
                user.setStr(this.getObixClient().getAuthUser());
                arg.add((Obj)force);
            }
            arg.add((Obj)user);
            Obj alarmOut = this.getObixClient().obixInvoke(op, arg);
            if (alarmOut == null) {
                this.getLogger().severe("Empty response for ack: " + alarm.toSummaryString());
                return BBoolean.FALSE;
            }
            if (alarmOut.isErr()) {
                this.getLogger().severe(alarmOut.toDisplayString());
                alarm.setAckState(BAckState.unacked);
            } else {
                Obj res = alarmOut.get("alarm");
                if (res == null) {
                    this.getLogger().severe("Empty response for ack: " + alarm.toSummaryString());
                    alarm.setAckState(BAckState.unacked);
                } else {
                    this.updateAlarm(alarm, res);
                }
            }
        }
        catch (Exception x) {
            this.getLogger().log(Level.SEVERE, "AckAlarm (" + this.getHref() + ")", x);
            alarm.setAckState(BAckState.unacked);
        }
        this.route(alarm);
        return BBoolean.make((alarm.getAckState() == BAckState.acked ? 1 : 0) != 0);
    }

    public Type getDeviceExtType() {
        return BObixAlarmDeviceExt.TYPE;
    }

    public Logger getLogger() {
        return this.getObixAlarmDeviceExt().getLogger();
    }

    public BObixClient getObixClient() {
        return this.getObixAlarmDeviceExt().getObixClient();
    }

    public BObixAlarmDeviceExt getObixAlarmDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BObixAlarmDeviceExt)) continue;
            this.deviceExt = (BObixAlarmDeviceExt)p;
            return this.deviceExt;
        }
        throw new IllegalStateException();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void started() throws Exception {
        this.source = null;
        BObixAlarmDeviceExt ext = this.getObixAlarmDeviceExt();
        if (ext.isAttached()) {
            ext.subscribe(this.getHref(), this, null);
        }
    }

    public void stopped() throws Exception {
        if (this.getSubscription().isSubscribed()) {
            this.getObixAlarmDeviceExt().unsubscribe(this.subscribedHref, this, null);
        }
        this.deviceExt = null;
        super.stopped();
    }

    protected BOrdList asSource() {
        if (this.source == null) {
            this.source = BOrdList.make((BOrd)this.getSlotPathOrd());
        }
        return this.source;
    }

    protected BAlarmRecord getExistingRecord(String href) throws Exception {
        BOrd o = BOrd.make((String)("alarm:|bql:select * where alarmData.href = '" + href + "'"));
        BITable res = (BITable)o.resolve((BObject)Sys.getStation()).get();
        TableCursor c = res.cursor();
        if (c.next()) {
            return (BAlarmRecord)c.get();
        }
        return null;
    }

    protected BOrdList makeSource(BComponent c) {
        return BOrdList.make((BOrd)c.getSlotPathOrd());
    }

    protected void processFeed(Obj feed) {
        this.setLastReceivedTime(Clock.time());
        BObixClient client = this.getObixClient();
        Obj[] alarms = feed.list();
        try {
            int len = alarms.length;
            Obj alarm = null;
            for (int i = 0; i < len; ++i) {
                String sourceStation;
                alarm = alarms[i];
                BAlarmRecord incoming = this.makeAlarm(alarm);
                String href = client.getRelativeUri(alarm.getHref()).get();
                BAlarmRecord existing = this.getExistingRecord(href);
                BString bSrcStation = (BString)incoming.getAlarmFacet("sourceStation");
                if (bSrcStation != null && (sourceStation = bSrcStation.getString()).equals(Sys.getStation().getStationName())) {
                    this.getLogger().fine("Duplicate alarm: skipping alarm processing for alarm " + alarm.toString());
                    continue;
                }
                if (existing == null) {
                    this.getLogger().fine("Alarm received - " + alarm.toString());
                    this.route(incoming);
                    continue;
                }
                if (this.equivalent(existing, incoming) || !this.shouldRoute(existing, incoming)) continue;
                existing = (BAlarmRecord)existing.newCopy(true);
                this.getLogger().fine("Alarm being updated - " + alarm.toString());
                this.route(this.updateAlarm(existing, incoming));
            }
        }
        catch (Exception x) {
            this.getLogger().log(Level.SEVERE, "Receiving alarm event", x);
        }
    }

    protected void setSource(BAlarmRecord rec, Obj obj) throws Exception {
        rec.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)(this.getObixClient().getName() + "-" + this.getName())));
        rec.setSource(this.asSource());
    }

    protected boolean shouldRoute(BAlarmRecord existing, BAlarmRecord incoming) {
        return true;
    }

    protected void subscribeFail(String cause) {
        this.getLogger().severe("Subscribe failure (" + cause + ") " + this.toPathString());
        this.setSubscription(BObixSubscription.unsubscribed);
        this.setStatus(BStatus.fault);
        this.setFaultCause(cause);
    }

    protected void subscribeOk(Obj watchOut) {
        try {
            BAlarmRecord remoteRec;
            this.subscribedHref = this.getHref();
            this.getLogger().fine("Subscribe success - " + this.getHref());
            Map<String, BAlarmRecord> existing = this.getOpenAlarms();
            this.getLogger().fine("Existing record count = " + existing.size());
            Map<String, BAlarmRecord> incoming = this.getAlarms(watchOut);
            this.getLogger().fine("Incoming record count = " + incoming.size());
            Iterator<String> i = existing.keySet().iterator();
            int closed = 0;
            int updated = 0;
            while (i.hasNext()) {
                String key = i.next();
                BAlarmRecord existingRec = existing.get(key);
                remoteRec = incoming.get(key);
                if (remoteRec == null) {
                    ++closed;
                    this.close(existingRec);
                    continue;
                }
                if (this.equivalent(existingRec, remoteRec)) continue;
                ++updated;
                this.route(this.updateAlarm(existingRec, remoteRec));
            }
            i = incoming.keySet().iterator();
            int newRecords = 0;
            while (i.hasNext()) {
                String key = i.next();
                if (existing.get(key) != null || !(remoteRec = incoming.get(key)).isOpen()) continue;
                this.route(remoteRec);
                ++newRecords;
            }
            this.getLogger().fine("Existing records closed = " + closed);
            this.getLogger().fine("Existing records updated = " + updated);
            this.getLogger().fine("New open records = " + newRecords);
            this.setSubscription(BObixSubscription.subscribed);
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        catch (Exception x) {
            this.getLogger().log(Level.SEVERE, "Failure creating subscription", x);
            this.subscribeFail(x.toString());
            this.getObixAlarmDeviceExt().unsubscribe(this.subscribedHref, this, null);
        }
    }

    protected void unsubscribe() {
        this.setSubscription(BObixSubscription.unsubscribed);
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
        if (this.isRunning()) {
            this.getLogger().fine("Unsubscribed - " + this.getHref());
        }
    }

    private void close(BAlarmRecord rec) {
        rec.setAckState(BAckState.acked);
        rec.setAckTime(Clock.time());
        rec.setSourceState(BSourceState.normal);
        this.route(rec);
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private boolean equivalent(BAlarmRecord local, BAlarmRecord remote) {
        if (!local.getTimestamp().equals((Object)remote.getTimestamp())) {
            return false;
        }
        if (local.getAckRequired() != remote.getAckRequired()) {
            return false;
        }
        if (!local.getSourceState().equals((Object)remote.getSourceState())) {
            return false;
        }
        if (!local.getNormalTime().equals((Object)remote.getNormalTime())) {
            return false;
        }
        if (!local.getAckTime().equals((Object)remote.getAckTime())) {
            return false;
        }
        if (!this.equal(local.getUser(), remote.getUser())) {
            return false;
        }
        BFacets tmp = BFacets.make((BFacets)local.getAlarmData(), (BFacets)remote.getAlarmData());
        return local.getAlarmData().equals((Object)tmp);
    }

    private Map<String, BAlarmRecord> getAlarms(Obj feed) {
        TreeMap<String, BAlarmRecord> ret = new TreeMap<String, BAlarmRecord>();
        Obj[] alarms = feed.list();
        int i = alarms.length;
        while (--i >= 0) {
            BAlarmRecord rec = this.makeAlarm(alarms[i]);
            ret.put(this.getHref(rec), rec);
        }
        return ret;
    }

    private String getHref(BAlarmRecord rec) {
        BString ret = (BString)rec.getAlarmFacet("href");
        if (ret != null) {
            return ret.getString();
        }
        return null;
    }

    private Map<String, BAlarmRecord> getOpenAlarms() throws Exception {
        TreeMap<String, BAlarmRecord> ret = new TreeMap<String, BAlarmRecord>();
        try (AlarmDbConnection conn = this.svc().getAlarmDb().getDbConnection(null);
             Cursor c = conn.getAlarmsForSource(this.asSource());){
            BAlarmRecord rec = null;
            while (c.next()) {
                rec = (BAlarmRecord)c.get();
                if (!rec.isOpen()) continue;
                ret.put(this.getHref(rec), (BAlarmRecord)rec.newCopy(true));
            }
        }
        return ret;
    }

    private String getVal(Obj obj) {
        if (obj.isVal()) {
            return ((Val)obj).encodeVal();
        }
        if (obj.isRef()) {
            return obj.toString();
        }
        return obj.toDisplayString();
    }

    private BAlarmRecord makeAlarm(Obj obj) {
        BAlarmRecord ret = new BAlarmRecord(BUuid.make());
        return this.updateAlarm(ret, obj);
    }

    private void route(BAlarmRecord alarm) {
        if (alarm == null) {
            return;
        }
        this.svc().routeAlarm(alarm);
    }

    private BAlarmService svc() {
        if (service != null && service.isRunning()) {
            return service;
        }
        try {
            service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            this.getLogger().log(Level.SEVERE, "Cannot find AlarmService", e);
        }
        return service;
    }

    private BAlarmRecord updateAlarm(BAlarmRecord local, BAlarmRecord remote) {
        if (local.getAckRequired() != remote.getAckRequired()) {
            local.setAckRequired(remote.getAckRequired());
        }
        if (!local.getAckTime().equals((Object)remote.getAckTime())) {
            local.setAckTime(remote.getAckTime());
        }
        if (!local.getAckState().equals((Object)remote.getAckState())) {
            local.setAckState(remote.getAckState());
        }
        if (!local.getNormalTime().equals((Object)remote.getNormalTime())) {
            local.setNormalTime(remote.getNormalTime());
        }
        if (!local.getSourceState().equals((Object)remote.getSourceState())) {
            local.setSourceState(remote.getSourceState());
        }
        if (!local.getTimestamp().equals((Object)remote.getTimestamp())) {
            local.setTimestamp(remote.getTimestamp());
        }
        if (!this.equal(local.getUser(), remote.getUser())) {
            local.setUser(remote.getUser());
        }
        local.setAlarmData(BFacets.make((BFacets)local.getAlarmData(), (BFacets)remote.getAlarmData()));
        return local;
    }

    private BAlarmRecord updateAlarm(BAlarmRecord rec, Obj obj) {
        BObixClient clnt = this.getObixClient();
        rec.addAlarmFacet("href", (BIDataValue)BString.make((String)clnt.getRelativeUri(obj.getHref()).get()));
        try {
            this.setSource(rec, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (obj.getDisplay() != null) {
            rec.addAlarmFacet("msgText", (BIDataValue)BString.make((String)obj.getDisplay()));
        }
        rec.setAlarmClass(this.getAlarmClass());
        if (obj.is(ACK_ALARM)) {
            rec.setAckRequired(true);
            rec.setAckState(BAckState.unacked);
        } else {
            rec.setAckRequired(false);
        }
        if (obj.is(STATEFUL_ALARM)) {
            if (obj.get("forceCleared") != null) {
                rec.setSourceState(BSourceState.normal);
            } else if ("fault".equals(Objects.toString(obj.get("toState")))) {
                rec.setSourceState(BSourceState.fault);
            } else {
                rec.setSourceState(BSourceState.offnormal);
            }
        } else {
            rec.setSourceState(BSourceState.normal);
        }
        rec.addAlarmFacet("feedName", (BIDataValue)BString.make((String)this.getName()));
        Obj[] kids = obj.list();
        int i = kids.length;
        while (--i >= 0) {
            String name = kids[i].getName();
            if (kids[i].isNull()) continue;
            if (name.equals("timestamp")) {
                if (kids[i].isAbstime()) {
                    long millis = ((Abstime)kids[i]).getMillis();
                    rec.setTimestamp(BAbsTime.make((long)millis));
                    continue;
                }
                rec.addAlarmFacet("timestamp", (BIDataValue)BString.make((String)this.getVal(kids[i])));
                continue;
            }
            if (name.equals("normalTimestamp")) {
                if (kids[i].isAbstime()) {
                    long millis = ((Abstime)kids[i]).getMillis();
                    rec.setNormalTime(BAbsTime.make((long)millis));
                    rec.setSourceState(BSourceState.normal);
                    continue;
                }
                rec.addAlarmFacet("normalTimestamp", (BIDataValue)BString.make((String)this.getVal(kids[i])));
                continue;
            }
            if (name.equals("ackTimestamp")) {
                if (kids[i].isAbstime()) {
                    long millis = ((Abstime)kids[i]).getMillis();
                    if (millis <= 0L) continue;
                    rec.setAckTime(BAbsTime.make((long)millis));
                    rec.setAckState(BAckState.acked);
                    continue;
                }
                rec.addAlarmFacet("ackTimestamp", (BIDataValue)BString.make((String)this.getVal(kids[i])));
                continue;
            }
            if (name.equals("ackUser")) {
                rec.setUser(this.getVal(kids[i]));
                continue;
            }
            if (name.equals("ack")) {
                rec.addAlarmFacet("ackHref", (BIDataValue)BString.make((String)clnt.getRelativeUri(kids[i].getHref()).get()));
                continue;
            }
            if (name.equals("niagara-uuid") && kids[i].isStr()) {
                rec.setUuid(BUuid.make((String)((Str)kids[i]).getStr()));
                continue;
            }
            if (name.equals("notificationClass")) {
                String acName = this.getVal(kids[i]);
                BAlarmClass ac = this.svc().lookupAlarmClass(acName);
                if (ac.getName().equals("defaultAlarmClass") && !acName.equals("defaultAlarmClass")) continue;
                rec.setAlarmClass(acName);
                continue;
            }
            rec.addAlarmFacet(SlotPath.escape((String)name), (BIDataValue)BString.make((String)this.getVal(kids[i])));
        }
        return rec;
    }
}

