/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;

public class BReportPane
extends BPane {
    public static final Property logo = BReportPane.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property pageNumber = BReportPane.newProperty((int)0, (boolean)true, null);
    public static final Property timestamp = BReportPane.newProperty((int)0, (boolean)true, null);
    public static final Property scrollBar = BReportPane.newProperty((int)7, (BValue)new BNullWidget(), null);
    public static final Property rowGap = BReportPane.newProperty((int)0, (int)0, null);
    public static final Action vscroll = BReportPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Type TYPE = Sys.loadType(BReportPane.class);
    static Lexicon lex = Lexicon.make((String)"report");
    private Point logoPos = new Point();
    private Point pageNumPos = new Point();
    private Point tstampPos = new Point();
    private BAbsTime tstamp = BAbsTime.now();
    private double yoff = 0.0;

    public BImage getLogo() {
        return (BImage)this.get(logo);
    }

    public void setLogo(BImage v) {
        this.set(logo, (BValue)v, null);
    }

    public boolean getPageNumber() {
        return this.getBoolean(pageNumber);
    }

    public void setPageNumber(boolean v) {
        this.setBoolean(pageNumber, v, null);
    }

    public boolean getTimestamp() {
        return this.getBoolean(timestamp);
    }

    public void setTimestamp(boolean v) {
        this.setBoolean(timestamp, v, null);
    }

    public BWidget getScrollBar() {
        return (BWidget)this.get(scrollBar);
    }

    public void setScrollBar(BWidget v) {
        this.set(scrollBar, (BValue)v, null);
    }

    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    public void vscroll(BScrollEvent event) {
        this.invoke(vscroll, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReportPane() {
        BScrollBar sb = new BScrollBar();
        this.linkTo((BComponent)sb, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
        this.setScrollBar((BWidget)sb);
    }

    public void computePreferredSize() {
        double pw = 100.0;
        double ph = this.getChromeHeight();
        double rg = this.getRowGap();
        BWidget[] kids = this.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            kids[i].computePreferredSize();
            pw = Math.max(pw, kids[i].getPreferredHeight());
            ph += kids[i].getPreferredHeight();
            if (i <= 0) continue;
            ph += rg;
        }
        this.setPreferredSize(pw, ph);
    }

    public double getChromeHeight() {
        double opad = this.getPadding();
        double ipad = 18.0;
        double hh = 0.0;
        double fh = 0.0;
        BFont font = Theme.widget().getTextFont();
        double ta = font.getAscent();
        double td = font.getDescent();
        double th = font.getHeight();
        if (!this.getLogo().isNull()) {
            hh = this.getLogo().getHeight();
        }
        if (this.getPageNumber()) {
            hh = Math.max(hh, th);
        }
        if (this.getTimestamp()) {
            fh = th;
        }
        if (hh > 0.0) {
            hh += ipad;
        }
        if (fh > 0.0) {
            fh += ipad;
        }
        return hh + fh;
    }

    public void doLayout(BWidget[] kids) {
        double opad = this.getPadding();
        double ipad = 18.0;
        double w = this.getWidth();
        double h = this.getHeight();
        this.computePreferredSize();
        double ph = this.getPreferredHeight();
        if (!this.getScrollBar().isNull()) {
            BScrollBar sb = (BScrollBar)this.getScrollBar();
            sb.computePreferredSize();
            double sbpw = sb.getPreferredWidth();
            sb.setBounds(w - sbpw, 0.0, sbpw, h);
            w -= sbpw;
            sb.setMin(0);
            sb.setMax((int)ph);
            sb.setExtent((int)Math.min(ph, h));
            if ((double)sb.getPosition() > ph - (double)sb.getExtent()) {
                this.yoff = ph - (double)sb.getExtent();
                sb.setPosition((int)this.yoff);
            } else {
                this.yoff = sb.getPosition();
            }
        }
        double cx = opad;
        double cy = opad;
        double ch = h - opad * 2.0;
        double cw = w - opad * 2.0;
        double hh = 0.0;
        double fh = 0.0;
        BFont font = Theme.widget().getTextFont();
        double ta = font.getAscent();
        double td = font.getDescent();
        double th = font.getHeight();
        if (!this.getLogo().isNull()) {
            hh = this.getLogo().getHeight();
            this.logoPos.set(opad, opad);
        }
        if (this.getPageNumber()) {
            hh = Math.max(hh, th);
            String pn = this.getCurrentPageNumber();
            this.pageNumPos.set(w - opad - font.width(pn), ta + opad);
        }
        fh = th;
        if (hh > 0.0) {
            cy += hh + ipad;
            ch -= hh + ipad;
        }
        if (fh > 0.0) {
            ch -= fh + ipad;
        }
        this.layoutContent(cx, cy, cw, ch);
        if (this.getTimestamp()) {
            this.computePreferredSize();
            ph = this.getPreferredHeight();
            String ts = this.getCurrentTimestamp();
            double tsy = this.getScrollBar().isNull() ? h - opad - td : ph - opad - td;
            this.tstampPos.set(w - opad - font.width(ts), tsy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        BFont font = Theme.widget().getTextFont();
        this.paintBackground(g);
        BWidget sb = this.getScrollBar();
        if (!sb.isNull()) {
            this.paintChild(g, sb);
        }
        g.push();
        try {
            g.translate(0.0, -this.yoff);
            if (!this.getLogo().isNull()) {
                g.drawImage(this.getLogo(), this.logoPos.x, this.logoPos.y);
            }
            if (this.getPageNumber()) {
                g.setFont(font);
                g.setBrush(BColor.black);
                g.drawString(this.getCurrentPageNumber(), this.pageNumPos.x, this.pageNumPos.y);
            }
            if (this.getTimestamp()) {
                g.setFont(font);
                g.setBrush(BColor.black);
                g.drawString(this.getCurrentTimestamp(), this.tstampPos.x, this.tstampPos.y);
            }
            BWidget[] w = this.getChildWidgets();
            for (int i = 0; i < w.length; ++i) {
                if (w[i] == sb) continue;
                this.paintChild(g, w[i]);
            }
        }
        finally {
            g.pop();
        }
        this.paintBorder(g);
    }

    public double getPadding() {
        return 36.0;
    }

    protected String getCurrentPageNumber() {
        return lex.getText("pageNumber");
    }

    protected String getCurrentTimestamp() {
        return this.tstamp.toString();
    }

    protected void paintBackground(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(0.0, 0.0, w, h);
    }

    protected void paintBorder(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
    }

    protected void layoutContent(double cx, double cy, double cw, double ch) {
        double rg = this.getRowGap();
        BWidget[] kids = this.getChildWidgets();
        for (int i = 1; i < kids.length; ++i) {
            BWidget w = kids[i];
            w.computePreferredSize();
            double ph = w.getPreferredHeight();
            w.setBounds(cx, cy, cw, ph);
            if (kids[i].getType().is(BLabel.TYPE)) {
                w.computePreferredSize();
                ph = w.getPreferredHeight();
                w.setBounds(cx, cy, cw, ph);
            }
            cy += ph + rg;
        }
    }

    public BWidget childAt(Point pt) {
        BScrollBar sb = (BScrollBar)this.getScrollBar();
        if (sb.contains(pt.x - sb.getX(), pt.y - sb.getY())) {
            return sb;
        }
        return super.childAt(new Point(pt.x, pt.y + this.yoff));
    }

    public Point translateToChild(BWidget child, Point pt) {
        if (child != this.getScrollBar()) {
            pt.translate(0.0, this.yoff);
        }
        return super.translateToChild(child, pt);
    }

    public void mouseWheel(BMouseWheelEvent event) {
        BScrollBar sb = (BScrollBar)this.getScrollBar();
        int wheelUnits = 25;
        sb.scrollByUnits(event.getPreciseWheelRotation() * (double)wheelUnits);
        event.consume();
    }

    public void doVscroll(BScrollEvent event) {
        this.yoff = event.getPosition();
        this.repaint();
    }
}

