/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.pdf;

import com.tridium.pdf.BIPdfWidget;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.PdfUtil;
import com.tridium.report.ui.BReportPane;
import javax.baja.gx.Graphics;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxInclude;

public class BPdfReportPane
extends BReportPane
implements BIPdfWidget {
    public static final Type TYPE = Sys.loadType(BPdfReportPane.class);
    private int pageNum = 1;
    private BAbsTime tstamp = BAbsTime.now();

    @Override
    public Type getType() {
        return TYPE;
    }

    public void fromWidget(BWidget widget, PdfOp op) {
        this.fromWidget(widget, true);
    }

    private void fromWidget(BWidget widget, boolean includeContent) {
        BReportPane reportPane = (BReportPane)widget;
        SlotCursor c = reportPane.getProperties();
        BPdfFlowPane flow = new BPdfFlowPane();
        while (c.next()) {
            Property prop = c.property();
            if (prop.getType().is(BWidget.TYPE)) {
                if (prop.getName().equals("scrollBar") || !includeContent) continue;
                BWidget child = (BWidget)reportPane.get(prop);
                if (child instanceof BPxInclude) {
                    BPxInclude px = (BPxInclude)child;
                    px.computePreferredSize();
                    BWidget[] childWidgets = px.getChildWidgets();
                    for (int i = 0; i < childWidgets.length; ++i) {
                        BWidget pxChild = childWidgets[i];
                        BWidget pw = PdfUtil.getWidget((BWidget)pxChild, null);
                        if (pw == null) continue;
                        flow.add(null, (BValue)pw);
                    }
                    continue;
                }
                BWidget pw = PdfUtil.getWidget((BWidget)child, null);
                if (pw == null) continue;
                flow.add(null, (BValue)pw);
                continue;
            }
            if (!prop.isFrozen() || this.get(prop.getName()) == null) continue;
            this.set(prop.getName(), reportPane.get(prop));
        }
        flow.repaint();
        if (includeContent) {
            this.add(null, (BValue)flow);
        }
        this.setScrollBar((BWidget)new BNullWidget());
    }

    public BWidget getToFit(double width, double h) {
        BWidget[] kids = this.getChildWidgets();
        BPdfFlowPane flow = (BPdfFlowPane)kids[1];
        BWidget w = flow.getToFit(width, h - this.getChromeHeight());
        if (w != null) {
            BPdfReportPane fit = new BPdfReportPane();
            fit.fromWidget((BWidget)this, false);
            fit.pageNum = this.pageNum++;
            fit.add(null, (BValue)w);
            return fit;
        }
        return null;
    }

    @Override
    public double getPadding() {
        return 0.0;
    }

    @Override
    protected String getCurrentPageNumber() {
        return Integer.toString(this.pageNum);
    }

    @Override
    protected String getCurrentTimestamp() {
        return this.tstamp.toString();
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    protected void layoutContent(double cx, double cy, double cw, double ch) {
        BWidget[] kids = this.getChildWidgets();
        kids[1].setBounds(cx, cy, cw, ch);
    }

    @Override
    public void computePreferredSize() {
        BWidget[] kids = this.getChildWidgets();
        kids[1].computePreferredSize();
        double pw = kids[1].getPreferredWidth();
        double ph = kids[1].getPreferredHeight();
        this.setPreferredSize(pw, ph + this.getChromeHeight());
    }
}

