/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.ui;

import com.tridium.report.grid.ui.GridUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.report.grid.BIGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

public class BGridTable
extends BWbComponentView {
    public static final Property hyperlink = BGridTable.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BFacets.make((String)"chooseView", (BIDataValue)BBoolean.FALSE));
    public static final Type TYPE = Sys.loadType(BGridTable.class);
    private Model model;
    static final BFacets SKIP_LEASE_FACET = BFacets.make((String)"skipSynchronousLease", (boolean)true);

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) {
        GridModel grid = ((BIGrid)value).resolve(value, (Context)new BasicContext(cx, SKIP_LEASE_FACET));
        if (grid.getRowCount() == 0 || grid.getColumnCount() == 0) {
            String text = Lexicon.make((String)"report").getText("emptyGrid");
            BBorderPane b = new BBorderPane((BWidget)new BLabel(text), BBorder.solid);
            b.setFill(Theme.widget().getWindowBackground());
            this.setContent((BWidget)new BBorderPane((BWidget)b, BBorder.inset, BInsets.DEFAULT));
        } else {
            this.model = new Model(grid, cx);
            BTable table = new BTable((TableModel)this.model);
            table.setCellRenderer((TableCellRenderer)new CellRenderer());
            table.setController((TableController)new Controller());
            this.setContent((BWidget)new BBorderPane((BWidget)table, BBorder.inset, BInsets.DEFAULT));
            BComponent[] c = grid.getComponents();
            if (c.length > 0) {
                this.registerForComponentEvents(c, 0);
            }
        }
    }

    public TableModel getTableModel() {
        return this.model;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.model != null) {
            this.model.updateTable();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BOrd hyperlink = BGridTable.this.getHyperlink();
            if (hyperlink.isNull()) {
                return;
            }
            BWbShell shell = BGridTable.this.getWbShell();
            if (shell != null) {
                shell.hyperlink(GridUtil.makeHyperlink(((BGridTable)BGridTable.this).model.grid, row, hyperlink));
            }
        }

        protected void cellMoved(BMouseEvent event, int row, int col) {
            Context cx = BGridTable.this.getCurrentContext();
            BWbShell shell = BGridTable.this.getWbShell();
            if (shell != null) {
                shell.showStatus(GridUtil.getSummary(((BGridTable)BGridTable.this).model.grid, row, col, BGridTable.this.getHyperlink(), false, cx));
            }
        }

        protected void cellExited(BMouseEvent event, int row, int col) {
            BWbShell shell = BGridTable.this.getWbShell();
            if (shell != null) {
                shell.showStatus("");
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int col) {
            BObject obj = ((BGridTable)BGridTable.this).model.grid.getObjectAt(row, col);
            if (!(obj instanceof BComponent)) {
                return;
            }
            BMenu menu = NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)obj.asComponent());
            if (menu.isEnabled()) {
                menu.open((BWidget)this.getTable(), event.getX(), event.getY());
            }
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BObject obj = ((BGridTable)BGridTable.this).model.grid.getObjectAt(cell.row, cell.column);
            BBrush fg = GridUtil.getStatusFg(obj);
            return fg != null ? fg : super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BObject obj = ((BGridTable)BGridTable.this).model.grid.getObjectAt(cell.row, cell.column);
            BBrush bg = GridUtil.getStatusBg(obj);
            return bg != null ? bg : super.getBackground(cell);
        }

        private BBrush b(BSimple s) {
            return ((BColor)s).toBrush();
        }
    }

    public class Model
    extends TableModel {
        GridModel grid;
        Context cx;

        public Model(GridModel grid, Context cx) {
            this.grid = grid;
            this.cx = cx;
        }

        public int getColumnCount() {
            return this.grid.getColumnCount();
        }

        public String getColumnName(int col) {
            return this.grid.getColumnName(col);
        }

        public int getRowCount() {
            return this.grid.getRowCount();
        }

        public Object getValueAt(int row, int col) {
            return GridUtil.getString(this.grid, row, col, this.cx);
        }
    }
}

