/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.ui;

import com.tridium.report.grid.ui.GridUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.report.grid.BIGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

public class BGridLabelPane
extends BWbComponentView {
    public static final Property headerFont = BGridLabelPane.newProperty((int)0, (BValue)Theme.widget().getBoldText(), null);
    public static final Property headerBrush = BGridLabelPane.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property headerAlign = BGridLabelPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property cellFont = BGridLabelPane.newProperty((int)0, (BValue)Theme.widget().getTextFont(), null);
    public static final Property cellBrush = BGridLabelPane.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property cellAlign = BGridLabelPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property firstColumnFont = BGridLabelPane.newProperty((int)0, (BValue)Theme.widget().getTextFont(), null);
    public static final Property firstColumnBrush = BGridLabelPane.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property firstColumnAlign = BGridLabelPane.newProperty((int)0, (BValue)BHalign.left, null);
    public static final Property border = BGridLabelPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property hyperlink = BGridLabelPane.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BFacets.make((String)"chooseView", (BIDataValue)BBoolean.FALSE));
    public static final Type TYPE = Sys.loadType(BGridLabelPane.class);
    public GridModel grid;
    private int colCount = 0;
    private int rowCount = 0;
    private int cw = 0;
    private int ch = 0;

    public BFont getHeaderFont() {
        return (BFont)this.get(headerFont);
    }

    public void setHeaderFont(BFont v) {
        this.set(headerFont, (BValue)v, null);
    }

    public BBrush getHeaderBrush() {
        return (BBrush)this.get(headerBrush);
    }

    public void setHeaderBrush(BBrush v) {
        this.set(headerBrush, (BValue)v, null);
    }

    public BHalign getHeaderAlign() {
        return (BHalign)this.get(headerAlign);
    }

    public void setHeaderAlign(BHalign v) {
        this.set(headerAlign, (BValue)v, null);
    }

    public BFont getCellFont() {
        return (BFont)this.get(cellFont);
    }

    public void setCellFont(BFont v) {
        this.set(cellFont, (BValue)v, null);
    }

    public BBrush getCellBrush() {
        return (BBrush)this.get(cellBrush);
    }

    public void setCellBrush(BBrush v) {
        this.set(cellBrush, (BValue)v, null);
    }

    public BHalign getCellAlign() {
        return (BHalign)this.get(cellAlign);
    }

    public void setCellAlign(BHalign v) {
        this.set(cellAlign, (BValue)v, null);
    }

    public BFont getFirstColumnFont() {
        return (BFont)this.get(firstColumnFont);
    }

    public void setFirstColumnFont(BFont v) {
        this.set(firstColumnFont, (BValue)v, null);
    }

    public BBrush getFirstColumnBrush() {
        return (BBrush)this.get(firstColumnBrush);
    }

    public void setFirstColumnBrush(BBrush v) {
        this.set(firstColumnBrush, (BValue)v, null);
    }

    public BHalign getFirstColumnAlign() {
        return (BHalign)this.get(firstColumnAlign);
    }

    public void setFirstColumnAlign(BHalign v) {
        this.set(firstColumnAlign, (BValue)v, null);
    }

    public BBrush getBorder() {
        return (BBrush)this.get(border);
    }

    public void setBorder(BBrush v) {
        this.set(border, (BValue)v, null);
    }

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.grid = ((BIGrid)value).resolve(value, cx);
        if (this.grid.getRowCount() == 0 || this.grid.getColumnCount() == 0) {
            String text = Lexicon.make((String)"report").getText("emptyGrid");
            this.setContent((BWidget)new BLabel(text));
        } else {
            BComponent[] c = this.grid.getComponents();
            if (c.length > 0) {
                this.registerForComponentEvents(c, 0);
            }
            this.relayout();
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.grid != null) {
            this.repaint();
        }
    }

    public void computePreferredSize() {
        if (this.grid == null) {
            this.setPreferredSize(100.0, 100.0);
            return;
        }
        int cc = this.grid.getColumnCount();
        int rc = this.grid.getRowCount();
        Context cx = this.getCurrentContext();
        double pw = 0.0;
        double ph = this.getHeaderFont().getHeight();
        ph += (double)rc * (this.getCellFont().getHeight() + 5.0);
        double mw = 0.0;
        for (int i = 0; i < cc; ++i) {
            double dw = this.getHeaderFont().width(this.grid.getColumnName(i));
            for (int j = 0; j < rc; ++j) {
                String text = GridUtil.getString(this.grid, j, i, cx);
                dw = Math.max(dw, this.getCellFont().width(text));
            }
            mw = Math.max(mw, dw);
        }
        pw = mw * (double)cc + (double)(3 * (cc - 1));
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        if (this.grid == null) {
            return;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        this.colCount = this.grid.getColumnCount();
        this.rowCount = this.grid.getRowCount() + 1;
        this.cw = (int)(w / (double)this.colCount);
        this.ch = (int)(h / (double)this.rowCount);
    }

    public void paint(Graphics g) {
        if (this.grid == null) {
            super.paint(g);
            return;
        }
        Context cx = this.getCurrentContext();
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.grid.getRowCount() == 0 || this.grid.getColumnCount() == 0) {
            String text = Lexicon.make((String)"report").getText("emptyGrid");
            BFont font = Theme.widget().getTextFont();
            double tx = (w - font.width(text)) / 2.0;
            double ty = (h - font.getHeight()) / 2.0;
            g.setFont(font);
            g.setBrush(BColor.black);
            g.drawString(text, tx, ty);
        } else {
            BHalign align;
            String text;
            int i;
            double dx = 0.0;
            double dy = 0.0;
            double tx = 0.0;
            double ty = 0.0;
            BBrush border = this.getBorder();
            if (!border.isNull()) {
                g.setBrush(border);
                g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
            }
            BFont font = this.getHeaderFont();
            g.setFont(font);
            for (i = 0; i < this.colCount; ++i) {
                text = this.grid.getColumnName(i);
                BHalign bHalign = align = i == 0 ? this.getFirstColumnAlign() : this.getHeaderAlign();
                tx = align == BHalign.left ? dx + (double)(border.isNull() ? 0 : 3) : (align == BHalign.right ? dx + (double)this.cw - font.width(text) - (double)(border.isNull() ? 0 : 2) : dx + ((double)this.cw - font.width(text)) / 2.0);
                if (!border.isNull()) {
                    g.setBrush(border);
                    g.strokeLine(dx - 1.0, 0.0, dx - 1.0, h);
                }
                ty = dy + ((double)this.ch - font.getHeight()) / 2.0 + font.getAscent();
                g.setBrush(this.getHeaderBrush());
                g.drawString(text, tx, ty);
                dx += (double)this.cw;
            }
            for (i = 1; i < this.rowCount; ++i) {
                dx = 0.0;
                dy += (double)this.ch;
                if (!border.isNull()) {
                    g.setBrush(border);
                    g.strokeLine(0.0, dy - 1.0, w, dy - 1.0);
                }
                for (int j = 0; j < this.colCount; ++j) {
                    BBrush fg;
                    BObject obj = this.grid.getObjectAt(i - 1, j);
                    text = GridUtil.getString(this.grid, i - 1, j, cx);
                    BBrush bg = GridUtil.getStatusBg(obj);
                    if (bg != null) {
                        g.setBrush(bg);
                        g.fillRect(dx, dy, (double)(this.cw - 1), (double)(this.ch - 1));
                    }
                    if (j == 0) {
                        align = this.getFirstColumnAlign();
                        font = this.getFirstColumnFont();
                        g.setFont(font);
                        fg = GridUtil.getStatusFg(obj);
                        g.setBrush(fg != null ? fg : this.getFirstColumnBrush());
                    } else {
                        align = this.getCellAlign();
                        font = this.getCellFont();
                        g.setFont(font);
                        fg = GridUtil.getStatusFg(obj);
                        g.setBrush(fg != null ? fg : this.getCellBrush());
                    }
                    tx = align == BHalign.left ? dx + (double)(border.isNull() ? 0 : 3) : (align == BHalign.right ? dx + (double)this.cw - font.width(text) - (double)(border.isNull() ? 0 : 2) : dx + ((double)this.cw - font.width(text)) / 2.0);
                    ty = dy + ((double)this.ch - font.getHeight()) / 2.0 + font.getAscent();
                    g.drawString(text, tx, ty);
                    dx += (double)this.cw;
                }
            }
        }
    }

    public void mousePressed(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.doMouseEvent(event);
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.doMouseEvent(event);
        } else {
            BWbShell shell;
            int col = this.getColAt(event.getX());
            int row = this.getRowAt(event.getY());
            if (col == 0 && row >= 0 && !this.getHyperlink().isNull() && (shell = this.getWbShell()) != null) {
                shell.hyperlink(GridUtil.makeHyperlink(this.grid, row, this.getHyperlink()));
            }
        }
    }

    public void mouseMoved(BMouseEvent event) {
        Context cx = this.getCurrentContext();
        BWbShell shell = this.getWbShell();
        int col = this.getColAt(event.getX());
        int row = this.getRowAt(event.getY());
        if (col < 0 || row < 0) {
            this.setMouseCursor(MouseCursor.normal);
            if (shell != null) {
                shell.showStatus("");
            }
        } else {
            boolean link = col == 0 && !this.getHyperlink().isNull();
            this.setMouseCursor(link ? MouseCursor.hand : MouseCursor.normal);
            if (shell != null) {
                shell.showStatus(GridUtil.getSummary(this.grid, row, col, this.getHyperlink(), true, cx));
            }
        }
    }

    public void mouseExited(BMouseEvent event) {
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            shell.showStatus("");
        }
        this.setMouseCursor(MouseCursor.normal);
    }

    private void doMouseEvent(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        int col = this.getColAt(x);
        int row = this.getRowAt(y);
        if (col < 0 || row < 0) {
            return;
        }
        BObject obj = this.grid.getObjectAt(row, col);
        if (!(obj instanceof BComponent)) {
            return;
        }
        BMenu menu = NavMenuUtil.makeActionsMenu((BWidget)this, (BComponent)obj.asComponent());
        if (menu.isEnabled()) {
            menu.open((BWidget)this, x, y);
        }
    }

    private int getColAt(double x) {
        int col = (int)(x / (double)this.cw);
        return col < this.colCount ? col : -1;
    }

    private int getRowAt(double y) {
        if (y < (double)this.ch) {
            return -1;
        }
        int row = (int)(y / (double)this.ch) - 1;
        return row < this.rowCount - 1 ? row : -1;
    }
}

