/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.editor;

import com.tridium.report.grid.BCompGridColumn;
import com.tridium.report.grid.BCompGridRow;
import com.tridium.report.grid.BSingleQueryRow;
import com.tridium.report.grid.BSingleRow;
import com.tridium.report.grid.editor.BComponentGridEditor;
import com.tridium.report.grid.editor.BComponentGridQueryEditor;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BGridEditorPane
extends BTransferWidget {
    public static final Action vscroll = BGridEditorPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Type TYPE = Sys.loadType(BGridEditorPane.class);
    static final BModule module = Sys.getModuleForClass(BGridEditorPane.class);
    static final Lexicon lex = Lexicon.make((String)"report");
    static final BFont font = Theme.widget().getTextFont();
    static final BFont bold = Theme.widget().getBoldText();
    static final BImage warningIcon = BImage.make((String)"module://icons/x16/warning.png");
    private static final String BRUSH_DYNAMIC_ROW_BG = "#FFEBA5";
    private static final String BRUSH_QUERY_BG = "#C8C1FF";
    private static final String QUERY_RESULT_ROW_TEXT = "queryResultRow";
    String defName = lex.getText("compGridEditor.defaultColumnName");
    BFormat defFormat = BFormat.make((String)"%.%");
    BOrd defOrd = BOrd.make((String)"slot:");
    double colWidth;
    double headerHeight;
    double templateHeight;
    double queryHeight;
    double rowHeight;
    int selectedCol = -1;
    int selectedRow = -1;
    boolean mouseDown = false;
    int dragZone = -1;
    int dragCol = -1;
    int dragRow = -1;
    int dragColOrig = -1;
    int dragRowOrig = -1;
    BComponentGridEditor.Model model;
    Command delete;
    BScrollBar vbar = new BScrollBar(BOrientation.vertical);

    public void vscroll(BScrollEvent event) {
        this.invoke(vscroll, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGridEditorPane(BComponentGridEditor.Model model) {
        this.model = model;
        this.delete = new Delete((BWidget)this);
        this.delete.setEnabled(false);
        this.add("vbar", (BValue)this.vbar);
        this.linkTo((BComponent)this.vbar, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public int getColumnAt(double x) {
        int numCols = this.model.getColumnCount();
        if (numCols == 0) {
            return -1;
        }
        if (x < 0.0) {
            return 0;
        }
        int col = (int)(x / this.colWidth);
        if (col >= numCols) {
            col = numCols - 1;
        }
        return col;
    }

    public int getRowAt(double y) {
        if (y < this.headerHeight) {
            return -1;
        }
        if (y < this.headerHeight + this.templateHeight) {
            return -2;
        }
        if (y < this.headerHeight + this.templateHeight + this.queryHeight) {
            return -3;
        }
        int i = (int)((y - this.headerHeight - this.templateHeight - this.queryHeight) / this.rowHeight) + this.vbar.getPosition();
        if (i < this.model.getRowCount()) {
            return i;
        }
        return -4;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        int numCols = this.model.getColumnCount();
        this.colWidth = numCols == 0 ? 0.0 : (double)((int)(w / (double)this.model.getColumnCount()));
        this.headerHeight = bold.getHeight() + font.getHeight() * 2.0 + 10.0;
        this.templateHeight = font.getHeight() + 20.0;
        this.queryHeight = font.getHeight() + 20.0;
        this.rowHeight = font.getHeight() + 10.0;
        this.vbar.computePreferredSize();
        double vw = this.vbar.getPreferredWidth();
        double vy = this.headerHeight + this.templateHeight + this.queryHeight - 1.0;
        double vx = w - vw;
        double vh = h - vy;
        this.vbar.setBounds(vx, vy, vw, vh);
        int rowCount = this.model.getRowCount();
        if (null != this.model.getQuery()) {
            ++rowCount;
        }
        int extent = rowCount;
        int visibleRows = (int)(vh / this.rowHeight);
        if (rowCount > visibleRows) {
            extent = visibleRows;
        }
        this.vbar.setMin(0);
        this.vbar.setMax(rowCount);
        this.vbar.setExtent(extent);
        this.vbar.setBlockIncrement(Math.max(3, visibleRows - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int vpos;
        double rh;
        double ry;
        double w = this.getWidth();
        double h = this.getHeight();
        int numCols = this.model.getColumnCount();
        int numRows = this.model.getRowCount();
        if (numCols == 0) {
            this.paintNoColumns(g);
        }
        for (int i = 0; i < numCols; ++i) {
            g.push();
            try {
                double cw = this.colWidth;
                if (i == numCols - 1) {
                    cw += w - (double)numCols * this.colWidth;
                }
                g.translate((double)i * this.colWidth, 0.0);
                g.clip(0.0, 0.0, cw, this.headerHeight);
                this.paintColumn(g, i, cw);
                continue;
            }
            finally {
                g.pop();
            }
        }
        g.push();
        try {
            g.translate(0.0, this.headerHeight);
            g.clip(0.0, 0.0, w, this.templateHeight);
            this.paintTemplate(g);
        }
        finally {
            g.pop();
        }
        g.push();
        try {
            g.translate(0.0, this.headerHeight + this.templateHeight);
            g.clip(0.0, 0.0, w, this.queryHeight);
            this.paintQuery(g);
        }
        finally {
            g.pop();
        }
        double rectY = this.headerHeight + this.templateHeight + this.queryHeight;
        double rectHeight = this.rowHeight * (double)this.model.getRowCount();
        if (null != this.model.getQuery()) {
            rectHeight += this.rowHeight;
        }
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(0.0, rectY, w, rectHeight);
        if (numRows == 0) {
            this.paintNoRows(g);
        } else {
            g.push();
            try {
                ry = this.headerHeight + this.templateHeight + this.queryHeight;
                rh = h - ry;
                g.translate(0.0, ry);
                g.clip(0.0, 0.0, w, rh);
                vpos = this.vbar.getPosition();
                g.translate(0.0, -((double)vpos * this.rowHeight));
                for (int i = 0; i < numRows; ++i) {
                    g.push();
                    try {
                        g.translate(0.0, (double)i * this.rowHeight);
                        g.clip(0.0, 0.0, w, this.rowHeight);
                        if (this.model.getRow(i) instanceof BSingleQueryRow) continue;
                        this.paintRow(g, i);
                        continue;
                    }
                    finally {
                        g.pop();
                    }
                }
            }
            finally {
                g.pop();
            }
        }
        g.push();
        try {
            ry = this.headerHeight + this.templateHeight + this.queryHeight + this.rowHeight * (double)this.model.getRowCount();
            rh = h - ry;
            g.translate(0.0, ry);
            g.clip(0.0, 0.0, w, rh);
            vpos = this.vbar.getPosition();
            g.translate(0.0, -((double)vpos * this.rowHeight));
            this.paintQueryResultsRow(g);
        }
        finally {
            g.pop();
        }
        this.paintChild(g, (BWidget)this.vbar);
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        if (this.dragZone != -1) {
            g.setBrush(Theme.widget().getDropOkBackground());
            double dy = 0.0;
            double dh = 0.0;
            double dw = w;
            if (this.dragZone == 0) {
                dy = 0.0;
                dh = this.headerHeight;
            } else if (this.dragZone == 1) {
                dy = this.headerHeight - 1.0;
                dh = this.templateHeight + this.queryHeight + 1.0;
            } else {
                dy = this.headerHeight + this.templateHeight + this.queryHeight - 1.0;
                dh = h - dy;
                dw -= this.vbar.getPreferredWidth() - 1.0;
            }
            g.strokeRect(1.0, dy + 1.0, dw - 3.0, dh - 3.0);
            g.strokeRect(2.0, dy + 2.0, dw - 5.0, dh - 5.0);
            g.strokeRect(3.0, dy + 3.0, dw - 7.0, dh - 7.0);
        }
    }

    private void paintNoColumns(Graphics g) {
        double w = this.getWidth();
        double h = this.headerHeight;
        String text = lex.getText("compGridEditor.noColumns");
        double th = Math.max(16.0, bold.getHeight());
        double tx = (w - bold.width(text) - 20.0) / 2.0;
        double ty = (h - th) / 2.0 + bold.getAscent();
        double ix = tx - 20.0;
        double iy = (h - th) / 2.0;
        g.setBrush(Theme.widget().getControlAuxiliary());
        g.fillRect(0.0, 0.0, w, h);
        g.setBrush(BColor.black);
        g.setFont(bold);
        g.drawImage(warningIcon, ix, iy);
        g.drawString(text, tx, ty);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, h - 1.0, w, h - 1.0);
    }

    private void paintNoRows(Graphics g) {
        double w = this.getWidth();
        double y = this.headerHeight + this.templateHeight + this.queryHeight;
        double h = this.getHeight() - y;
        String text = lex.getText("compGridEditor.noRows");
        double th = Math.max(16.0, bold.getHeight());
        double tx = (w - bold.width(text) - 20.0) / 2.0;
        double ty = (h - th) / 2.0 + bold.getAscent();
        double ix = tx - 20.0;
        double iy = (h - th) / 2.0;
        g.setBrush(Theme.widget().getControlBackground());
        g.fillRect(0.0, y, w, h);
        g.setBrush(BColor.black);
        g.setFont(bold);
        g.drawImage(warningIcon, ix, iy);
        g.drawString(text, tx, ty);
    }

    private void paintColumn(Graphics g, int col, double w) {
        double hh = this.headerHeight;
        boolean selected = col == this.selectedCol;
        boolean dragging = col == this.dragCol;
        BBrush bg = Theme.widget().getControlAuxiliary();
        if (selected) {
            bg = Theme.widget().getSelectionBackground();
        }
        if (dragging) {
            bg = Theme.widget().getDropOkBackground();
        }
        BBrush text = BColor.black.toBrush();
        if (selected) {
            text = Theme.widget().getSelectionForeground();
        }
        if (dragging) {
            text = Theme.widget().getDropOkForeground();
        }
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, w, hh);
        BCompGridColumn c = this.model.getColumn(col);
        String name = c.getDisplayName();
        String format = c.getFormat().getFormat();
        String ord = c.getOrd().toString();
        double tx = (w - bold.width(name)) / 2.0;
        double ty = bold.getAscent() + 5.0;
        g.setBrush(text);
        g.setFont(bold);
        g.drawString(name, tx, ty);
        tx = (w - font.width(ord)) / 2.0;
        g.setFont(font);
        g.drawString(ord, tx, ty += font.getHeight());
        tx = (w - font.width(format)) / 2.0;
        g.setFont(font);
        g.drawString(format, tx, ty += font.getHeight());
        g.setBrush(BColor.black);
        g.strokeLine(0.0, hh - 1.0, w - 1.0, hh - 1.0);
        g.strokeLine(w - 1.0, 0.0, w - 1.0, hh);
    }

    private void paintTemplate(Graphics g) {
        double w = this.getWidth();
        double h = this.templateHeight;
        if (this.model.getTemplate() == null) {
            String text = lex.getText("compGridEditor.noTemplate");
            double th = Math.max(16.0, bold.getHeight());
            double tx = (w - bold.width(text) - 20.0) / 2.0;
            double ty = (h - th) / 2.0 + bold.getAscent();
            double ix = tx - 20.0;
            double iy = (h - th) / 2.0;
            g.setBrush(BBrush.make((String)"#ffffc0"));
            g.fillRect(0.0, 0.0, w, h);
            g.setBrush(BColor.black);
            g.setFont(bold);
            g.drawImage(warningIcon, ix, iy);
            g.drawString(text, tx, ty);
        } else {
            boolean selected;
            boolean bl = selected = this.selectedRow == -2;
            if (selected) {
                g.setBrush(Theme.widget().getSelectionBackground());
                g.fillRect(0.0, 0.0, w, h);
            }
            String name = SlotPath.unescape((String)("station:|" + this.model.getTemplate().getSlotPath().toString()));
            double tx = 5.0;
            double ty = 10.0 + font.getAscent();
            if (selected) {
                g.setBrush(Theme.widget().getSelectionForeground());
            } else {
                g.setBrush(BColor.black);
            }
            g.setFont(font);
            g.drawString(name, tx, ty);
        }
        g.setBrush(BColor.black);
        g.strokeLine(0.0, h - 1.0, w, h - 1.0);
    }

    private void paintQuery(Graphics g) {
        double w = this.getWidth();
        double h = this.queryHeight;
        if (this.model.getQuery() == null || this.model.getQuery() == BOrd.NULL) {
            String text = lex.getText("compGridEditor.noQuery");
            double th = Math.max(16.0, bold.getHeight());
            double tx = (w - bold.width(text) - 20.0) / 2.0;
            double ty = (h - th) / 2.0 + bold.getAscent();
            double ix = tx - 20.0;
            double iy = (h - th) / 2.0;
            g.setBrush(BBrush.make((String)BRUSH_QUERY_BG));
            g.fillRect(0.0, 0.0, w, h);
            g.setBrush(BColor.black);
            g.setFont(bold);
            g.drawImage(warningIcon, ix, iy);
            g.drawString(text, tx, ty);
        } else {
            boolean selected;
            boolean bl = selected = this.selectedRow == -3;
            if (selected) {
                g.setBrush(Theme.widget().getSelectionBackground());
                g.fillRect(0.0, 0.0, w, h);
            } else {
                g.setBrush(BBrush.make((String)BRUSH_QUERY_BG));
                g.fillRect(0.0, 0.0, w, h);
            }
            String name = SlotPath.unescape((String)this.model.getQuery().encodeToString());
            double tx = 5.0;
            double ty = 10.0 + font.getAscent();
            if (selected) {
                g.setBrush(Theme.widget().getSelectionForeground());
            } else {
                g.setBrush(BColor.black);
            }
            g.setFont(font);
            g.drawString(name, tx, ty);
        }
        g.setBrush(BColor.black);
        g.strokeLine(0.0, h - 1.0, w, h - 1.0);
    }

    private void paintRow(Graphics g, int row) {
        double w = this.getWidth();
        double h = this.rowHeight;
        boolean selected = row == this.selectedRow;
        boolean dragging = row == this.dragRow;
        BCompGridRow gridRow = this.model.getRow(row);
        if (dragging) {
            g.setBrush(Theme.widget().getDropOkBackground());
            g.fillRect(0.0, 0.0, w, h);
        } else if (selected) {
            g.setBrush(Theme.widget().getSelectionBackground());
            g.fillRect(0.0, 0.0, w, h);
        }
        g.setBrush(row < this.model.getRowCount() - 1 ? Theme.widget().getControlBackground() : BColor.black.toBrush());
        g.strokeLine(0.0, h - 1.0, w, h - 1.0);
        String name = SlotPath.unescape((String)gridRow.toString());
        double tx = 5.0;
        double ty = 5.0 + font.getAscent();
        if (dragging) {
            g.setBrush(Theme.widget().getDropOkForeground());
        } else if (selected) {
            g.setBrush(Theme.widget().getSelectionForeground());
        } else {
            g.setBrush(BColor.black);
        }
        g.setFont(font);
        g.drawString(name, tx, ty);
    }

    private void paintQueryResultsRow(Graphics g) {
        double w = this.getWidth();
        double h = this.rowHeight;
        BOrd query = this.model.getQuery();
        if (null != query && query != BOrd.NULL) {
            g.setBrush(BBrush.make((String)BRUSH_DYNAMIC_ROW_BG));
            g.fillRect(0.0, 0.0, w, h);
            g.setBrush(BColor.black.toBrush());
            g.strokeLine(0.0, h - 1.0, w, h - 1.0);
            double tx = 5.0;
            double ty = 5.0 + font.getAscent();
            g.setFont(font);
            g.drawString(lex.getText(QUERY_RESULT_ROW_TEXT), tx, ty);
        } else {
            g.setBrush(BColor.black.toBrush());
            g.strokeLine(0.0, 0.0, w, 0.0);
        }
    }

    public void doVscroll(BScrollEvent event) {
        this.repaint();
    }

    public void keyReleased(BKeyEvent event) {
        if (event.getKeyCode() == 27) {
            if (this.dragCol != -1 && this.dragCol != this.dragColOrig) {
                this.model.moveColumn(this.dragCol, this.dragColOrig);
                this.selectColumn(this.dragColOrig);
                this.setMouseCursor(MouseCursor.normal);
                this.dragCol = -1;
                this.mouseDown = false;
                this.repaint();
            } else if (this.dragRow != -1 && this.dragRow != this.dragRowOrig) {
                this.model.moveRow(this.dragRow, this.dragRowOrig);
                this.selectRow(this.dragRowOrig);
                this.setMouseCursor(MouseCursor.normal);
                this.dragRow = -1;
                this.mouseDown = false;
                this.repaint();
            }
        } else {
            super.keyReleased(event);
        }
    }

    public void mousePressed(BMouseEvent event) {
        this.requestFocus();
        this.mouseDown = true;
        double mx = event.getX();
        double my = event.getY();
        int col = this.getColumnAt(mx);
        int row = this.getRowAt(my);
        if (row == -1) {
            this.selectColumn(col);
        } else {
            this.selectRow(row);
        }
        this.repaint();
    }

    public void mouseReleased(BMouseEvent event) {
        this.setMouseCursor(MouseCursor.normal);
        if (!this.mouseDown) {
            return;
        }
        double mx = event.getX();
        double my = event.getY();
        if (this.dragCol != -1) {
            this.dragCol = -1;
            this.repaint();
            return;
        }
        if (this.dragRow != -1) {
            this.dragRow = -1;
            this.repaint();
            return;
        }
        boolean doubleClick = event.getClickCount() == 2;
        boolean rightClick = event.isPopupTrigger();
        int col = this.getColumnAt(mx);
        int row = this.getRowAt(my);
        if (rightClick) {
            if (row != -2) {
                BMenu menu = row == -1 ? this.makeColumnPopup(col) : this.makeRowPopup(row);
                menu.open((BWidget)this, mx, my);
            }
        } else if (doubleClick) {
            if (row == -1) {
                if (col != -1) {
                    this.editColumn(col);
                }
            } else if (row == -2) {
                this.editTemplate();
            } else if (row == -3) {
                this.editQuery();
            } else if (row != -4) {
                this.editRow(row);
            }
        }
    }

    public void mouseDragged(BMouseEvent event) {
        if (!this.mouseDown) {
            return;
        }
        double mx = event.getX();
        double my = event.getY();
        int col = this.getColumnAt(mx);
        int row = this.getRowAt(my);
        if (this.dragRow == -2 || this.dragRow == -3 || this.dragRow == -4) {
            return;
        }
        if (this.dragRow != -1) {
            if (row == -4) {
                if (this.model.getRowCount() == 1) {
                    return;
                }
                row = this.model.getRowCount() - 1;
            }
            if (row == -1 || row == -2) {
                row = 0;
            }
        } else if (this.dragCol != -1) {
            row = -1;
        }
        if (row != -1) {
            if (this.dragRow == -1) {
                this.dragRow = row;
                this.dragRowOrig = row;
                if (this.dragRow == -2 || this.dragRow == -3 || this.dragRow == -4) {
                    return;
                }
                this.repaint();
                this.setMouseCursor(MouseCursor.move);
            } else if (this.dragRow != row) {
                this.model.moveRow(this.dragRow, row);
                this.dragRow = row;
                this.selectRow(this.dragRow);
            }
        } else if (this.dragCol == -1) {
            this.dragCol = col;
            this.dragColOrig = col;
            this.repaint();
            this.setMouseCursor(MouseCursor.move);
        } else if (this.dragCol != col) {
            this.model.moveColumn(this.dragCol, col);
            this.dragCol = col;
            this.selectColumn(this.dragCol);
        }
    }

    public void mouseWheel(BMouseWheelEvent event) {
        this.vbar.scrollByUnits(event.getPreciseWheelRotation());
    }

    public BMenu makeColumnPopup(int col) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new AddColumn((BWidget)this, this, col));
        menu.add(null, this.delete);
        return menu;
    }

    public BMenu makeRowPopup(int row) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new AddRow((BWidget)this, this, row));
        if (row >= 0) {
            menu.add(null, this.delete);
        }
        return menu;
    }

    public void editColumn(int index) {
        BCompGridColumn col = this.model.getColumn(index);
        if ((col = this.editColumn(col)) != null) {
            this.model.setColumn(index, col);
        }
    }

    public BCompGridColumn editColumn(BCompGridColumn col) {
        BTextField name = new BTextField(col.getDisplayName(), 40);
        BWbFieldEditor format = BWbFieldEditor.makeFor((BObject)col.getFormat());
        BWbFieldEditor ord = BWbFieldEditor.makeFor((BObject)col.getOrd());
        format.loadValue((BObject)col.getFormat(), this.model.cx);
        ord.loadValue((BObject)col.getOrd(), this.model.cx);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(BGridEditorPane.lex("name")));
        grid.add(null, (BValue)name);
        grid.add(null, (BValue)new BLabel(BGridEditorPane.lex("format")));
        grid.add(null, (BValue)format);
        grid.add(null, (BValue)new BLabel(BGridEditorPane.lex("ord")));
        grid.add(null, (BValue)ord);
        BBorderPane pane = new BBorderPane((BWidget)grid);
        if (1 == BDialog.open((BWidget)this, (String)BGridEditorPane.lex("editColumn"), (Object)pane, (int)3)) {
            try {
                String n = name.getText();
                BFormat f = (BFormat)format.saveValue();
                BOrd o = (BOrd)ord.saveValue();
                col.setDisplayName(n);
                col.setFormat(f);
                col.setOrd(o);
                return col;
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (Object)e);
            }
        }
        return null;
    }

    public void editTemplate() {
        BComponent t = this.model.getTemplate();
        BOrd ord = t == null ? BOrd.NULL : t.getNavOrd().relativizeToSession();
        BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)ord);
        editor.loadValue((BObject)ord, this.model.cx);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(BGridEditorPane.lex("ord")));
        grid.add(null, (BValue)editor);
        BBorderPane pane = new BBorderPane((BWidget)grid);
        if (1 == BDialog.open((BWidget)this, (String)BGridEditorPane.lex("editTemplate"), (Object)pane, (int)3)) {
            try {
                BOrd o = (BOrd)editor.saveValue();
                t = o.resolve(this.model.base).get().asComponent();
                this.model.setTemplate(t);
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (Object)e);
            }
        }
    }

    public void editQuery() {
        BOrd query = this.model.getQuery();
        BComponent base = this.model.getTemplate();
        if (null == base) {
            throw new BajaRuntimeException("Must define Component Grid Template before defining Query");
        }
        query = BComponentGridQueryEditor.open((BWidget)this, (BObject)base, query);
        this.model.setQuery(query);
        this.repaint();
    }

    public void editRow(int index) {
        BCompGridRow row = this.model.getRow(index);
        if ((row = this.editRow(row)) != null) {
            this.model.setRow(index, row);
        }
    }

    public BCompGridRow editRow(BCompGridRow gridRow) {
        BSingleRow row = (BSingleRow)gridRow;
        BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)row.getOrd());
        editor.loadValue((BObject)row.getOrd(), (Context)row.getSlotFacets((Slot)BSingleRow.ord));
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(BGridEditorPane.lex("ord")));
        grid.add(null, (BValue)editor);
        BBorderPane pane = new BBorderPane((BWidget)grid);
        if (1 == BDialog.open((BWidget)this, (String)BGridEditorPane.lex("editRow"), (Object)pane, (int)3)) {
            try {
                BOrd ord = (BOrd)editor.saveValue();
                if (ord.isNull()) {
                    throw new RuntimeException(lex.getText("compGridEditor.ordCannotBeNull"));
                }
                BObject obj = ord.resolve(this.model.base).get();
                if (!(obj instanceof BComponent)) {
                    throw new RuntimeException(lex.getText("compGridEditor.mustChooseBComponent"));
                }
                row.setOrd(ord);
                return row;
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (Object)e);
            }
        }
        return null;
    }

    private void selectColumn(int col) {
        this.selectedCol = col;
        this.selectedRow = -1;
        this.delete.setEnabled(this.selectedCol != -1);
    }

    private void selectRow(int row) {
        this.selectedCol = -1;
        this.selectedRow = row;
        this.delete.setEnabled(this.selectedRow != -2 && this.selectedRow != -3);
    }

    private BCompGridColumn makeNewColumn() {
        BCompGridColumn c = new BCompGridColumn();
        c.setDisplayName(this.defName);
        c.setFormat(this.defFormat);
        c.setOrd(this.defOrd);
        return c;
    }

    public TransferEnvelope getTransferData() throws Exception {
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        return null;
    }

    public CommandArtifact doRename() throws Exception {
        return null;
    }

    public int dragOver(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return 0;
        }
        switch (this.getRowAt(cx.getY())) {
            case -1: {
                this.dragZone = 0;
                break;
            }
            case -2: {
                this.dragZone = 1;
                break;
            }
            default: {
                this.dragZone = 2;
            }
        }
        if (this.model.getTemplate() == null && this.dragZone != 1) {
            this.dragZone = -1;
            this.repaint();
            return 0;
        }
        this.repaint();
        return 16;
    }

    public void dragExit(TransferContext cx) {
        this.dragZone = -1;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        int dz = this.dragZone;
        this.dragZone = -1;
        this.repaint();
        if (dz == 0) {
            return this.insertColumns(cx);
        }
        if (dz == 1) {
            return this.insertTemplate(cx);
        }
        return this.insertRows(cx);
    }

    private CommandArtifact insertColumns(TransferContext cx) throws Exception {
        BComponent template = this.model.getTemplate();
        if (template == null) {
            return null;
        }
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        BCompGridColumn[] cols = new BCompGridColumn[mark.size()];
        for (int i = 0; i < mark.size(); ++i) {
            BComponent c = mark.getValue(i).asComponent();
            String a = c.getNavOrd().relativizeToSession().toString();
            String b = template.getNavOrd().relativizeToSession().toString();
            if (a.length() < b.length() || !a.startsWith(b)) {
                throw new LocalizableException("report", "compGridEditor.notUnderTemplate");
            }
            if (a.equals(b)) {
                cols[i] = new BCompGridColumn();
                cols[i].setDisplayName(lex.getText("compGridEditor.name"));
                cols[i].setFormat(BFormat.make((String)"%displayName%"));
                cols[i].setOrd(BOrd.make((String)"slot:"));
                continue;
            }
            cols[i] = new BCompGridColumn();
            cols[i].setDisplayName(c.getDisplayName(this.model.cx));
            cols[i].setFormat(this.defFormat);
            cols[i].setOrd(BOrd.make((String)("slot:" + a.substring(b.length() + 1))));
        }
        this.selectColumn(this.model.getColumnCount() + (cols.length - 1));
        this.model.addColumns(cols);
        return null;
    }

    private CommandArtifact insertTemplate(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        this.model.setTemplate(mark.getValue(0).asComponent());
        BSingleRow row = new BSingleRow();
        row.setOrd(mark.getValue(0).asComponent().getNavOrd().relativizeToSession());
        this.selectRow(this.model.getRowCount());
        this.model.addRow((BCompGridRow)row);
        return null;
    }

    private CommandArtifact insertRows(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        BSingleRow[] rows = new BSingleRow[mark.size()];
        for (int i = 0; i < mark.size(); ++i) {
            rows[i] = new BSingleRow();
            rows[i].setOrd(mark.getValue(i).asComponent().getNavOrd().relativizeToSession());
        }
        this.selectRow(this.model.getRowCount() + (rows.length - 1));
        this.model.addRows((BCompGridRow[])rows);
        return null;
    }

    static String lex(String key) {
        return lex.getText("compGridEditor." + key);
    }

    static class AddRow
    extends Command {
        BGridEditorPane editor;
        int row;

        public AddRow(BWidget owner, BGridEditorPane editor, int row) {
            super(owner, module, "compGridEditor.commands.addRow");
            this.editor = editor;
            this.row = row;
        }

        public CommandArtifact doInvoke() throws Exception {
            BCompGridRow newRow = this.editor.editRow((BCompGridRow)new BSingleRow());
            if (newRow == null) {
                return null;
            }
            if (this.editor.model.getTemplate() == null) {
                BOrd ord = ((BSingleRow)newRow).getOrd();
                BComponent template = ord.resolve(this.editor.model.base).get().asComponent();
                this.editor.model.setTemplate(template);
            }
            if (this.row < 0) {
                this.editor.selectRow(this.editor.model.getRowCount());
                this.editor.model.addRow(newRow);
            } else {
                this.editor.selectRow(this.editor.selectedRow + 1);
                this.editor.model.addRow(this.row, newRow);
            }
            return null;
        }
    }

    class Delete
    extends Command {
        public Delete(BWidget owner) {
            super(owner, module, "compGridEditor.commands.delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BGridEditorPane.this.selectedRow >= 0) {
                int row = BGridEditorPane.this.selectedRow;
                if (row == BGridEditorPane.this.model.getRowCount() - 1) {
                    BGridEditorPane.this.selectRow(row - 1);
                }
                BGridEditorPane.this.model.removeRow(row);
            } else if (BGridEditorPane.this.selectedCol != -1) {
                int col = BGridEditorPane.this.selectedCol;
                if (col == BGridEditorPane.this.model.getColumnCount() - 1) {
                    BGridEditorPane.this.selectColumn(col - 1);
                }
                BGridEditorPane.this.model.removeColumn(col);
                return null;
            }
            return null;
        }
    }

    static class AddColumn
    extends Command {
        BGridEditorPane editor;
        int col;

        public AddColumn(BWidget owner, BGridEditorPane editor, int col) {
            super(owner, module, "compGridEditor.commands.addColumn");
            this.editor = editor;
            this.col = col;
        }

        public CommandArtifact doInvoke() throws Exception {
            BCompGridColumn newCol = this.editor.makeNewColumn();
            if ((newCol = this.editor.editColumn(newCol)) == null) {
                return null;
            }
            if (this.col < 0) {
                this.editor.selectColumn(this.editor.model.getColumnCount());
                this.editor.model.addColumn(newCol);
            } else {
                this.editor.selectColumn(this.editor.selectedCol + 1);
                this.editor.model.addColumn(this.col, newCol);
            }
            return null;
        }
    }
}

