/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.editor;

import com.tridium.report.grid.BCompGridColumn;
import com.tridium.report.grid.BCompGridRow;
import com.tridium.report.grid.BComponentGrid;
import com.tridium.report.grid.BSingleQueryRow;
import com.tridium.report.grid.editor.BGridEditorPane;
import java.util.ArrayList;
import java.util.List;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BComponentGridEditor
extends BWbView {
    public static final Type TYPE = Sys.loadType(BComponentGridEditor.class);
    static Lexicon lex = Lexicon.make((String)"report");
    Model model;
    BGridEditorPane editor;

    public Type getType() {
        return TYPE;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(lex.getText("ComponentGridEditor.displayName"));
        menu.add(null, (Command)new BGridEditorPane.AddColumn((BWidget)this, this.editor, -1));
        menu.add(null, (Command)new BGridEditorPane.AddRow((BWidget)this, this.editor, -1));
        menu.add(null, this.editor.delete);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, (Command)new BGridEditorPane.AddColumn((BWidget)this, this.editor, -1));
        toolbar.add(null, (Command)new BGridEditorPane.AddRow((BWidget)this, this.editor, -1));
        toolbar.add(null, this.editor.delete);
        return toolbar;
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.model = new Model();
        this.model.base = value;
        this.model.cx = cx;
        this.editor = new BGridEditorPane(this.model);
        BComponentGrid grid = (BComponentGrid)value;
        BOrd ord = grid.getTemplate();
        BOrd query = grid.getQuery();
        if (!ord.isNull()) {
            try {
                int i;
                this.model.setTemplate(ord.resolve(this.model.base).get().asComponent());
                this.model.setQuery(query);
                BCompGridColumn[] cols = grid.getColumns();
                BCompGridRow[] rows = grid.getRows();
                for (i = 0; i < cols.length; ++i) {
                    this.model.addColumn((BCompGridColumn)cols[i].newCopy());
                }
                for (i = 0; i < rows.length; ++i) {
                    BCompGridRow row = rows[i];
                    if (row instanceof BSingleQueryRow) continue;
                    this.model.addRow((BCompGridRow)rows[i].newCopy());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setContent((BWidget)new BBorderPane((BWidget)this.editor, BBorder.inset, BInsets.DEFAULT));
        this.setTransferWidget(this.editor);
    }

    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        int i;
        BComponentGrid grid = (BComponentGrid)value;
        Context tx = Transaction.start((BComponent)grid, (Context)context);
        BComponent template = this.model.getTemplate();
        grid.setTemplate(template == null ? BOrd.NULL : template.getNavOrd().relativizeToSession());
        BOrd query = this.model.getQuery();
        grid.setQuery(query == null ? BOrd.NULL : query);
        BCompGridColumn[] cols = grid.getColumns();
        for (int i2 = 0; i2 < cols.length; ++i2) {
            grid.remove(cols[i2].getPropertyInParent(), tx);
        }
        BCompGridRow[] rows = grid.getRows();
        for (i = 0; i < rows.length; ++i) {
            Property property = rows[i].getPropertyInParent();
            if (null == property) continue;
            grid.remove(property, tx);
        }
        for (i = 0; i < this.model.getColumnCount(); ++i) {
            grid.add(null, (BValue)this.model.getColumn(i), 256, tx);
        }
        for (i = 0; i < this.model.getRowCount(); ++i) {
            BCompGridRow row = this.model.getRow(i);
            grid.add(null, (BValue)row, 256, tx);
        }
        for (i = 0; i < this.model.getQueryResultCount(); ++i) {
            grid.add(null, (BValue)this.model.getQueryResult(i), 256, tx);
        }
        Transaction.end((BComponent)grid, (Context)tx);
        return grid;
    }

    class Model {
        private BComponent template = null;
        private BOrd query = BOrd.NULL;
        private List<BCompGridColumn> cols = new ArrayList<BCompGridColumn>();
        private List<BCompGridRow> rows = new ArrayList<BCompGridRow>();
        private List<BSingleQueryRow> queryResults = new ArrayList<BSingleQueryRow>();
        BObject base;
        Context cx;

        Model() {
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public BCompGridColumn getColumn(int index) {
            return this.cols.get(index);
        }

        public void addColumn(BCompGridColumn col) {
            this.cols.add(col);
            this.update();
        }

        public void addColumns(BCompGridColumn[] cols) {
            for (int i = 0; i < cols.length; ++i) {
                this.cols.add(cols[i]);
            }
            this.update();
        }

        public void addColumn(int index, BCompGridColumn col) {
            if (index > this.cols.size() - 1) {
                this.addColumn(col);
            } else {
                this.cols.add(index + 1, col);
                this.update();
            }
        }

        public void setColumn(int index, BCompGridColumn col) {
            this.cols.set(index, col);
            this.update();
        }

        public void moveColumn(int fromIndex, int toIndex) {
            BCompGridColumn col = this.cols.remove(fromIndex);
            if (toIndex >= this.cols.size()) {
                this.cols.add(col);
            } else {
                this.cols.add(toIndex, col);
            }
            this.update();
        }

        public void removeColumn(int index) {
            if (!this.cols.isEmpty()) {
                this.cols.remove(index);
                this.update();
            }
        }

        public BComponent getTemplate() {
            return this.template;
        }

        public void setTemplate(BComponent template) {
            this.template = template;
            this.update();
        }

        public BOrd getQuery() {
            return this.query;
        }

        public void setQuery(BOrd query) {
            this.query = query;
            this.queryResults = new ArrayList<BSingleQueryRow>();
            this.resolveQuery();
            this.update();
        }

        public void resolveQuery() {
            BITable result;
            if (null != this.query && this.query != BOrd.NULL && null != this.template && null != (result = (BITable)this.query.resolve((BObject)this.template).get())) {
                ColumnList columns = result.getColumns();
                Column column = columns.get(0);
                try (TableCursor c = result.cursor();){
                    while (c.next()) {
                        BOrd ord = BOrd.make((String)c.cell(column).toString());
                        BSingleQueryRow row = new BSingleQueryRow();
                        row.setOrd(ord);
                        this.queryResults.add(row);
                    }
                }
            }
        }

        public int getQueryResultCount() {
            return this.queryResults.size();
        }

        public BCompGridRow getQueryResult(int index) {
            if (index > this.queryResults.size() - 1) {
                return null;
            }
            return (BCompGridRow)this.queryResults.get(index);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public BCompGridRow getRow(int index) {
            return this.rows.get(index);
        }

        public void addRow(BCompGridRow row) {
            this.rows.add(row);
            this.update();
        }

        public void addRows(BCompGridRow[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                this.rows.add(rows[i]);
            }
            this.update();
        }

        public void addRow(int index, BCompGridRow row) {
            if (index > this.rows.size() - 1) {
                this.addRow(row);
            } else {
                this.rows.add(index + 1, row);
                this.update();
            }
        }

        public void setRow(int index, BCompGridRow row) {
            this.rows.set(index, row);
            this.update();
        }

        public void moveRow(int fromIndex, int toIndex) {
            BCompGridRow row = this.rows.remove(fromIndex);
            if (toIndex >= this.rows.size()) {
                this.rows.add(row);
            } else {
                this.rows.add(toIndex, row);
            }
            this.update();
        }

        public void removeRow(int index) {
            if (!this.rows.isEmpty()) {
                this.rows.remove(index);
                this.update();
            }
        }

        public void update() {
            BComponentGridEditor.this.editor.relayout();
            BComponentGridEditor.this.setModified();
        }
    }
}

