/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util.jwt.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.datatypes.BJwtEncAlgorithm;
import com.tridium.mqttClientDriver.util.jwt.token.BToken;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public final class TokenFactory {
    static final Logger log = BGcpAuthenticator.log;

    private TokenFactory() {
    }

    public static BToken update(BToken token, PrivateKey key, BRelTime expirationInterval, BJwtEncAlgorithm alg, String projectId) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        BToken retTok;
        switch (alg.getOrdinal()) {
            case 0: 
            case 1: {
                retTok = TokenFactory.make(token, key, expirationInterval, SignatureAlgorithm.RS256, "RSA", projectId);
                break;
            }
            default: {
                log.severe("JWT Enc Algorithm Unsupported " + alg.getTag());
                retTok = new BToken();
            }
        }
        return retTok;
    }

    private static BToken make(BToken token, PrivateKey key, BRelTime expirationInterval, SignatureAlgorithm algorithm, String keyFactoryType, String projectId) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating JWT with " + (Object)((Object)algorithm));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        BAbsTime now = BAbsTime.now();
        BAbsTime expiration = now.add(expirationInterval);
        JwtBuilder jwtBuilder = Jwts.builder().serializeToJsonWith(new JacksonSerializer(objectMapper)).setIssuedAt(new Date(now.getMillis())).setExpiration(new Date(expiration.getMillis())).setAudience(projectId);
        jwtBuilder.signWith(key, algorithm);
        String tokenValue = jwtBuilder.compact();
        if (token == null) {
            token = new BToken(now, expiration, tokenValue);
        } else {
            token.updateToken(now, expiration, tokenValue);
        }
        return token;
    }
}

