/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util.jwt.token;

import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.util.jwt.token.BTokenParameters;
import com.tridium.mqttClientDriver.util.jwt.token.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="generated", type="BAbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}, flags=11), @NiagaraProperty(name="expires", type="BAbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}, flags=11)})
@NiagaraAction(name="reset", flags=388)
public class BToken
extends BComponent {
    public static final Property generated = BToken.newProperty((int)11, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Property expires = BToken.newProperty((int)11, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Action reset = BToken.newAction((int)388, null);
    public static final Type TYPE = Sys.loadType(BToken.class);
    private String currentToken = "";
    private static final String UNKNOWN_TOKEN = "";

    public BAbsTime getGenerated() {
        return (BAbsTime)this.get(generated);
    }

    public void setGenerated(BAbsTime v) {
        this.set(generated, (BValue)v, null);
    }

    public BAbsTime getExpires() {
        return (BAbsTime)this.get(expires);
    }

    public void setExpires(BAbsTime v) {
        this.set(expires, (BValue)v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BToken() {
    }

    public BToken(BAbsTime generated, BAbsTime expiring, String token) {
        this.updateToken(generated, expiring, token);
    }

    public void updateToken(BAbsTime generated, BAbsTime expiring, String token) {
        this.setGenerated(generated);
        this.setExpires(expiring);
        this.currentToken = token;
    }

    public void doReset() {
        Log.log.fine(() -> String.format("Resetting Token, Generated:%s Expires:%s", this.getGenerated(), this.getExpires()));
        this.currentToken = UNKNOWN_TOKEN;
        this.setGenerated((BAbsTime)generated.getDefaultValue());
        this.setExpires((BAbsTime)expires.getDefaultValue());
    }

    protected final String getToken() {
        return this.currentToken;
    }

    public boolean isValid() {
        boolean valid;
        if (this.currentToken == null || this.currentToken.isEmpty()) {
            valid = false;
            Log.log.finest(() -> "Token invalid");
        } else {
            BRelTime advanceExpiration = this.getTokenParameters().getAdvanceExpiration();
            BAbsTime timeOfExpiration = this.getExpires().subtract(advanceExpiration).add(BRelTime.SECOND);
            valid = BAbsTime.now().isBefore(timeOfExpiration);
        }
        return valid;
    }

    public boolean isParentLegal(BComponent parent) {
        boolean valid = parent.getType().is(BGcpAuthenticator.TYPE);
        if (!valid) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "parent.Token", null);
        }
        return true;
    }

    public BTokenParameters getTokenParameters() {
        return (BTokenParameters)this.getParent();
    }

    public boolean isNavChild() {
        return false;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"lock.png");
    }
}

