/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperty(name="maxQueueSize", type="int", defaultValue="1000", facets={@Facet(name="BFacets.MIN", value="10"), @Facet(name="BFacets.MAX", value="1000")})
public class BMqttWorker
extends BWorker {
    public static final Property maxQueueSize = BMqttWorker.newProperty((int)0, (int)1000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)10), (BFacets)BFacets.make((String)"max", (int)2000)));
    public static final Type TYPE = Sys.loadType(BMqttWorker.class);
    protected CoalesceQueue queue;
    protected Worker worker;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue(this.getMaxQueueSize());
            this.worker = new Worker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    public IFuture postAsync(Runnable r) {
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)r);
        return null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(maxQueueSize) && this.queue != null) {
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }
}

