/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.proxyExt.subscribers;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverDevice;
import com.tridium.mqttClientDriver.clients.INiagaraMessage;
import com.tridium.mqttClientDriver.proxyExt.BMqttClientAbstractProxyExt;
import com.tridium.mqttClientDriver.util.MqttSubscriberTopics;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="subscribe", flags=16), @NiagaraAction(name="unsubscribe", flags=16)})
@NiagaraProperty(name="subscribeOnStart", type="boolean", defaultValue="false", flags=5)
public abstract class BMqttClientAbstractSubscriberPoint
extends BMqttClientAbstractProxyExt {
    public static final Property subscribeOnStart = BMqttClientAbstractSubscriberPoint.newProperty((int)5, (boolean)false, null);
    public static final Action subscribe = BMqttClientAbstractSubscriberPoint.newAction((int)16, null);
    public static final Action unsubscribe = BMqttClientAbstractSubscriberPoint.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BMqttClientAbstractSubscriberPoint.class);
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.subscriber");

    public boolean getSubscribeOnStart() {
        return this.getBoolean(subscribeOnStart);
    }

    public void setSubscribeOnStart(boolean v) {
        this.setBoolean(subscribeOnStart, v, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    public void unsubscribe() {
        this.invoke(unsubscribe, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void readSubscribed() throws Exception {
        String topicToSubscribe = this.getTopic();
        if ((this.getFlagsOfTopic() & 1) == 1) {
            logger.info(this.lex.get("pointAlreadySubscribed"));
            return;
        }
        if (this.checkIfTopicShouldBeSubscribed(topicToSubscribe) && this.nMqttClient != null) {
            this.nMqttClient.subscribe(topicToSubscribe, this.getQoS().getOrdinal());
            this.getSubscriberMap().putTopic(topicToSubscribe, this);
            logger.fine("Subscribed to " + topicToSubscribe);
            this.setFlags((Slot)topic, 1);
            this.setFlags((Slot)qoS, 1);
        }
    }

    public void addToBulkSubscribedLists(ArrayList<String> topics, ArrayList<Integer> qosList) {
        String topicToSubscribe = this.getTopic();
        if (this.checkIfTopicShouldBeSubscribed(topicToSubscribe) && this.nMqttClient != null) {
            topics.add(topicToSubscribe);
            qosList.add(this.getQoS().getOrdinal());
            logger.fine(this.lex.getText("subscribeTopic", new Object[]{topicToSubscribe}));
        }
    }

    public void setFlagsForTopicAndQos() {
        this.getSubscriberMap().putTopic(this.getTopic(), this);
        this.setFlags((Slot)topic, 1);
        this.setFlags((Slot)qoS, 1);
    }

    public void addToBulkUnsubscribedList(ArrayList<String> topics) {
        String topicToUnsubscribe = this.getTopic();
        if (this.nMqttClient != null) {
            topics.add(topicToUnsubscribe);
            logger.fine(this.lex.getText("unsubscribeTopic", new Object[]{topicToUnsubscribe}));
        }
    }

    public void unsetFlagsForTopicAndQos() {
        this.setFlags((Slot)topic, 0);
        this.setFlags((Slot)qoS, 0);
    }

    public void readUnsubscribed() throws Exception {
        String topicToSubscribe = this.getTopic();
        if ((this.getFlagsOfTopic() & 1) == 0) {
            logger.info(this.lex.get("pointAlreadyUnsubscribed"));
            return;
        }
        if (topicToSubscribe == null || "".equals(topicToSubscribe)) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "unsubscribeErrorEmptyTopic");
        }
        if (this.nMqttClient != null) {
            this.nMqttClient.unsubscribe(topicToSubscribe);
            this.getSubscriberMap().removeTopic(topicToSubscribe);
            logger.fine("Unsubscribed " + topicToSubscribe);
            this.setFlags((Slot)topic, 0);
            this.setFlags((Slot)qoS, 0);
        }
    }

    public void doSubscribe() {
        this.setSubscribeOnStart(true);
        this.subscribePoint();
    }

    private void subscribePoint() {
        try {
            this.readSubscribed();
            this.writeOk(this.getWriteValue());
        }
        catch (Exception e) {
            this.writeFail(e.getLocalizedMessage());
            logger.warning(e.getLocalizedMessage());
            return;
        }
    }

    public void doUnsubscribe() {
        this.setSubscribeOnStart(false);
        this.unsubscribePoint();
    }

    private void unsubscribePoint() {
        try {
            this.readUnsubscribed();
            this.writeOk(this.getWriteValue());
        }
        catch (Exception e) {
            this.writeFail(e.getLocalizedMessage());
            logger.warning(e.getLocalizedMessage());
            return;
        }
    }

    private boolean checkIfTopicShouldBeSubscribed(String topic) {
        if (topic == null || "".equals(topic)) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "subscribeErrorEmptyTopic");
        }
        if (this.checkIfTopicIsAlreadySubscribed(topic)) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "clientAlreadySubscribed");
        }
        return true;
    }

    private boolean checkIfTopicIsAlreadySubscribed(String topic) {
        return this.getSubscriberMap().isTopicAlreadySubscribed(topic);
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property == enabled) {
            if (this.getEnabled()) {
                this.subscribePoint();
            } else if (!this.getEnabled()) {
                this.unsubscribePoint();
            }
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.unsetFlagsForTopicAndQos();
    }

    @Override
    public void readSubscribed(Context cx) throws Exception {
        if (this.getSubscribeOnStart()) {
            this.subscribePoint();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getSubscriberMap().removeTopic(this.getTopic());
        if (this.getMqttClientDevice() instanceof BAbstractMqttDriverDevice) {
            if (this.nMqttClient != null && ((BAbstractMqttDriverDevice)this.getMqttClientDevice()).isClientConnectedToBroker()) {
                this.nMqttClient.unsubscribe(this.getTopic());
            }
        } else if (this.nMqttClient != null && ((BAbstractMqttDevice)this.getMqttClientDevice()).isClientConnectedToBroker()) {
            this.nMqttClient.unsubscribe(this.getTopic());
        }
    }

    private MqttSubscriberTopics getSubscriberMap() {
        if (this.getMqttClientDevice() instanceof BAbstractMqttDriverDevice) {
            return ((BAbstractMqttDriverDevice)this.getMqttClientDevice()).getSubscriberMap();
        }
        return ((BAbstractMqttDevice)this.getMqttClientDevice()).getAuthenticator(true).getSubscriberMap();
    }

    @Override
    public boolean addLink() {
        String slotName = "out";
        String subsPropertyName = "subscriberLink";
        String localSlotName = this.getLocalPointSlot().getTag();
        BControlPoint sourcePoint = this.getParentPoint();
        BOrd ord = this.getLocalPoint();
        if (!ord.equals((Object)BOrd.NULL)) {
            Knob[] sourceKnobs;
            BControlPoint targetPoint = (BControlPoint)ord.get((BObject)this);
            BLink newLink = new BLink(sourcePoint.getHandleOrd(), slotName, localSlotName, true);
            for (Knob knob : sourceKnobs = sourcePoint.getKnobs(sourcePoint.getSlot(slotName))) {
                if (!subsPropertyName.equals(knob.getLink().getName())) continue;
                knob.getTargetComponent().remove((BComplex)knob.getLink());
            }
            try {
                targetPoint.add(subsPropertyName, (BValue)newLink, 2);
                newLink.activate();
            }
            catch (Exception e) {
                logger.info(BAbstractMqttDevice.lex.get("couldNotLink") + e.getMessage());
                return false;
            }
            BFacets sourceFacets = sourcePoint.getFacets();
            targetPoint.setFacets(sourceFacets);
            BStatusValue sourceValue = (BStatusValue)sourcePoint.getOutStatusValue().newCopy();
            targetPoint.set(localSlotName, (BValue)sourceValue, null);
            return true;
        }
        return false;
    }

    protected boolean isValidPayload(byte[] byteMsg) {
        return byteMsg != null;
    }

    public abstract void saveValueToPoint(INiagaraMessage var1);

    public int getFlagsOfTopic() {
        return this.getFlags((Slot)topic);
    }
}

