/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.proxyExt.subscribers;

import com.tridium.mqttClientDriver.clients.INiagaraMessage;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BMqttBooleanObjectSubscribeExt
extends BMqttClientAbstractSubscriberPoint {
    public static final Type TYPE = Sys.loadType(BMqttBooleanObjectSubscribeExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void saveValueToPoint(INiagaraMessage message) {
        byte[] byteMsg = message.getMessagePayload();
        if (!this.isValidPayload(byteMsg)) {
            logger.warning("Invalid message.");
            return;
        }
        String msg = new String(message.getMessagePayload());
        try {
            if (!"true".equals(msg) && !"false".equals(msg)) {
                throw new LocalizableRuntimeException("abstractMqttDriver", "invalidBoolSubscriberFormat");
            }
            boolean value = Boolean.valueOf(msg);
            BStatusBoolean val = new BStatusBoolean(value);
            this.readOk((BStatusValue)val);
        }
        catch (Exception e) {
            String exceptionMessage = this.lex.get("invalidBoolSubscriberFormat");
            this.readFail(exceptionMessage);
            logger.fine(exceptionMessage);
        }
    }
}

