/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.point;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverNetwork;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.point.BMqttClientDriverPointFolder;
import com.tridium.mqttClientDriver.proxyExt.BMqttClientAbstractProxyExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.util.ComponentTreeCursor;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BMqttClientDriverPointDeviceExt
extends BPointDeviceExt {
    public static final Type TYPE = Sys.loadType(BMqttClientDriverPointDeviceExt.class);
    private INiagaraMqttClient nMqttClient;

    public Type getType() {
        return TYPE;
    }

    public final BAbstractMqttDriverNetwork getMqttClientDriverNetwork() {
        return (BAbstractMqttDriverNetwork)this.getNetwork();
    }

    public final BDevice getMqttClientDriverDevice() {
        return this.getDevice();
    }

    public Type getDeviceType() {
        if (this.getDevice() instanceof BAbstractMqttDriverDevice) {
            return BAbstractMqttDriverDevice.TYPE;
        }
        return BAbstractMqttDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BMqttClientDriverPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BMqttClientAbstractProxyExt.TYPE;
    }

    public void setMqttClient(INiagaraMqttClient nMqttClient) {
        this.nMqttClient = nMqttClient;
        this.provideMqttClientToChildren();
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NPointManager");
        return list;
    }

    private void provideMqttClientToChildren() {
        ComponentTreeCursor c = new ComponentTreeCursor((BComponent)this, null);
        while (c.next()) {
            BValue value = c.get();
            if (value instanceof BMqttClientDriverPointFolder) {
                BMqttClientDriverPointFolder bMqttClientDriverPointFolder = (BMqttClientDriverPointFolder)value;
                bMqttClientDriverPointFolder.setMqttClient(this.nMqttClient);
                continue;
            }
            if (!(value instanceof BMqttClientAbstractProxyExt)) continue;
            BMqttClientAbstractProxyExt proxyExt = (BMqttClientAbstractProxyExt)value;
            proxyExt.setMqttClient(this.nMqttClient);
        }
    }

    public void added(Property property, Context context) {
        BValue value = this.get(property);
        if (value instanceof BControlPoint) {
            BComponent[] children;
            for (BComponent child : children = ((BComponent)value).getChildComponents()) {
                if (!(child instanceof BMqttClientAbstractProxyExt)) continue;
                BMqttClientAbstractProxyExt proxyExt = (BMqttClientAbstractProxyExt)child;
                proxyExt.initializePoint();
                proxyExt.setMqttClient(this.nMqttClient);
            }
        } else if (value instanceof BMqttClientDriverPointFolder) {
            BMqttClientDriverPointFolder bMqttClientDriverPointFolder = (BMqttClientDriverPointFolder)value;
            bMqttClientDriverPointFolder.setMqttClient(this.nMqttClient);
        }
        super.added(property, context);
    }

    public List<BMqttClientAbstractSubscriberPoint> findThePointTopicIsSubscribedTo(String topic, boolean onlyPerfectMatch) {
        ArrayList<BMqttClientAbstractSubscriberPoint> listBMqttSubscribeExt = new ArrayList<BMqttClientAbstractSubscriberPoint>();
        ComponentTreeCursor cursor = new ComponentTreeCursor((BComponent)this, BMqttClientAbstractSubscriberPoint.TYPE, null);
        while (cursor.next(BMqttClientAbstractSubscriberPoint.class)) {
            BMqttClientAbstractSubscriberPoint subscriberChild = (BMqttClientAbstractSubscriberPoint)cursor.get();
            if (subscriberChild == null) continue;
            String topicSubscribed = subscriberChild.getTopic();
            if ((subscriberChild.getFlagsOfTopic() & 1) == 0 || !subscriberChild.getEnabled()) continue;
            if (onlyPerfectMatch && topicSubscribed.equals(topic)) {
                listBMqttSubscribeExt.add(subscriberChild);
                break;
            }
            if (onlyPerfectMatch || !this.checkForTopicMatching(topicSubscribed, topic)) continue;
            listBMqttSubscribeExt.add(subscriberChild);
        }
        return listBMqttSubscribeExt;
    }

    private boolean checkForTopicMatching(String topicOfPoint, String topicWhereMessageArrived) {
        boolean singleMatching = false;
        boolean multiMatching = false;
        if (topicOfPoint.contains("+")) {
            singleMatching = true;
        }
        if (topicOfPoint.contains("#")) {
            multiMatching = true;
        }
        if (!singleMatching && !multiMatching) {
            return topicOfPoint.equals(topicWhereMessageArrived);
        }
        String[] topicOfPointArr = topicOfPoint.split("/");
        String[] topicWhereMessageArrivedArr = topicWhereMessageArrived.split("/");
        int topicWhereMessageArrivedLength = topicWhereMessageArrivedArr.length;
        for (int index = 0; index < topicOfPointArr.length; ++index) {
            if (index >= topicWhereMessageArrivedLength) {
                return false;
            }
            if (topicWhereMessageArrivedArr[index].equals(topicOfPointArr[index]) || "+".equals(topicOfPointArr[index])) continue;
            return "#".equals(topicOfPointArr[index]);
        }
        return topicOfPointArr.length >= topicWhereMessageArrivedLength;
    }
}

