/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.handler;

import com.tridium.mqttClientDriver.BAbstractMqttCallbackHandler;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.clients.paho.MqttMessagePaho;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.mqttClientDriver.util.MqttSubscriberTopics;
import com.tridium.mqttClientDriver.util.jwt.token.Log;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@NiagaraType
public class BPointCallbackHandler
extends BAbstractMqttCallbackHandler {
    public static final Type TYPE = Sys.loadType(BPointCallbackHandler.class);
    static final Logger log = Log.child("callback");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void handleMessage(String topic, MqttMessage message) {
        BAbstractMqttDevice device = this.getRouter().getAuthenticator().getMqttDevice();
        BPointCallbackHandler.updatePoints(device, topic, message);
    }

    @Override
    public void handleDisconnect(Throwable cause) {
    }

    public static void updatePoints(BAbstractMqttDevice device, String topic, MqttMessage message) {
        MqttSubscriberTopics subscriberMaps = device.getAuthenticator(false).getSubscriberMap();
        MqttMessagePaho pahoMessage = new MqttMessagePaho(message);
        List<BMqttClientAbstractSubscriberPoint> points = subscriberMaps.findAllSubscribedPoints(topic);
        for (BMqttClientAbstractSubscriberPoint subscriberPoint : points) {
            try {
                pahoMessage = new MqttMessagePaho(message);
                subscriberPoint.saveValueToPoint(pahoMessage);
            }
            catch (Exception e) {
                log.warning(BAbstractMqttDevice.lex.get("couldNotSubscribe") + " " + subscriberPoint.getNavOrd());
                if (!log.isLoggable(Level.FINE)) continue;
                log.warning(e.getMessage());
            }
        }
    }
}

