/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.paho;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.generic.IGenericConnectionOptions;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.MqttClientValidations;
import com.tridium.mqttClientDriver.clients.paho.MqttMessagePaho;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import com.tridium.mqttClientDriver.util.MqttActions;
import com.tridium.mqttClientDriver.util.MqttSubscriberTopics;
import com.tridium.nre.util.NamedThreadFactory;
import com.tridium.platcrypto.core.BCertManagerService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttClientPaho
implements INiagaraMqttClient,
MqttCallback {
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.mqttClient");
    private ThreadPoolExecutor executorService;
    private MqttAsyncClient mqttClient;
    private BAbstractMqttDevice device;
    private String ipAddress;
    private int port;
    private boolean cleanSession;
    private boolean enableLWT;
    private String topicLWT;
    private int qosLWT;
    private boolean retainedForLWT;
    private String messageForLWT;
    private int keepAlive;
    private int connectionTimeout;
    private boolean enableSSL;
    private String username;
    private BPassword password;
    private String clientID;
    static boolean pubErrorLogged = false;
    private IGenericConnectionOptions options;
    int corePoolSize = 1;
    int maximumPoolSize = 5;
    int poolKeepAlive = 500;
    public static final int PAHO_PREFIX_LENGTH = 4;

    public MqttClientPaho(IGenericConnectionOptions options) {
        this.options = options;
        this.device = (BAbstractMqttDevice)options.getDevice();
        this.setOptions();
    }

    public static String generateClientId() {
        String clientId = MqttAsyncClient.generateClientId();
        clientId = clientId.substring(4);
        return clientId;
    }

    private void setOptions() {
        MqttClientValidations.getMqttClientValidationsInstance().validateMQTTParams(this.device, this.options);
        this.ipAddress = this.options.getBrokerEndpoint();
        this.port = this.options.getBrokerPort();
        this.cleanSession = ((BAbstractMqttDevice)this.options.getDevice()).getCleanSession();
        this.enableLWT = ((BAbstractMqttDevice)this.options.getDevice()).getEnableLWT();
        this.topicLWT = ((BAbstractMqttDevice)this.options.getDevice()).getTopicForLWT();
        this.qosLWT = ((BAbstractMqttDevice)this.options.getDevice()).getQosForLWT().getOrdinal();
        this.retainedForLWT = ((BAbstractMqttDevice)this.options.getDevice()).getRetainedForLWT();
        this.messageForLWT = ((BAbstractMqttDevice)this.options.getDevice()).getMessageForLWT();
        this.keepAlive = ((BAbstractMqttDevice)this.options.getDevice()).getKeepAlive();
        this.connectionTimeout = ((BAbstractMqttDevice)this.options.getDevice()).getConnectionTimeout();
        this.enableSSL = this.options.getConnectionType() != BMqttConnectionType.Anonymous;
        this.username = this.options.getUsernameAndPassword().getUsername();
        this.password = this.options.getUsernameAndPassword().getPassword();
        this.clientID = this.options.getClientID();
    }

    @Override
    public void connect() throws Exception {
        String url = "";
        this.setOptions();
        url = this.enableSSL ? "ssl://" + this.ipAddress + ":" + this.port : "tcp://" + this.ipAddress + ":" + this.port;
        this.mqttClient = new MqttAsyncClient(url, this.clientID, null);
        this.mqttClient.setCallback(this);
        MqttConnectOptions mqttConnectOptions = this.generateMQTTConnectOptions();
        try {
            IMqttToken tok = this.mqttClient.connect(mqttConnectOptions);
            tok.waitForCompletion();
        }
        catch (Exception ex) {
            logger.warning("Client:" + this.clientID + " not connect " + ex.getMessage());
            throw ex;
        }
        logger.fine("Client:" + this.clientID + " connected.");
        String threadName = "MQTTThreadPool-" + this.clientID;
        this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.poolKeepAlive, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(threadName));
    }

    @Override
    public void subscribe(String[] topics, int[] qosList) throws Exception {
        this.options.setCurrentMqttAction(MqttActions.SUBSCRIBEALL);
        this.mqttClient.subscribe(topics, qosList);
        this.options.setCurrentMqttAction(MqttActions.NONE);
    }

    @Override
    public void unsubscribe(String[] topicsArray) throws Exception {
        this.options.setCurrentMqttAction(MqttActions.UNSUBSCRIBEALL);
        this.mqttClient.unsubscribe(topicsArray);
        this.options.setCurrentMqttAction(MqttActions.NONE);
    }

    @Override
    public void disconnect() throws Exception {
        IMqttToken tok = this.mqttClient.disconnect();
        tok.waitForCompletion();
        logger.fine("Client:" + this.clientID + " disconnected.");
        this.executorService.shutdown();
    }

    @Override
    public Future<String> publish(String topic, int qos, String message, boolean retained) throws Exception {
        if (this.isConnected()) {
            this.options.setCurrentMqttAction(MqttActions.PUBLISH);
            MqttMessage mqttMessage = new MqttMessage(message.getBytes());
            mqttMessage.setQos(qos);
            mqttMessage.setRetained(retained);
            Future<String> future = this.executorService.submit(new MqttPubCallable(this.mqttClient, mqttMessage, topic));
            this.options.setCurrentMqttAction(MqttActions.NONE);
            return future;
        }
        return null;
    }

    @Override
    public void subscribe(String topic, int qos) throws Exception {
        if (this.isConnected()) {
            this.options.setCurrentMqttAction(MqttActions.SUBSCRIBE);
            IMqttToken tok = this.mqttClient.subscribe(topic, qos);
            tok.waitForCompletion();
            this.options.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public void unsubscribe(String topic) throws Exception {
        if (this.isConnected()) {
            this.options.setCurrentMqttAction(MqttActions.UNSUBSCRIBE);
            IMqttToken tok = this.mqttClient.unsubscribe(topic);
            tok.waitForCompletion();
            this.options.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public boolean isConnected() {
        return this.mqttClient != null && this.mqttClient.isConnected();
    }

    private MqttConnectOptions generateMQTTConnectOptions() throws Exception {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setCleanSession(this.cleanSession);
        mqttConnectOptions.setConnectionTimeout(this.connectionTimeout);
        mqttConnectOptions.setKeepAliveInterval(this.keepAlive);
        mqttConnectOptions.setMaxInflight(10000);
        this.setLoginOptions(mqttConnectOptions);
        this.setLastWillAndTestamentOptions(mqttConnectOptions);
        return mqttConnectOptions;
    }

    private void setLoginOptions(MqttConnectOptions mqttConnectOptions) throws Exception {
        if (this.enableSSL) {
            if (this.options.getConnectionType() == BMqttConnectionType.UserLoginOverSSL) {
                mqttConnectOptions.setUserName(this.username);
                mqttConnectOptions.setPassword(this.password.getValue().toCharArray());
            }
            ICryptoManager cryptoManager = CertManagerFactory.getInstance();
            BCertManagerService bCertManagerService = null;
            if (cryptoManager instanceof BCertManagerService) {
                bCertManagerService = (BCertManagerService)cryptoManager;
                SocketFactory socketFactory = bCertManagerService.getClientSocketFactory(new ClientTlsParameters(this.options.getSslVersion().getTag()));
                mqttConnectOptions.setSocketFactory(socketFactory);
            }
        }
    }

    private void setLastWillAndTestamentOptions(MqttConnectOptions mqttConnectOptions) {
        if (this.enableLWT) {
            mqttConnectOptions.setWill(this.topicLWT, this.messageForLWT.getBytes(), this.qosLWT, this.retainedForLWT);
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
        logger.fine(this.options.getClientID() + ": " + cause.getMessage());
        this.device.getMqttClientDriverNetwork().removeClientIdFromList(this.options.getClientID());
        String message = BAbstractMqttDevice.lex.get("connLost");
        this.executorService.shutdown();
        this.device.setStatusMessage(message);
        while (!this.device.isClientConnectedToBroker()) {
            try {
                Thread.sleep(this.device.getConnectionLostWaitingTime().getMillis());
            }
            catch (InterruptedException e) {
                this.device.setStatusMessage(message);
            }
            if (this.options.getCurrentMqttAction() == MqttActions.DISCONNECT) break;
            try {
                this.device.doConnect();
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        if (this.device.isClientConnectedToBroker()) {
            this.executorService.submit(new MqttSubsCallable(this.device, topic, message));
        }
    }

    private static void updatePoints(BAbstractMqttDevice device, String topic, MqttMessage message) {
        MqttSubscriberTopics subscriberMaps = device.getAuthenticator(false).getSubscriberMap();
        try {
            List<BMqttClientAbstractSubscriberPoint> points = subscriberMaps.findAllSubscribedPoints(topic);
            for (BMqttClientAbstractSubscriberPoint subscriberPoint : points) {
                MqttMessagePaho pahoMessage = new MqttMessagePaho(message);
                subscriberPoint.saveValueToPoint(pahoMessage);
            }
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
            logger.warning(BAbstractMqttDevice.lex.get("couldNotSubscribe"));
            return;
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public static class MqttSubsCallable
    implements Callable<String> {
        private String topic;
        private BAbstractMqttDevice device;
        private MqttMessage message;

        public MqttSubsCallable(BAbstractMqttDevice device, String topic, MqttMessage message) {
            this.topic = topic;
            this.device = device;
            this.message = message;
        }

        @Override
        public String call() throws Exception {
            try {
                MqttClientPaho.updatePoints(this.device, this.topic, this.message);
                return this.topic;
            }
            catch (Exception e) {
                logger.fine(e.getMessage());
                return null;
            }
        }
    }

    public static class MqttPubCallable
    implements Callable<String> {
        private MqttAsyncClient mqttClient;
        private MqttMessage mqttMessage;
        private String topic;

        public MqttPubCallable(MqttAsyncClient mqttClient, MqttMessage mqttMessage, String topic) {
            this.mqttClient = mqttClient;
            this.mqttMessage = mqttMessage;
            this.topic = topic;
        }

        @Override
        public String call() throws Exception {
            try {
                if (this.mqttClient != null && this.mqttClient.isConnected()) {
                    this.mqttClient.publish(this.topic, this.mqttMessage);
                }
                return this.topic;
            }
            catch (Exception e) {
                if (!pubErrorLogged) {
                    logger.fine(BAbstractMqttDevice.lex.getText("publishMessageLost", new Object[]{e.getMessage()}));
                    pubErrorLogged = true;
                }
                return null;
            }
        }
    }
}

