/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.generic;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.generic.IGenericConnectionOptions;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.paho.MqttClientPaho;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import com.tridium.ndriver.BNDevice;
import javax.baja.data.BIDataValue;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectionType", type="BMqttConnectionType", defaultValue="BMqttConnectionType.UserLoginOverSSL", facets={@Facet(value="BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", flags=64, facets={@Facet(value="BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="usernameAndPassword", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=64)})
public class BGenericMqttAuthenticator
extends BAbstractMqttAuthenticator
implements IGenericConnectionOptions {
    public static final Property connectionType = BGenericMqttAuthenticator.newProperty((int)0, (BValue)BMqttConnectionType.UserLoginOverSSL, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property sslVersion = BGenericMqttAuthenticator.newProperty((int)64, (BValue)BSslTlsEnum.tlsv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property usernameAndPassword = BGenericMqttAuthenticator.newProperty((int)64, (BValue)new BUsernameAndPassword(), null);
    public static final Type TYPE = Sys.loadType(BGenericMqttAuthenticator.class);
    private BAbstractMqttDevice device;
    private INiagaraMqttClient mqttClientPaho;

    @Override
    public BMqttConnectionType getConnectionType() {
        return (BMqttConnectionType)this.get(connectionType);
    }

    public void setConnectionType(BMqttConnectionType v) {
        this.set(connectionType, (BValue)v, null);
    }

    @Override
    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    @Override
    public BUsernameAndPassword getUsernameAndPassword() {
        return (BUsernameAndPassword)this.get(usernameAndPassword);
    }

    public void setUsernameAndPassword(BUsernameAndPassword v) {
        this.set(usernameAndPassword, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public INiagaraMqttClient connect(BAbstractMqttDevice device) throws Exception {
        this.device = device;
        if (this.mqttClientPaho == null) {
            this.mqttClientPaho = new MqttClientPaho(this);
        }
        if (this.mqttClientPaho != null && !this.mqttClientPaho.isConnected()) {
            this.mqttClientPaho.connect();
        }
        return this.mqttClientPaho;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.mqttClientPaho != null) {
            this.mqttClientPaho.disconnect();
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.getClientID().isEmpty()) {
            this.setClientID(MqttClientPaho.generateClientId());
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.get(connectionType) == BMqttConnectionType.UserLoginOverSSL) {
            this.setFlags((Slot)usernameAndPassword, 64);
            this.setFlags((Slot)sslVersion, 0);
        } else {
            this.setFlags((Slot)usernameAndPassword, 65);
            this.getUsernameAndPassword().setUsername("");
            this.getUsernameAndPassword().setPassword(BPassword.DEFAULT);
            if (this.get(connectionType) != BMqttConnectionType.Anonymous) {
                this.setFlags((Slot)sslVersion, 0);
            } else {
                this.setFlags((Slot)sslVersion, 1);
            }
        }
    }

    @Override
    public void enableAndDisableFields(int flag) {
        this.device.enableAndDisableFields(flag);
        this.setFlags((Slot)brokerEndpoint, flag);
        this.setFlags((Slot)brokerPort, flag);
        this.setFlags((Slot)connectionType, flag);
        this.setFlags((Slot)clientID, flag | 0x40);
        if (this.getConnectionType() == BMqttConnectionType.UserLoginOverSSL && !((BAbstractMqttDevice)this.getDevice()).isClientConnectedToBroker()) {
            this.setFlags((Slot)usernameAndPassword, 64);
        } else {
            this.setFlags((Slot)usernameAndPassword, 65);
        }
        this.setFlags((Slot)sslVersion, flag);
    }

    @Override
    public BNDevice getDevice() {
        return (BNDevice)this.getParent();
    }

    @Override
    public String getCertificateAlias() {
        return null;
    }
}

