/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp.datatypes;

import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.util.jwt.token.Log;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="projectId", type="String", flags=8, defaultValue=""), @NiagaraProperty(name="cloudRegion", type="String", flags=8, defaultValue=""), @NiagaraProperty(name="registryId", type="String", flags=8, defaultValue=""), @NiagaraProperty(name="deviceId", type="String", flags=8, defaultValue=""), @NiagaraProperty(name="clientId", type="String", flags=11, defaultValue="")})
public class BGcpIotParameters
extends BComponent {
    public static final Property projectId = BGcpIotParameters.newProperty((int)8, (String)"", null);
    public static final Property cloudRegion = BGcpIotParameters.newProperty((int)8, (String)"", null);
    public static final Property registryId = BGcpIotParameters.newProperty((int)8, (String)"", null);
    public static final Property deviceId = BGcpIotParameters.newProperty((int)8, (String)"", null);
    public static final Property clientId = BGcpIotParameters.newProperty((int)11, (String)"", null);
    public static final Type TYPE = Sys.loadType(BGcpIotParameters.class);

    public String getProjectId() {
        return this.getString(projectId);
    }

    public void setProjectId(String v) {
        this.setString(projectId, v, null);
    }

    public String getCloudRegion() {
        return this.getString(cloudRegion);
    }

    public void setCloudRegion(String v) {
        this.setString(cloudRegion, v, null);
    }

    public String getRegistryId() {
        return this.getString(registryId);
    }

    public void setRegistryId(String v) {
        this.setString(registryId, v, null);
    }

    public String getDeviceId() {
        return this.getString(deviceId);
    }

    public void setDeviceId(String v) {
        this.setString(deviceId, v, null);
    }

    public String getClientId() {
        return this.getString(clientId);
    }

    public void setClientId(String v) {
        this.setString(clientId, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && (property.equals(projectId) || property.equals(deviceId) || property.equals(registryId) || property.equals(cloudRegion))) {
            this.updateClientId();
        }
    }

    public void started() {
        if (this.isRunning()) {
            this.updateClientId();
        }
    }

    private void updateClientId() {
        if (this.getProjectId().isEmpty() || this.getCloudRegion().isEmpty() || this.getRegistryId().isEmpty() || this.getDeviceId().isEmpty()) {
            Log.log.warning("ProjectID, Cloud Region, RegistryID and DeviceID are required to build a ClientID.");
        } else {
            String mqttClientId = String.format("projects/%s/locations/%s/registries/%s/devices/%s", this.getProjectId(), this.getCloudRegion(), this.getRegistryId(), this.getDeviceId());
            this.setClientId(mqttClientId);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        boolean valid = parent.getType().is(BGcpAuthenticator.TYPE);
        if (!valid) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "parent.IotParams", null);
        }
        return true;
    }

    public boolean isNavChild() {
        return false;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"site.png");
    }
}

