/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.IBasicMqttOptions;
import com.tridium.mqttClientDriver.authenticator.gcp.datatypes.BGcpIotParameters;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.jwt.GcpMqttClient;
import com.tridium.mqttClientDriver.util.jwt.MqttCallExecutor;
import com.tridium.mqttClientDriver.util.jwt.token.BTokenParameters;
import com.tridium.ndriver.BNDevice;
import com.tridium.nre.security.NiagaraBasicPermission;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(override=true, name="clientID", type="String", flags=1, defaultValue="\"\""), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", flags=1), @NiagaraProperty(name="creationDateOfRsaKeys", type="BDate", defaultValue="BDate.NULL", flags=5), @NiagaraProperty(name="expirationDateOfRsaKeys", type="BDate", defaultValue="BDate.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="maxInFlight", type="int", defaultValue="1000", flags=4), @NiagaraProperty(name="gcpIotParameters", type="abstractMqttDriver:GcpIotParameters", defaultValue="new BGcpIotParameters()"), @NiagaraProperty(name="tokenParameters", type="BTokenParameters", defaultValue="new BTokenParameters()")})
@NiagaraActions(value={@NiagaraAction(name="generateRsaKeys", flags=148), @NiagaraAction(name="reconnect", flags=16)})
public class BGcpAuthenticator
extends BAbstractMqttAuthenticator
implements IBasicMqttOptions,
BISecurityDashboardProviderAgent,
BISecurityDashboardProvider {
    public static final Property clientID = BGcpAuthenticator.newProperty((int)1, (String)"", null);
    public static final Property sslVersion = BGcpAuthenticator.newProperty((int)1, (BValue)BSslTlsEnum.tlsv1_2, null);
    public static final Property creationDateOfRsaKeys = BGcpAuthenticator.newProperty((int)5, (BValue)BDate.NULL, null);
    public static final Property expirationDateOfRsaKeys = BGcpAuthenticator.newProperty((int)1, (BValue)BDate.NULL, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property maxInFlight = BGcpAuthenticator.newProperty((int)4, (int)1000, null);
    public static final Property gcpIotParameters = BGcpAuthenticator.newProperty((int)0, (BValue)new BGcpIotParameters(), null);
    public static final Property tokenParameters = BGcpAuthenticator.newProperty((int)0, (BValue)new BTokenParameters(), null);
    public static final Action generateRsaKeys = BGcpAuthenticator.newAction((int)148, null);
    public static final Action reconnect = BGcpAuthenticator.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BGcpAuthenticator.class);
    private final GcpMqttClient mqttClientGoogle = new GcpMqttClient(this);
    public final MqttCallExecutor executor = new MqttCallExecutor();
    private static final String DIRECTORY_NAME = "JwtKeys";
    public static final Logger log = Logger.getLogger("abstractMqttDriver.GcpAuth");
    private static final int THIRTY_DAYS = 30;
    private static final int FIFTEEN_DAYS = 15;

    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    public BDate getCreationDateOfRsaKeys() {
        return (BDate)this.get(creationDateOfRsaKeys);
    }

    public void setCreationDateOfRsaKeys(BDate v) {
        this.set(creationDateOfRsaKeys, (BValue)v, null);
    }

    public BDate getExpirationDateOfRsaKeys() {
        return (BDate)this.get(expirationDateOfRsaKeys);
    }

    public void setExpirationDateOfRsaKeys(BDate v) {
        this.set(expirationDateOfRsaKeys, (BValue)v, null);
    }

    public int getMaxInFlight() {
        return this.getInt(maxInFlight);
    }

    public void setMaxInFlight(int v) {
        this.setInt(maxInFlight, v, null);
    }

    public BGcpIotParameters getGcpIotParameters() {
        return (BGcpIotParameters)this.get(gcpIotParameters);
    }

    public void setGcpIotParameters(BGcpIotParameters v) {
        this.set(gcpIotParameters, (BValue)v, null);
    }

    public BTokenParameters getTokenParameters() {
        return (BTokenParameters)this.get(tokenParameters);
    }

    public void setTokenParameters(BTokenParameters v) {
        this.set(tokenParameters, (BValue)v, null);
    }

    public void generateRsaKeys() {
        this.invoke(generateRsaKeys, null, null);
    }

    public void reconnect() {
        this.invoke(reconnect, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public INiagaraMqttClient connect(BAbstractMqttDevice device) throws Exception {
        if (!this.mqttClientGoogle.isConnected() && !device.isFatalFault()) {
            this.mqttClientGoogle.applyOptions(this);
            this.mqttClientGoogle.connect();
            this.getTokenParameters().scheduleReconnect();
        }
        return this.mqttClientGoogle;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.mqttClientGoogle.isConnected()) {
            this.mqttClientGoogle.disconnect();
        } else {
            log.warning("GcpAuthenticator could not disconnect as mqttclient is not currently connected");
        }
    }

    @Override
    public void enableAndDisableFields(int flag) {
        ((BAbstractMqttDevice)this.getDevice()).enableAndDisableFields(flag);
        this.setFlags((Slot)brokerEndpoint, flag);
        this.setFlags((Slot)brokerPort, flag);
    }

    public void doReconnect() {
        if (this.isRunning() && this.getMqttDevice().getEnabled()) {
            new Thread(() -> {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Reconnecting " + this.getMqttDevice().getName());
                }
                this.getMqttDevice().disconnect();
                try {
                    if (this.getMqttClient().isConnected()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, "Interrupted while pausing for reconnect", e);
                }
                this.getMqttDevice().connect();
            }).start();
        }
    }

    public void doGenerateRsaKeys() throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new NiagaraBasicPermission("MQTT_ROLL_KEYS"));
        }
        try {
            AccessController.doPrivileged(() -> {
                this.generateRSAKeys();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.warning("Action to generate RSA keys was not completed. Cause is: " + e.getMessage());
        }
    }

    private void generateRSAKeys() throws Exception {
        KeyPair pair = CertUtils.generateRsaKeyPair((int)2048);
        NKey publicKey = NKey.make((Key)pair.getPublic());
        String publicPem = publicKey.encodeToString();
        NKey privateKey = NKey.make((Key)pair.getPrivate());
        this.writeToPemFile(publicPem);
        this.getTokenParameters().setPrivateKey(BPassword.make((String)privateKey.encodeToString()));
        this.setCreationDateOfRsaKeys(BDate.today());
        this.setExpirationDateOfKeys();
    }

    private void writeToPemFile(String publicPem) throws IOException {
        File JwtKeyFile = new File(this.getDirectoryForJwtKeys(), this.getFileName());
        try (FileWriter fw = new FileWriter(JwtKeyFile);){
            fw.write(publicPem);
        }
    }

    private File getDirectoryForJwtKeys() {
        BComplex parent = this.getDevice().getParent();
        String path = Sys.getStationHome() + File.separator + DIRECTORY_NAME + File.separator + this.getDevice().getNetwork().getName();
        ArrayList<String> component_until_device = new ArrayList<String>();
        while (!(parent instanceof BDeviceNetwork)) {
            component_until_device.add(parent.getName());
            parent = parent.getParent();
        }
        int size = component_until_device.size();
        while (size-- > 0) {
            path = path + File.separator + (String)component_until_device.get(size);
        }
        File dir = new File(path);
        dir.mkdirs();
        return dir;
    }

    private String getFileName() {
        String fileName = this.getDevice().getName();
        return fileName + ".pem";
    }

    private void setExpirationDateOfKeys() {
        BDate expirationDateofKeys = this.getCreationDateOfRsaKeys();
        for (int i = 0; i < this.getTokenParameters().getPrivateKeyExpiration(); ++i) {
            expirationDateofKeys = expirationDateofKeys.nextYear();
        }
        this.setExpirationDateOfRsaKeys(expirationDateofKeys);
    }

    public void started() throws Exception {
        if (this.isRunning()) {
            if (this.getTokenParameters().getPrivateKey() == BPassword.DEFAULT) {
                this.generateRSAKeys();
            }
            log.fine(() -> "Linking to clientId: " + this.getGcpIotParameters().getClientId());
            this.linkTo(this.getGcpIotParameters(), (Slot)BGcpIotParameters.clientId, (Slot)clientID);
        }
        super.started();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BAbstractMqttDevice.TYPE);
    }

    public GcpMqttClient getMqttClient() {
        return this.mqttClientGoogle;
    }

    public BAbstractMqttDevice getMqttDevice() {
        return (BAbstractMqttDevice)this.getDevice();
    }

    @Override
    public BNDevice getDevice() {
        return (BNDevice)this.getParent();
    }

    @Override
    public String getCertificateAlias() {
        return null;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addAuthenticatorKeysItems(items);
        return items;
    }

    private void addAuthenticatorKeysItems(List<SecurityDashboardItem> items) {
        BDate expirationDateOfKeys = this.getExpirationDateOfRsaKeys();
        if (BDate.today().isAfter(expirationDateOfKeys)) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpired.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getName()), BString.make((String)expirationDateOfKeys.toString())}), (String)"securityDashboard.jwtKeysExpired.description"));
        } else if (Math.abs(expirationDateOfKeys.delta(BDate.today())) <= 15) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpiry.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getName()), BString.make((String)expirationDateOfKeys.toString())}), (String)"securityDashboard.jwtKeysExpiry.description"));
        } else if (Math.abs(expirationDateOfKeys.delta(BDate.today())) <= 30) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpiry.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getName()), BString.make((String)expirationDateOfKeys.toString())}), (String)"securityDashboard.jwtKeysExpiry.description"));
        } else {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysValid.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getName()), BString.make((String)expirationDateOfKeys.toString())}), (String)"securityDashboard.jwtKeysValid.description"));
        }
    }
}

