/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.mqtt;

import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import com.amazonaws.services.iot.client.core.AwsIotConnection;
import com.amazonaws.services.iot.client.core.AwsIotMessageCallback;
import com.amazonaws.services.iot.client.core.AwsIotRetryableException;
import com.amazonaws.services.iot.client.mqtt.AwsIotMqttClientListener;
import com.amazonaws.services.iot.client.mqtt.AwsIotMqttConnectionListener;
import com.amazonaws.services.iot.client.mqtt.AwsIotMqttMessageListener;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class AwsIotMqttConnection
extends AwsIotConnection {
    private static final String USERNAME_METRIC_STRING = "?SDK=Java&Version=1.3.13";
    private final SocketFactory socketFactory;
    private MqttAsyncClient mqttClient;
    private AwsIotMqttMessageListener messageListener;
    private AwsIotMqttClientListener clientListener;

    public AwsIotMqttConnection(AbstractAwsIotClient client, SocketFactory socketFactory, String serverUri) throws AWSIotException {
        super(client);
        this.socketFactory = socketFactory;
        this.messageListener = new AwsIotMqttMessageListener(client);
        this.clientListener = new AwsIotMqttClientListener(client);
        try {
            this.mqttClient = new MqttAsyncClient(serverUri, client.getClientId(), new MemoryPersistence());
            this.mqttClient.setCallback(this.clientListener);
        }
        catch (MqttException e) {
            throw new AWSIotException(e);
        }
    }

    AwsIotMqttConnection(AbstractAwsIotClient client, MqttAsyncClient mqttClient) throws AWSIotException {
        super(client);
        this.mqttClient = mqttClient;
        this.socketFactory = null;
    }

    @Override
    public void openConnection(AwsIotMessageCallback callback) throws AWSIotException {
        try {
            AwsIotMqttConnectionListener connectionListener = new AwsIotMqttConnectionListener(this.client, true, callback);
            MqttConnectOptions options = this.buildMqttConnectOptions(this.client, this.socketFactory);
            this.mqttClient.connect(options, null, connectionListener);
        }
        catch (MqttException e) {
            throw new AWSIotException(e);
        }
    }

    @Override
    public void closeConnection(AwsIotMessageCallback callback) throws AWSIotException {
        try {
            AwsIotMqttConnectionListener connectionListener = new AwsIotMqttConnectionListener(this.client, false, callback);
            this.mqttClient.disconnect(0L, null, connectionListener);
        }
        catch (MqttException e) {
            throw new AWSIotException(e);
        }
    }

    @Override
    public void publishMessage(AWSIotMessage message) throws AWSIotException, AwsIotRetryableException {
        String topic = message.getTopic();
        MqttMessage mqttMessage = new MqttMessage(message.getPayload());
        mqttMessage.setQos(message.getQos().getValue());
        try {
            this.mqttClient.publish(topic, mqttMessage, message, this.messageListener);
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32104) {
                throw new AwsIotRetryableException(e);
            }
            throw new AWSIotException(e);
        }
    }

    @Override
    public void subscribeTopic(AWSIotMessage message) throws AWSIotException, AwsIotRetryableException {
        try {
            this.mqttClient.subscribe(message.getTopic(), message.getQos().getValue(), (Object)message, (IMqttActionListener)this.messageListener);
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32104) {
                throw new AwsIotRetryableException(e);
            }
            throw new AWSIotException(e);
        }
    }

    @Override
    public void unsubscribeTopic(AWSIotMessage message) throws AWSIotException, AwsIotRetryableException {
        try {
            this.mqttClient.unsubscribe(message.getTopic(), (Object)message, (IMqttActionListener)this.messageListener);
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32104) {
                throw new AwsIotRetryableException(e);
            }
            throw new AWSIotException(e);
        }
    }

    public Set<String> getServerUris() {
        return new HashSet<String>();
    }

    private MqttConnectOptions buildMqttConnectOptions(AbstractAwsIotClient client, SocketFactory socketFactory) {
        Set<String> serverUris;
        MqttConnectOptions options = new MqttConnectOptions();
        options.setSocketFactory(socketFactory);
        options.setCleanSession(client.isCleanSession());
        options.setConnectionTimeout(client.getConnectionTimeout() / 1000);
        options.setKeepAliveInterval(client.getKeepAliveInterval() / 1000);
        if (client.isClientEnableMetrics()) {
            options.setUserName(USERNAME_METRIC_STRING);
        }
        if ((serverUris = this.getServerUris()) != null && !serverUris.isEmpty()) {
            String[] uriArray = new String[serverUris.size()];
            serverUris.toArray(uriArray);
            options.setServerURIs(uriArray);
        }
        if (client.getWillMessage() != null) {
            AWSIotMessage message = client.getWillMessage();
            options.setWill(message.getTopic(), message.getPayload(), message.getQos().getValue(), false);
        }
        return options;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public MqttAsyncClient getMqttClient() {
        return this.mqttClient;
    }

    public AwsIotMqttMessageListener getMessageListener() {
        return this.messageListener;
    }

    public AwsIotMqttClientListener getClientListener() {
        return this.clientListener;
    }

    public void setMqttClient(MqttAsyncClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setMessageListener(AwsIotMqttMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setClientListener(AwsIotMqttClientListener clientListener) {
        this.clientListener = clientListener;
    }
}

