/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.ws;

import com.tridiumeurope.httpClient.util.HttpConsumable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class WsMessageEvent
implements HttpConsumable {
    private long totalLength;
    private boolean success;
    private final long expectedOutgoingBytes;
    private final long maxBufferSize;
    private final ByteBuffer messageRecordBuffer;
    private final InputStream inputStream;
    private final boolean outbound;

    private WsMessageEvent(long maxBufferSize, InputStream messageInputStream, boolean outbound, long expectedLength) {
        this.maxBufferSize = maxBufferSize;
        this.outbound = outbound;
        this.inputStream = messageInputStream;
        this.expectedOutgoingBytes = expectedLength;
        this.messageRecordBuffer = ByteBuffer.allocate((int)(outbound ? maxBufferSize : expectedLength));
    }

    public static WsMessageEvent outbound(long maxBufferSize, InputStream messageInputStream, long messageBytes) {
        return new WsMessageEvent(maxBufferSize, messageInputStream, true, messageBytes);
    }

    public static WsMessageEvent inbound(String messageReceived) {
        WsMessageEvent messageEvent = new WsMessageEvent(Long.MAX_VALUE, null, false, messageReceived.getBytes(StandardCharsets.UTF_8).length);
        messageEvent.appendToMessageRecord(messageReceived.getBytes(StandardCharsets.UTF_8));
        return messageEvent;
    }

    public String getMessageContent() {
        this.messageRecordBuffer.flip();
        byte[] bytes = new byte[this.messageRecordBuffer.remaining()];
        this.messageRecordBuffer.get(bytes);
        StringBuilder content = new StringBuilder(new String(bytes, StandardCharsets.UTF_8));
        if (this.totalLength > this.maxBufferSize) {
            content.append("...(").append(this.totalLength).append(" bytes in total)");
        }
        return content.toString();
    }

    public long getExpectedOutgoingBytes() {
        return this.expectedOutgoingBytes;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public synchronized void appendToMessageRecord(byte[] toAppend) {
        if (this.messageRecordBuffer.hasRemaining()) {
            this.messageRecordBuffer.put(toAppend, 0, Math.min(toAppend.length, this.messageRecordBuffer.remaining()));
        }
        this.totalLength += (long)toAppend.length;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void succeeded() {
        this.success = true;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isOutbound() {
        return this.outbound;
    }
}

