/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.ws;

import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.auth.BBasicHttpAuth;
import com.tridiumeurope.httpClient.datatypes.auth.BBearerTokenAuth;
import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpMode;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.datatypes.payload.BSlotSource;
import com.tridiumeurope.httpClient.ws.BWebsocketClient;
import javax.baja.sys.BNumber;
import javax.baja.util.BTypeSpec;

public class WebSocketClientBuilder {
    private final BWebsocketClient websocketClient = new BWebsocketClient();

    private WebSocketClientBuilder() {
    }

    public static WebSocketClientBuilder instance() {
        return new WebSocketClientBuilder();
    }

    public WebSocketClientBuilder withAddress(BHttpAddress address) {
        this.websocketClient.setAddress(address);
        return this;
    }

    public WebSocketClientBuilder withAddress(BHttpMode mode, String address, int port, String path) {
        this.websocketClient.setAddress(new BHttpAddress(mode, address, port, path));
        return this;
    }

    public WebSocketClientBuilder withAddress(String address, String path) {
        this.websocketClient.setAddress(new BHttpAddress(BHttpMode.DEFAULT, address, ((BNumber)BHttpAddress.port.getDefaultValue().as(BNumber.class)).getInt(), path));
        return this;
    }

    public WebSocketClientBuilder withHeaders(BHttpHeaders headers) {
        this.websocketClient.setHeaders(headers);
        return this;
    }

    public WebSocketClientBuilder withAuthenticator(BTypeSpec authType) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(authType);
        authenticator.checkAuthenticator();
        this.websocketClient.setAuthenticator(authenticator);
        return this;
    }

    public WebSocketClientBuilder withBasicAuthenticator(String username, String password) {
        this.websocketClient.setAuthenticator(BBasicHttpAuth.createBasicAuthenticator(username, password));
        return this;
    }

    public WebSocketClientBuilder withBearerAuthenticator(String token) {
        this.websocketClient.setAuthenticator(BBearerTokenAuth.createBearerAuthenticator(token));
        return this;
    }

    public WebSocketClientBuilder withMessagePayload(String data) {
        this.websocketClient.getRequestBody().setSourceType(BSlotSource.TYPE.getTypeSpec());
        this.websocketClient.getRequestBody().setSource(BSlotSource.make(data));
        return this;
    }

    public BWebsocketClient build() {
        return this.websocketClient;
    }
}

