/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util.trigger;

import com.tridium.sys.engine.EngineManager;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import com.tridiumeurope.httpClient.util.trigger.BResponseTrigger;
import com.tridiumeurope.httpClient.util.trigger.BTargetClientList;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="targets", type="BTargetClientList", defaultValue="new BTargetClientList()"), @NiagaraProperty(name="delayBetweenEachRequest", type="BRelTime", defaultValue="BRelTime.make(50)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.TRUE"), @Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")})})
public class BResponseChain
extends BResponseTrigger {
    public static final Property targets = BResponseChain.newProperty((int)0, (BValue)new BTargetClientList(), null);
    public static final Property delayBetweenEachRequest = BResponseChain.newProperty((int)0, (BValue)BRelTime.make((long)50L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    public static final Type TYPE = Sys.loadType(BResponseChain.class);
    private BAbsTime nextSend;
    private ChainThread chainThread;
    private final CoalesceQueue queue = new CoalesceQueue();

    public BTargetClientList getTargets() {
        return (BTargetClientList)this.get(targets);
    }

    public void setTargets(BTargetClientList v) {
        this.set(targets, (BValue)v, null);
    }

    public BRelTime getDelayBetweenEachRequest() {
        return (BRelTime)this.get(delayBetweenEachRequest);
    }

    public void setDelayBetweenEachRequest(BRelTime v) {
        this.set(delayBetweenEachRequest, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStation()) {
            this.chainThread = new ChainThread();
            this.chainThread.start();
        }
    }

    public void stopped() {
        if (Sys.isStation() && this.chainThread != null && this.chainThread.isAlive()) {
            this.chainThread.interrupt();
        }
    }

    @Override
    protected void exec(HttpCommResponse response) {
        super.exec(response);
        this.queue.clear();
        this.nextSend = BAbsTime.now().add(this.getDelayBetweenEachRequest());
        this.getTargets().toList().forEach(client -> {
            BComponent clientComp = client.asObject().asComponent();
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Response Chain queueing send for client: " + clientComp.getName(), (Object)this);
            this.queue.enqueue((Object)new ClientSendTask((BIHttpCommClient)client));
        });
    }

    public int queueSize() {
        return this.queue.size();
    }

    static class ClientSendTask
    implements Runnable,
    ICoalesceable {
        private final BIHttpCommClient client;

        ClientSendTask(BIHttpCommClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Request chain sending request for " + this.client.asObject().asComponent().getName(), (Object)this);
            this.client.send();
        }

        public Object getCoalesceKey() {
            return this.client.asObject().asComponent().getHandle();
        }

        public ICoalesceable coalesce(ICoalesceable newObj) {
            return newObj;
        }
    }

    class ChainThread
    extends Thread {
        private ChainThread() {
            super("ResponseChain" + BResponseChain.this.getName());
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Object task;
                    Thread.sleep(EngineManager.engineSleepPeriod * 2L);
                    if (BResponseChain.this.nextSend == null || !BAbsTime.now().isAfter(BResponseChain.this.nextSend) || !((task = BResponseChain.this.queue.dequeue()) instanceof ClientSendTask)) continue;
                    BResponseChain.this.nextSend = BAbsTime.now().add(BResponseChain.this.getDelayBetweenEachRequest());
                    ((ClientSendTask)task).run();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

