/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import java.util.Objects;
import javax.baja.sys.BComplex;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Type;

public final class ParentLegal {
    private static final String MUST_BE_PARENTED_BY_LEX_KEY = "mustBeParentedBy";

    private ParentLegal() {
    }

    public static boolean is(BComplex child, BComplex parent, Type ... expected) {
        Objects.requireNonNull(child);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(expected);
        boolean valid = false;
        for (Type t : expected) {
            if (t == null || !parent.getType().is(t)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            Object[] lexiconArguments = new Object[]{child.getType().getTypeName(), ParentLegal.buildCommaSeparatedListOfTypes(expected), parent.getType().getTypeName()};
            throw new IllegalParentException(child.getType().getModule().getModuleName(), MUST_BE_PARENTED_BY_LEX_KEY, lexiconArguments);
        }
        return true;
    }

    private static String buildCommaSeparatedListOfTypes(Type[] types) {
        StringBuilder expectedParentList = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            expectedParentList.append(types[i]);
            if (i >= types.length - 1) continue;
            expectedParentList.append(", ");
        }
        return expectedParentList.toString();
    }
}

