/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import com.tridium.sys.license.NLicenseManager;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.sys.Sys;

public final class LicenseUtil {
    private static final Logger LOG = Logger.getLogger("httpClient.license");
    private static final String NO_SMA_MSG = HttpClientUtils.LEX.getText("smaExpired");
    public static final String NO_LIC_MSG = HttpClientUtils.LEX.getText("unlicensedWarning");
    public static final String LICENSE_FEATURE_NAME = "http";
    public static final String SMA_EXEMPT_ATTRIBUTE = "sma.exempt";
    public static final String DEVICE_ATTRIBUTE = "device.limit";
    public static final String POINT_ATTRIBUTE = "point.limit";

    private LicenseUtil() {
    }

    public static void licenseCheck() {
        Feature feature = LicenseUtil.getLicense();
        feature.check();
        LicenseUtil.checkSma();
    }

    private static void checkSma() {
        Optional<Long> sma;
        if (!LicenseUtil.isSmaExempt() && (sma = LicenseUtil.getSmaExpiration()).isPresent() && sma.get() < System.currentTimeMillis()) {
            throw new FeatureNotLicensedException(NO_SMA_MSG);
        }
    }

    public static boolean isSmaExempt() {
        return LicenseUtil.checkLicenseAttribute(SMA_EXEMPT_ATTRIBUTE);
    }

    public static Optional<Long> getSmaExpiration() {
        NLicenseManager licenseManager = (NLicenseManager)Sys.getLicenseManager();
        return licenseManager.getLicenseMaintenanceExpiration(Sys.getBajaVendor());
    }

    private static boolean checkLicenseAttribute(String attribute) {
        try {
            return LicenseUtil.getLicense().getb(attribute, false);
        }
        catch (FeatureNotLicensedException fnle) {
            LOG.info("Feature disabled by current license: " + attribute);
        }
        catch (LicenseDatabaseException unexpected) {
            LOG.log(Level.WARNING, "Unexpected error checking license attribute: " + attribute, LOG.isLoggable(Level.FINE) ? unexpected : null);
        }
        return false;
    }

    public static Feature getLicense() {
        return Sys.getLicenseManager().getFeature("tridium", LICENSE_FEATURE_NAME);
    }
}

